/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Clock;
import com.google.api.core.ApiFuture;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.ListUsersPage;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.auth.internal.FirebaseTokenVerifier;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.TaskToApiFuture;
import com.google.firebase.tasks.Task;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseAuth {
    private final GooglePublicKeysManager googlePublicKeysManager;
    private final Clock clock;
    private final FirebaseApp firebaseApp;
    private final GoogleCredentials credentials;
    private final String projectId;
    private final JsonFactory jsonFactory;
    private final FirebaseUserManager userManager;
    private final AtomicBoolean destroyed;
    private final Object lock;
    private static final String SERVICE_ID = FirebaseAuth.class.getName();

    private FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseTokenVerifier.buildGooglePublicKeysManager(firebaseApp.getOptions().getHttpTransport()), Clock.SYSTEM);
    }

    @VisibleForTesting
    FirebaseAuth(FirebaseApp firebaseApp, GooglePublicKeysManager googlePublicKeysManager, Clock clock) {
        this.firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.googlePublicKeysManager = (GooglePublicKeysManager)Preconditions.checkNotNull((Object)googlePublicKeysManager);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.credentials = ImplFirebaseTrampolines.getCredentials(firebaseApp);
        this.projectId = ImplFirebaseTrampolines.getProjectId(firebaseApp);
        this.jsonFactory = firebaseApp.getOptions().getJsonFactory();
        this.userManager = new FirebaseUserManager(firebaseApp);
        this.destroyed = new AtomicBoolean(false);
        this.lock = new Object();
    }

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        FirebaseAuthService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseAuthService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseAuthService(app));
        }
        return (FirebaseAuth)service.getInstance();
    }

    public Task<String> createCustomToken(String uid) {
        return this.createCustomToken(uid, null);
    }

    public Task<String> createCustomToken(final String uid, final Map<String, Object> developerClaims) {
        this.checkNotDestroyed();
        Preconditions.checkState((boolean)(this.credentials instanceof ServiceAccountCredentials), (Object)"Must initialize FirebaseApp with a service account credential to call createCustomToken()");
        final ServiceAccountCredentials serviceAccount = (ServiceAccountCredentials)this.credentials;
        return this.call(new Callable<String>(){

            @Override
            public String call() throws Exception {
                FirebaseTokenFactory tokenFactory = FirebaseTokenFactory.getInstance();
                return tokenFactory.createSignedCustomAuthTokenForUser(uid, developerClaims, serviceAccount.getClientEmail(), serviceAccount.getPrivateKey());
            }
        });
    }

    public ApiFuture<String> createCustomTokenAsync(String uid) {
        return new TaskToApiFuture<String>(this.createCustomToken(uid));
    }

    public ApiFuture<String> createCustomTokenAsync(String uid, Map<String, Object> developerClaims) {
        return new TaskToApiFuture<String>(this.createCustomToken(uid, developerClaims));
    }

    public Task<FirebaseToken> verifyIdToken(String token) {
        return this.verifyIdToken(token, false);
    }

    private Task<FirebaseToken> verifyIdToken(final String token, final boolean checkRevoked) {
        this.checkNotDestroyed();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.projectId) ? 1 : 0) != 0, (Object)"Must initialize FirebaseApp with a project ID to call verifyIdToken()");
        return this.call(new Callable<FirebaseToken>(){

            @Override
            public FirebaseToken call() throws Exception {
                FirebaseTokenVerifier firebaseTokenVerifier = new FirebaseTokenVerifier.Builder().setProjectId(FirebaseAuth.this.projectId).setPublicKeysManager(FirebaseAuth.this.googlePublicKeysManager).setClock(FirebaseAuth.this.clock).build();
                FirebaseToken firebaseToken = FirebaseToken.parse(FirebaseAuth.this.jsonFactory, token);
                firebaseTokenVerifier.verifyTokenAndSignature(firebaseToken.getToken());
                if (checkRevoked) {
                    String uid = firebaseToken.getUid();
                    UserRecord user = FirebaseAuth.this.userManager.getUserById(uid);
                    long issuedAt = (Long)firebaseToken.getClaims().get("iat");
                    if (user.getTokensValidAfterTimestamp() > issuedAt * 1000L) {
                        throw new FirebaseAuthException("id-token-revoked", "Firebase auth token revoked");
                    }
                }
                return firebaseToken;
            }
        });
    }

    private Task<Void> revokeRefreshTokens(String uid) {
        this.checkNotDestroyed();
        int currentTimeSeconds = (int)(System.currentTimeMillis() / 1000L);
        final UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setValidSince(currentTimeSeconds);
        return this.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FirebaseAuth.this.userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return null;
            }
        });
    }

    public ApiFuture<Void> revokeRefreshTokensAsync(String uid) {
        return new TaskToApiFuture<Void>(this.revokeRefreshTokens(uid));
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(String token) {
        return this.verifyIdTokenAsync(token, false);
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(String token, boolean checkRevoked) {
        return new TaskToApiFuture<FirebaseToken>(this.verifyIdToken(token, checkRevoked));
    }

    public Task<UserRecord> getUser(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        return this.call(new Callable<UserRecord>(){

            @Override
            public UserRecord call() throws Exception {
                return FirebaseAuth.this.userManager.getUserById(uid);
            }
        });
    }

    public ApiFuture<UserRecord> getUserAsync(String uid) {
        return new TaskToApiFuture<UserRecord>(this.getUser(uid));
    }

    public Task<UserRecord> getUserByEmail(final String email) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email must not be null or empty");
        return this.call(new Callable<UserRecord>(){

            @Override
            public UserRecord call() throws Exception {
                return FirebaseAuth.this.userManager.getUserByEmail(email);
            }
        });
    }

    public ApiFuture<UserRecord> getUserByEmailAsync(String email) {
        return new TaskToApiFuture<UserRecord>(this.getUserByEmail(email));
    }

    public Task<UserRecord> getUserByPhoneNumber(final String phoneNumber) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phoneNumber) ? 1 : 0) != 0, (Object)"phone number must not be null or empty");
        return this.call(new Callable<UserRecord>(){

            @Override
            public UserRecord call() throws Exception {
                return FirebaseAuth.this.userManager.getUserByPhoneNumber(phoneNumber);
            }
        });
    }

    public ApiFuture<UserRecord> getUserByPhoneNumberAsync(String phoneNumber) {
        return new TaskToApiFuture<UserRecord>(this.getUserByPhoneNumber(phoneNumber));
    }

    private Task<ListUsersPage> listUsers(@Nullable String pageToken, int maxResults) {
        this.checkNotDestroyed();
        final ListUsersPage.PageFactory factory = new ListUsersPage.PageFactory(new ListUsersPage.DefaultUserSource(this.userManager, this.jsonFactory), maxResults, pageToken);
        return this.call(new Callable<ListUsersPage>(){

            @Override
            public ListUsersPage call() throws Exception {
                return factory.create();
            }
        });
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken) {
        return this.listUsersAsync(pageToken, 1000);
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken, int maxResults) {
        return new TaskToApiFuture<ListUsersPage>(this.listUsers(pageToken, maxResults));
    }

    public Task<UserRecord> createUser(final UserRecord.CreateRequest request) {
        this.checkNotDestroyed();
        Preconditions.checkNotNull((Object)request, (Object)"create request must not be null");
        return this.call(new Callable<UserRecord>(){

            @Override
            public UserRecord call() throws Exception {
                String uid = FirebaseAuth.this.userManager.createUser(request);
                return FirebaseAuth.this.userManager.getUserById(uid);
            }
        });
    }

    public ApiFuture<UserRecord> createUserAsync(UserRecord.CreateRequest request) {
        return new TaskToApiFuture<UserRecord>(this.createUser(request));
    }

    public Task<UserRecord> updateUser(final UserRecord.UpdateRequest request) {
        this.checkNotDestroyed();
        Preconditions.checkNotNull((Object)request, (Object)"update request must not be null");
        return this.call(new Callable<UserRecord>(){

            @Override
            public UserRecord call() throws Exception {
                FirebaseAuth.this.userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return FirebaseAuth.this.userManager.getUserById(request.getUid());
            }
        });
    }

    public ApiFuture<UserRecord> updateUserAsync(UserRecord.UpdateRequest request) {
        return new TaskToApiFuture<UserRecord>(this.updateUser(request));
    }

    private Task<Void> setCustomClaims(String uid, Map<String, Object> claims) {
        this.checkNotDestroyed();
        final UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setCustomClaims(claims);
        return this.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FirebaseAuth.this.userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return null;
            }
        });
    }

    public ApiFuture<Void> setCustomUserClaimsAsync(String uid, Map<String, Object> claims) {
        return new TaskToApiFuture<Void>(this.setCustomClaims(uid, claims));
    }

    public Task<Void> deleteUser(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        return this.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FirebaseAuth.this.userManager.deleteUser(uid);
                return null;
            }
        });
    }

    public ApiFuture<Void> deleteUserAsync(String uid) {
        return new TaskToApiFuture<Void>(this.deleteUser(uid));
    }

    private <T> Task<T> call(Callable<T> command) {
        return ImplFirebaseTrampolines.submitCallable(this.firebaseApp, command);
    }

    @VisibleForTesting
    FirebaseUserManager getUserManager() {
        return this.userManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.destroyed.get() ? 1 : 0) != 0, (Object)"FirebaseAuth instance is no longer alive. This happens when the parent FirebaseApp instance has been deleted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed.set(true);
        }
    }

    private static class FirebaseAuthService
    extends FirebaseService<FirebaseAuth> {
        FirebaseAuthService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseAuth(app));
        }

        @Override
        public void destroy() {
            ((FirebaseAuth)this.instance).destroy();
        }
    }
}

