/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.GetAccountInfoResponse;
import java.io.IOException;

class FirebaseUserManager {
    static final String USER_NOT_FOUND_ERROR = "USER_NOT_FOUND_ERROR";
    static final String USER_CREATE_ERROR = "USER_CREATE_ERROR";
    static final String USER_UPDATE_ERROR = "USER_UPDATE_ERROR";
    static final String USER_DELETE_ERROR = "USER_DELETE_ERROR";
    static final String INTERNAL_ERROR = "INTERNAL_ERROR";
    private static final String ID_TOOLKIT_URL = "https://www.googleapis.com/identitytoolkit/v3/relyingparty/";
    private final JsonFactory jsonFactory;
    private final HttpRequestFactory requestFactory;

    FirebaseUserManager(JsonFactory jsonFactory, HttpTransport transport) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory, (Object)"jsonFactory must not be null");
        this.requestFactory = transport.createRequestFactory();
    }

    UserRecord getUserById(String uid, String token) throws FirebaseAuthException {
        GetAccountInfoResponse response;
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)ImmutableList.of((Object)uid));
        try {
            response = this.post("getAccountInfo", token, payload, GetAccountInfoResponse.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "IO error while retrieving user with ID: " + uid, e);
        }
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided user ID: " + uid);
        }
        return new UserRecord(response.getUsers().get(0));
    }

    UserRecord getUserByEmail(String email, String token) throws FirebaseAuthException {
        GetAccountInfoResponse response;
        ImmutableMap payload = ImmutableMap.of((Object)"email", (Object)ImmutableList.of((Object)email));
        try {
            response = this.post("getAccountInfo", token, payload, GetAccountInfoResponse.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "IO error while retrieving user with email: " + email, e);
        }
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided email: " + email);
        }
        return new UserRecord(response.getUsers().get(0));
    }

    String createUser(UserRecord.CreateRequest request, String token) throws FirebaseAuthException {
        String uid;
        GenericJson response;
        try {
            response = this.post("signupNewUser", token, request.getProperties(), GenericJson.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(USER_CREATE_ERROR, "IO error while creating user account", e);
        }
        if (response != null && !Strings.isNullOrEmpty((String)(uid = (String)response.get((Object)"localId")))) {
            return uid;
        }
        throw new FirebaseAuthException(USER_CREATE_ERROR, "Failed to create new user");
    }

    void updateUser(UserRecord.UpdateRequest request, String token) throws FirebaseAuthException {
        GenericJson response;
        try {
            response = this.post("setAccountInfo", token, request.getProperties(), GenericJson.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(USER_UPDATE_ERROR, "IO error while updating user: " + request.getUid(), e);
        }
        if (response == null || !request.getUid().equals(response.get((Object)"localId"))) {
            throw new FirebaseAuthException(USER_UPDATE_ERROR, "Failed to update user: " + request.getUid());
        }
    }

    void deleteUser(String uid, String token) throws FirebaseAuthException {
        GenericJson response;
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)uid);
        try {
            response = this.post("deleteAccount", token, payload, GenericJson.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(USER_DELETE_ERROR, "IO error while deleting user: " + uid, e);
        }
        if (response == null || !response.containsKey((Object)"kind")) {
            throw new FirebaseAuthException(USER_DELETE_ERROR, "Failed to delete user: " + uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T post(String path, String token, Object content, Class<T> clazz) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"path must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"OAuth token must not be null or empty");
        Preconditions.checkNotNull((Object)content, (Object)"content must not be null");
        Preconditions.checkNotNull(clazz, (Object)"response class must not be null");
        GenericUrl url = new GenericUrl(ID_TOOLKIT_URL + path);
        HttpRequest request = this.requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(this.jsonFactory, content));
        request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
        request.getHeaders().setAuthorization("Bearer " + token);
        HttpResponse response = request.execute();
        try {
            Object object = response.parseAs(clazz);
            return (T)object;
        }
        finally {
            response.disconnect();
        }
    }
}

