/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.GoogleOAuthAccessToken;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.json.JSONException;
import org.json.JSONObject;

public class FirebaseCredentials {
    private static final List<String> FIREBASE_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/firebase.database", (Object)"https://www.googleapis.com/auth/userinfo.email");

    private FirebaseCredentials() {
    }

    private static String streamToString(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return CharStreams.toString((Readable)reader);
    }

    @NonNull
    public static FirebaseCredential applicationDefault() {
        return DefaultCredentialsHolder.INSTANCE;
    }

    @VisibleForTesting
    static FirebaseCredential applicationDefault(HttpTransport transport, JsonFactory jsonFactory) {
        return new ApplicationDefaultCredential(transport, jsonFactory);
    }

    @NonNull
    public static FirebaseCredential fromCertificate(InputStream serviceAccount) throws IOException {
        return FirebaseCredentials.fromCertificate(serviceAccount, Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());
    }

    @VisibleForTesting
    static FirebaseCredential fromCertificate(InputStream serviceAccount, HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        return new CertCredential(serviceAccount, transport, jsonFactory);
    }

    @NonNull
    public static FirebaseCredential fromRefreshToken(InputStream refreshToken) throws IOException {
        return FirebaseCredentials.fromRefreshToken(refreshToken, Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());
    }

    @VisibleForTesting
    static FirebaseCredential fromRefreshToken(InputStream refreshToken, HttpTransport transport, JsonFactory jsonFactory) throws IOException {
        return new RefreshTokenCredential(refreshToken, transport, jsonFactory);
    }

    static GoogleOAuthAccessToken newAccessToken(GoogleCredential credential) {
        Preconditions.checkNotNull((Object)credential);
        return new GoogleOAuthAccessToken(credential.getAccessToken(), credential.getExpirationTimeMilliseconds());
    }

    private static class DefaultCredentialsHolder {
        static final FirebaseCredential INSTANCE = FirebaseCredentials.applicationDefault(Utils.getDefaultTransport(), Utils.getDefaultJsonFactory());

        private DefaultCredentialsHolder() {
        }
    }

    static class RefreshTokenCredential
    extends BaseCredential {
        private final String jsonData;

        RefreshTokenCredential(InputStream inputStream, HttpTransport transport, JsonFactory jsonFactory) throws IOException {
            super(transport, jsonFactory);
            this.jsonData = FirebaseCredentials.streamToString((InputStream)Preconditions.checkNotNull((Object)inputStream));
        }

        @Override
        GoogleCredential fetchCredential() throws IOException {
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(this.jsonData.getBytes("UTF-8")), (HttpTransport)this.transport, (JsonFactory)this.jsonFactory);
            if (credential.getServiceAccountId() != null) {
                throw new IOException("Error reading credentials from stream, 'type' value 'authorized_user' not recognized. Expecting 'service_account'.");
            }
            return credential;
        }

        @Override
        GoogleOAuthAccessToken fetchToken(GoogleCredential credential) throws IOException {
            credential.refreshToken();
            return FirebaseCredentials.newAccessToken(credential);
        }
    }

    static class ApplicationDefaultCredential
    extends BaseCredential {
        ApplicationDefaultCredential(HttpTransport transport, JsonFactory jsonFactory) {
            super(transport, jsonFactory);
        }

        @Override
        GoogleCredential fetchCredential() throws IOException {
            return GoogleCredential.getApplicationDefault((HttpTransport)this.transport, (JsonFactory)this.jsonFactory).createScoped((Collection)FIREBASE_SCOPES);
        }

        @Override
        GoogleOAuthAccessToken fetchToken(GoogleCredential credential) throws IOException {
            credential.refreshToken();
            return FirebaseCredentials.newAccessToken(credential);
        }
    }

    static class CertCredential
    extends BaseCredential {
        private final String jsonData;
        private final String projectId;

        CertCredential(InputStream inputStream, HttpTransport transport, JsonFactory jsonFactory) throws IOException {
            super(transport, jsonFactory);
            this.jsonData = FirebaseCredentials.streamToString((InputStream)Preconditions.checkNotNull((Object)inputStream));
            JSONObject jsonObject = new JSONObject(this.jsonData);
            try {
                this.projectId = jsonObject.getString("project_id");
            }
            catch (JSONException e) {
                throw new IOException("Failed to parse service account: 'project_id' must be set", e);
            }
        }

        @Override
        GoogleCredential fetchCredential() throws IOException {
            GoogleCredential firebaseCredential = GoogleCredential.fromStream((InputStream)new ByteArrayInputStream(this.jsonData.getBytes("UTF-8")), (HttpTransport)this.transport, (JsonFactory)this.jsonFactory);
            if (firebaseCredential.getServiceAccountId() == null) {
                throw new IOException("Error reading credentials from stream, 'type' value 'service_account' not recognized. Expecting 'authorized_user'.");
            }
            return firebaseCredential.createScoped((Collection)FIREBASE_SCOPES);
        }

        @Override
        GoogleOAuthAccessToken fetchToken(GoogleCredential credential) throws IOException {
            credential.refreshToken();
            return FirebaseCredentials.newAccessToken(credential);
        }

        Task<String> getProjectId() {
            return Tasks.forResult(this.projectId);
        }
    }

    static abstract class BaseCredential
    implements FirebaseCredential {
        final HttpTransport transport;
        final JsonFactory jsonFactory;
        private GoogleCredential googleCredential;

        BaseCredential(HttpTransport transport, JsonFactory jsonFactory) {
            this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport, (Object)"HttpTransport must not be null");
            this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory, (Object)"JsonFactory must not be null");
        }

        abstract GoogleCredential fetchCredential() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Task<GoogleCredential> getCertificate() {
            BaseCredential baseCredential = this;
            synchronized (baseCredential) {
                if (this.googleCredential != null) {
                    return Tasks.forResult(this.googleCredential);
                }
            }
            return Tasks.call(new Callable<GoogleCredential>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public GoogleCredential call() throws Exception {
                    GoogleCredential credential = BaseCredential.this.fetchCredential();
                    BaseCredential baseCredential = BaseCredential.this;
                    synchronized (baseCredential) {
                        BaseCredential.this.googleCredential = credential;
                    }
                    return credential;
                }
            });
        }

        abstract GoogleOAuthAccessToken fetchToken(GoogleCredential var1) throws IOException;

        @Override
        public final Task<GoogleOAuthAccessToken> getAccessToken() {
            return this.getCertificate().continueWith(new Continuation<GoogleCredential, GoogleOAuthAccessToken>(){

                @Override
                public GoogleOAuthAccessToken then(@NonNull Task<GoogleCredential> task) throws Exception {
                    return BaseCredential.this.fetchToken(task.getResult());
                }
            });
        }
    }
}

