/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection;

import java.util.ArrayList;
import java.util.List;

public class ConnectionUtils {
    public static List<String> stringToPath(String string) {
        ArrayList<String> path = new ArrayList<String>();
        String[] segments = string.split("/");
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i].isEmpty()) continue;
            path.add(segments[i]);
        }
        return path;
    }

    public static String pathToString(List<String> segments) {
        if (segments.isEmpty()) {
            return "/";
        }
        StringBuilder path = new StringBuilder();
        boolean first = true;
        for (String segment : segments) {
            if (!first) {
                path.append("/");
            }
            first = false;
            path.append(segment);
        }
        return path.toString();
    }

    public static Long longFromObject(Object o) {
        if (o instanceof Integer) {
            return (long)((Integer)o);
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return null;
    }

    public static void hardAssert(boolean condition) {
        ConnectionUtils.hardAssert(condition, "", new Object[0]);
    }

    public static void hardAssert(boolean condition, String message, Object ... args) {
        if (!condition) {
            String string = String.valueOf(String.format(message, args));
            throw new AssertionError((Object)(string.length() != 0 ? "hardAssert failed: ".concat(string) : new String("hardAssert failed: ")));
        }
    }
}

