/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.tubesock;

import com.google.firebase.database.tubesock.MessageBuilderFactory;
import com.google.firebase.database.tubesock.WebSocket;
import com.google.firebase.database.tubesock.WebSocketEventHandler;
import com.google.firebase.database.tubesock.WebSocketException;
import com.google.firebase.database.tubesock.WebSocketMessage;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;

class WebSocketReceiver {
    private DataInputStream input = null;
    private WebSocket websocket = null;
    private WebSocketEventHandler eventHandler = null;
    private byte[] inputHeader = new byte[112];
    private MessageBuilderFactory.Builder pendingBuilder;
    private volatile boolean stop = false;

    WebSocketReceiver(WebSocket websocket) {
        this.websocket = websocket;
    }

    void setInput(DataInputStream input) {
        this.input = input;
    }

    void run() {
        this.eventHandler = this.websocket.getEventHandler();
        while (!this.stop) {
            try {
                boolean rsv;
                int offset = 0;
                offset += this.read(this.inputHeader, offset, 1);
                boolean fin = (this.inputHeader[0] & 0x80) != 0;
                boolean bl = rsv = (this.inputHeader[0] & 0x70) != 0;
                if (rsv) {
                    throw new WebSocketException("Invalid frame received");
                }
                byte opcode = (byte)(this.inputHeader[0] & 0xF);
                offset += this.read(this.inputHeader, offset, 1);
                byte length = this.inputHeader[1];
                long payload_length = 0L;
                if (length < 126) {
                    payload_length = length;
                } else if (length == 126) {
                    offset += this.read(this.inputHeader, offset, 2);
                    payload_length = (0xFF & this.inputHeader[2]) << 8 | 0xFF & this.inputHeader[3];
                } else if (length == 127) {
                    offset += this.read(this.inputHeader, offset, 8);
                    payload_length = this.parseLong(this.inputHeader, offset - 8);
                }
                byte[] payload = new byte[(int)payload_length];
                this.read(payload, 0, (int)payload_length);
                if (opcode == 8) {
                    this.websocket.onCloseOpReceived();
                    continue;
                }
                if (opcode == 10) continue;
                if (opcode == 1 || opcode == 2 || opcode == 9 || opcode == 0) {
                    this.appendBytes(fin, opcode, payload);
                    continue;
                }
                throw new WebSocketException(new StringBuilder(24).append("Unsupported opcode: ").append(opcode).toString());
            }
            catch (SocketTimeoutException sto) {
            }
            catch (IOException ioe) {
                this.handleError(new WebSocketException("IO Error", ioe));
            }
            catch (WebSocketException e) {
                this.handleError(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendBytes(boolean fin, byte opcode, byte[] data) {
        if (opcode == 9) {
            if (!fin) throw new WebSocketException("PING must not fragment across frames");
            this.handlePing(data);
            return;
        } else {
            if (this.pendingBuilder != null && opcode != 0) {
                throw new WebSocketException("Failed to continue outstanding frame");
            }
            if (this.pendingBuilder == null && opcode == 0) {
                throw new WebSocketException("Received continuing frame, but there's nothing to continue");
            }
            if (this.pendingBuilder == null) {
                this.pendingBuilder = MessageBuilderFactory.builder(opcode);
            }
            if (!this.pendingBuilder.appendBytes(data)) {
                throw new WebSocketException("Failed to decode frame");
            }
            if (!fin) return;
            WebSocketMessage message = this.pendingBuilder.toMessage();
            this.pendingBuilder = null;
            if (message == null) {
                throw new WebSocketException("Failed to decode whole message");
            }
            this.eventHandler.onMessage(message);
        }
    }

    private void handlePing(byte[] payload) {
        if (payload.length > 125) {
            throw new WebSocketException("PING frame too long");
        }
        this.websocket.pong(payload);
    }

    private long parseLong(byte[] buffer, int offset) {
        return ((long)buffer[offset + 0] << 56) + ((long)(buffer[offset + 1] & 0xFF) << 48) + ((long)(buffer[offset + 2] & 0xFF) << 40) + ((long)(buffer[offset + 3] & 0xFF) << 32) + ((long)(buffer[offset + 4] & 0xFF) << 24) + (long)((buffer[offset + 5] & 0xFF) << 16) + (long)((buffer[offset + 6] & 0xFF) << 8) + (long)((buffer[offset + 7] & 0xFF) << 0);
    }

    private int read(byte[] buffer, int offset, int length) throws IOException {
        this.input.readFully(buffer, offset, length);
        return length;
    }

    void stopit() {
        this.stop = true;
    }

    boolean isRunning() {
        return !this.stop;
    }

    private void handleError(WebSocketException e) {
        this.stopit();
        this.websocket.handleReceiverError(e);
    }
}

