/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.FirebaseAppLifecycleListener;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.internal.AuthStateListener;
import com.google.firebase.internal.Base64Utils;
import com.google.firebase.internal.FirebaseAppStore;
import com.google.firebase.internal.FirebaseExecutors;
import com.google.firebase.internal.GetTokenResult;
import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.Joiner;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Objects;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.Task;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final long TOKEN_REFRESH_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(55L);
    private static final TokenRefresher.Factory DEFAULT_TOKEN_REFRESHER_FACTORY = new TokenRefresher.Factory();
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    static final Map<String, FirebaseApp> sInstances = new HashMap<String, FirebaseApp>();
    private final String mName;
    private final FirebaseOptions mOptions;
    private final TokenRefresher mTokenRefresher;
    private final AtomicBoolean mDeleted = new AtomicBoolean();
    private final List<FirebaseAppLifecycleListener> mLifecycleListeners = new CopyOnWriteArrayList<FirebaseAppLifecycleListener>();
    private final List<AuthStateListener> mAuthStateListeners = new ArrayList<AuthStateListener>();
    private final AtomicReference<GetTokenResult> mCurrentToken = new AtomicReference();

    @NonNull
    public String getName() {
        this.checkNotDeleted();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.checkNotDeleted();
        return this.mOptions;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)o).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.mName).add("options", this.mOptions).toString();
    }

    public static List<FirebaseApp> getApps() {
        return new ArrayList<FirebaseApp>(sInstances.values());
    }

    @Nullable
    public static FirebaseApp getInstance() {
        return FirebaseApp.getInstance(DEFAULT_APP_NAME);
    }

    public static FirebaseApp getInstance(@NonNull String name) {
        Object object = sLock;
        synchronized (object) {
            String availableAppNamesMessage;
            FirebaseApp firebaseApp = sInstances.get(FirebaseApp.normalize(name));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> availableAppNames = FirebaseApp.getAllAppNames();
            if (availableAppNames.isEmpty()) {
                availableAppNamesMessage = "";
            } else {
                String string = String.valueOf(Joiner.on(", ").join(availableAppNames));
                availableAppNamesMessage = string.length() != 0 ? "Available app names: ".concat(string) : new String("Available app names: ");
            }
            String errorMessage = String.format("FirebaseApp with name %s doesn't exist. %s", name, availableAppNamesMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    public static FirebaseApp initializeApp(FirebaseOptions options) {
        return FirebaseApp.initializeApp(options, DEFAULT_APP_NAME);
    }

    public static FirebaseApp initializeApp(FirebaseOptions options, String name) {
        return FirebaseApp.initializeApp(options, name, DEFAULT_TOKEN_REFRESHER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FirebaseApp initializeApp(FirebaseOptions options, String name, TokenRefresher.Factory tokenRefresherFactory) {
        FirebaseApp firebaseApp;
        FirebaseAppStore appStore = FirebaseAppStore.initialize();
        String normalizedName = FirebaseApp.normalize(name);
        Object object = sLock;
        synchronized (object) {
            Preconditions.checkState(!sInstances.containsKey(normalizedName), new StringBuilder(33 + String.valueOf(normalizedName).length()).append("FirebaseApp name ").append(normalizedName).append(" already exists!").toString());
            firebaseApp = new FirebaseApp(normalizedName, options, tokenRefresherFactory);
            sInstances.put(normalizedName, firebaseApp);
        }
        appStore.persistApp(firebaseApp);
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        boolean valueChanged = this.mDeleted.compareAndSet(false, true);
        if (!valueChanged) {
            return;
        }
        this.mTokenRefresher.cleanup();
        Object object = sLock;
        synchronized (object) {
            sInstances.remove(this.mName);
        }
        FirebaseAppStore appStore = FirebaseAppStore.getInstance();
        if (appStore != null) {
            appStore.removeApp(this.mName);
        }
        this.notifyOnAppDeleted();
    }

    private FirebaseApp(String name, FirebaseOptions options, TokenRefresher.Factory factory) {
        this.mName = Preconditions.checkNotEmpty(name);
        this.mOptions = Preconditions.checkNotNull(options);
        this.mTokenRefresher = Preconditions.checkNotNull(factory).create(this);
    }

    private void checkNotDeleted() {
        Preconditions.checkState(!this.mDeleted.get(), "FirebaseApp was deleted");
    }

    Task<GetTokenResult> getToken(boolean forceRefresh) {
        this.checkNotDeleted();
        return this.mOptions.getCredential().getAccessToken(forceRefresh).continueWith(new Continuation<String, GetTokenResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GetTokenResult then(@NonNull Task<String> task) throws Exception {
                GetTokenResult newToken = new GetTokenResult(task.getResult());
                GetTokenResult oldToken = (GetTokenResult)FirebaseApp.this.mCurrentToken.get();
                ArrayList listenersCopy = null;
                if (!newToken.equals(oldToken)) {
                    List list = FirebaseApp.this.mAuthStateListeners;
                    synchronized (list) {
                        if (FirebaseApp.this.mCurrentToken.compareAndSet(oldToken, newToken)) {
                            listenersCopy = new ArrayList(FirebaseApp.this.mAuthStateListeners);
                            FirebaseApp.this.mTokenRefresher.scheduleRefresh(TOKEN_REFRESH_INTERVAL_MILLIS);
                        }
                    }
                }
                if (listenersCopy != null) {
                    for (AuthStateListener listener : listenersCopy) {
                        listener.onAuthStateChanged(newToken);
                    }
                }
                return newToken;
            }
        });
    }

    boolean isDefaultApp() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    String getPersistenceKey() {
        return FirebaseApp.getPersistenceKey(this.getName(), this.getOptions());
    }

    void addLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        this.mLifecycleListeners.add(listener);
    }

    void removeLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        this.mLifecycleListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAuthStateListener(@NonNull AuthStateListener listener) {
        GetTokenResult currentToken;
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        List<AuthStateListener> list = this.mAuthStateListeners;
        synchronized (list) {
            this.mAuthStateListeners.add(listener);
            currentToken = this.mCurrentToken.get();
        }
        if (currentToken != null) {
            listener.onAuthStateChanged(currentToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAuthStateListener(@NonNull AuthStateListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        List<AuthStateListener> list = this.mAuthStateListeners;
        synchronized (list) {
            this.mAuthStateListeners.remove(listener);
        }
    }

    private void notifyOnAppDeleted() {
        for (FirebaseAppLifecycleListener listener : this.mLifecycleListeners) {
            listener.onDeleted(this.mName, this.mOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearInstancesForTest() {
        Object object = sLock;
        synchronized (object) {
            sInstances.clear();
        }
    }

    static String getPersistenceKey(String name, FirebaseOptions options) {
        return Base64Utils.encodeUrlSafeNoPadding(name.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAppNames() {
        HashSet<String> allAppNames = new HashSet<String>();
        Object object = sLock;
        synchronized (object) {
            for (FirebaseApp app : sInstances.values()) {
                allAppNames.add(app.getName());
            }
            FirebaseAppStore appStore = FirebaseAppStore.getInstance();
            if (appStore != null) {
                allAppNames.addAll(appStore.getAllPersistedAppNames());
            }
        }
        ArrayList<String> sortedNameList = new ArrayList<String>(allAppNames);
        Collections.sort(sortedNameList);
        return sortedNameList;
    }

    private static String normalize(@NonNull String name) {
        return name.trim();
    }

    static class TokenRefresher {
        private final FirebaseApp mFirebaseApp;
        private ScheduledFuture<Task<GetTokenResult>> mFuture;

        TokenRefresher(FirebaseApp app) {
            this.mFirebaseApp = Preconditions.checkNotNull(app);
        }

        final synchronized void scheduleRefresh(long delayMillis) {
            this.cancelPrevious();
            this.scheduleNext(new Callable<Task<GetTokenResult>>(){

                @Override
                public Task<GetTokenResult> call() throws Exception {
                    return TokenRefresher.this.mFirebaseApp.getToken(true);
                }
            }, delayMillis);
        }

        protected void cancelPrevious() {
            if (this.mFuture != null) {
                this.mFuture.cancel(true);
            }
        }

        protected void scheduleNext(Callable<Task<GetTokenResult>> task, long delayMillis) {
            try {
                this.mFuture = FirebaseExecutors.DEFAULT_SCHEDULED_EXECUTOR.schedule(task, delayMillis, TimeUnit.MILLISECONDS);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        protected synchronized void cleanup() {
            if (this.mFuture != null) {
                this.mFuture.cancel(true);
            }
        }

        static class Factory {
            Factory() {
            }

            TokenRefresher create(FirebaseApp app) {
                return new TokenRefresher(app);
            }
        }
    }
}

