/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view.filter;

import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.view.QueryParams;
import com.google.firebase.database.core.view.filter.ChildChangeAccumulator;
import com.google.firebase.database.core.view.filter.IndexedFilter;
import com.google.firebase.database.core.view.filter.NodeFilter;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.PriorityUtilities;

public class RangedFilter
implements NodeFilter {
    private final IndexedFilter indexedFilter;
    private final Index index;
    private final NamedNode startPost;
    private final NamedNode endPost;

    public RangedFilter(QueryParams params) {
        this.indexedFilter = new IndexedFilter(params.getIndex());
        this.index = params.getIndex();
        this.startPost = RangedFilter.getStartPost(params);
        this.endPost = RangedFilter.getEndPost(params);
    }

    public NamedNode getStartPost() {
        return this.startPost;
    }

    public NamedNode getEndPost() {
        return this.endPost;
    }

    private static NamedNode getStartPost(QueryParams params) {
        if (params.hasStart()) {
            ChildKey startName = params.getIndexStartName();
            return params.getIndex().makePost(startName, params.getIndexStartValue());
        }
        return params.getIndex().minPost();
    }

    private static NamedNode getEndPost(QueryParams params) {
        if (params.hasEnd()) {
            ChildKey endName = params.getIndexEndName();
            return params.getIndex().makePost(endName, params.getIndexEndValue());
        }
        return params.getIndex().maxPost();
    }

    public boolean matches(NamedNode node) {
        return this.index.compare(this.getStartPost(), node) <= 0 && this.index.compare(node, this.getEndPost()) <= 0;
    }

    @Override
    public IndexedNode updateChild(IndexedNode snap, ChildKey key, Node newChild, Path affectedPath, NodeFilter.CompleteChildSource source, ChildChangeAccumulator optChangeAccumulator) {
        if (!this.matches(new NamedNode(key, newChild))) {
            newChild = EmptyNode.Empty();
        }
        return this.indexedFilter.updateChild(snap, key, newChild, affectedPath, source, optChangeAccumulator);
    }

    @Override
    public IndexedNode updateFullNode(IndexedNode oldSnap, IndexedNode newSnap, ChildChangeAccumulator optChangeAccumulator) {
        IndexedNode filtered;
        if (newSnap.getNode().isLeafNode()) {
            filtered = IndexedNode.from(EmptyNode.Empty(), this.index);
        } else {
            filtered = newSnap.updatePriority(PriorityUtilities.NullPriority());
            for (NamedNode child : newSnap) {
                if (this.matches(child)) continue;
                filtered = filtered.updateChild(child.getName(), EmptyNode.Empty());
            }
        }
        return this.indexedFilter.updateFullNode(oldSnap, filtered, optChangeAccumulator);
    }

    @Override
    public IndexedNode updatePriority(IndexedNode oldSnap, Node newPriority) {
        return oldSnap;
    }

    @Override
    public NodeFilter getIndexedFilter() {
        return this.indexedFilter;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public boolean filtersNodes() {
        return true;
    }
}

