/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.RepoManager;
import com.google.firebase.database.utilities.ParsedUrl;
import com.google.firebase.database.utilities.Utilities;
import com.google.firebase.database.utilities.Validation;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final String SDK_VERSION = "${VERSION}";
    private static final Map<String, Map<RepoInfo, FirebaseDatabase>> databaseInstances = new HashMap<String, Map<RepoInfo, FirebaseDatabase>>();
    private final FirebaseApp app;
    private final RepoInfo repoInfo;
    private final DatabaseConfig config;
    private Repo repo;

    public static FirebaseDatabase getInstance() {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance, instance.getOptions().getDatabaseUrl());
    }

    public static FirebaseDatabase getInstance(String url) {
        FirebaseApp instance = FirebaseApp.getInstance();
        if (instance == null) {
            throw new DatabaseException("You must call FirebaseApp.initialize() first.");
        }
        return FirebaseDatabase.getInstance(instance, url);
    }

    public static FirebaseDatabase getInstance(FirebaseApp app) {
        return FirebaseDatabase.getInstance(app, app.getOptions().getDatabaseUrl());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp app, String url) {
        if (url == null || url.isEmpty()) {
            throw new DatabaseException("Failed to get FirebaseDatabase instance: Specify DatabaseURL within FirebaseApp or from your getInstance() call.");
        }
        Map<RepoInfo, FirebaseDatabase> instances = databaseInstances.get(app.getName());
        if (instances == null) {
            instances = new HashMap<RepoInfo, FirebaseDatabase>();
            databaseInstances.put(app.getName(), instances);
        }
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        if (!parsedUrl.path.isEmpty()) {
            String string = String.valueOf(parsedUrl.path.toString());
            throw new DatabaseException(new StringBuilder(113 + String.valueOf(url).length() + String.valueOf(string).length()).append("Specified Database URL '").append(url).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string).toString());
        }
        FirebaseDatabase database = instances.get(parsedUrl.repoInfo);
        if (database == null) {
            DatabaseConfig config = new DatabaseConfig();
            if (!ImplFirebaseTrampolines.isDefaultApp(app)) {
                config.setSessionPersistenceKey(app.getName());
            }
            config.setFirebaseApp(app);
            database = new FirebaseDatabase(app, parsedUrl.repoInfo, config);
            instances.put(parsedUrl.repoInfo, database);
        }
        return database;
    }

    static FirebaseDatabase createForTests(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        FirebaseDatabase db = new FirebaseDatabase(app, repoInfo, config);
        db.ensureRepo();
        return db;
    }

    private FirebaseDatabase(FirebaseApp app, RepoInfo repoInfo, DatabaseConfig config) {
        this.app = app;
        this.repoInfo = repoInfo;
        this.config = config;
    }

    public FirebaseApp getApp() {
        return this.app;
    }

    public DatabaseReference getReference() {
        this.ensureRepo();
        return new DatabaseReference(this.repo, Path.getEmptyPath());
    }

    public DatabaseReference getReference(String path) {
        this.ensureRepo();
        if (path == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        Validation.validateRootPathString(path);
        Path childPath = new Path(path);
        return new DatabaseReference(this.repo, childPath);
    }

    public DatabaseReference getReferenceFromUrl(String url) {
        this.ensureRepo();
        if (url == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        ParsedUrl parsedUrl = Utilities.parseUrl(url);
        if (!parsedUrl.repoInfo.host.equals(this.repo.getRepoInfo().host)) {
            String string = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(url).length() + String.valueOf(string).length()).append("Invalid URL (").append(url).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string).toString());
        }
        return new DatabaseReference(this.repo, parsedUrl.path);
    }

    public void purgeOutstandingWrites() {
        this.ensureRepo();
        this.repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.repo.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.ensureRepo();
        RepoManager.resume(this.repo);
    }

    public void goOffline() {
        this.ensureRepo();
        RepoManager.interrupt(this.repo);
    }

    public synchronized void setLogLevel(Logger.Level logLevel) {
        this.assertUnfrozen("setLogLevel");
        this.config.setLogLevel(logLevel);
    }

    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        this.assertUnfrozen("setPersistenceEnabled");
        this.config.setPersistenceEnabled(isEnabled);
    }

    public synchronized void setPersistenceCacheSizeBytes(long cacheSizeInBytes) {
        this.assertUnfrozen("setPersistenceCacheSizeBytes");
        this.config.setPersistenceCacheSizeBytes(cacheSizeInBytes);
    }

    public static String getSdkVersion() {
        return SDK_VERSION;
    }

    private void assertUnfrozen(String methodCalled) {
        if (this.repo != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(methodCalled).length()).append("Calls to ").append(methodCalled).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void ensureRepo() {
        if (this.repo == null) {
            this.repo = RepoManager.createRepo(this.config, this.repoInfo, this);
        }
    }

    DatabaseConfig getConfig() {
        return this.config;
    }
}

