/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.OnFailureListener;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import java.util.concurrent.Executor;

class OnFailureCompletionListener<TResult>
implements TaskCompletionListener<TResult> {
    private final Executor mExecutor;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private OnFailureListener mOnFailure;

    public OnFailureCompletionListener(@NonNull Executor executor, @NonNull OnFailureListener onFailure) {
        this.mExecutor = executor;
        this.mOnFailure = onFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(final @NonNull Task<TResult> task) {
        if (!task.isSuccessful()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mOnFailure == null) {
                    return;
                }
            }
            this.mExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = OnFailureCompletionListener.this.mLock;
                    synchronized (object) {
                        if (OnFailureCompletionListener.this.mOnFailure != null) {
                            OnFailureCompletionListener.this.mOnFailure.onFailure(task.getException());
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnFailure = null;
        }
    }
}

