/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.logging;

import com.google.firebase.database.logging.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogWrapper {
    private final Logger logger;
    private final String component;
    private final String prefix;

    private static String exceptionStacktrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        return writer.toString();
    }

    public LogWrapper(Logger logger, String component) {
        this(logger, component, null);
    }

    public LogWrapper(Logger logger, String component, String prefix) {
        this.logger = logger;
        this.component = component;
        this.prefix = prefix;
    }

    public void error(String message, Throwable e) {
        String string = String.valueOf(this.toLog(message, new Object[0]));
        String string2 = String.valueOf(LogWrapper.exceptionStacktrace(e));
        String logMsg = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("\n").append(string2).toString();
        this.logger.onLogMessage(Logger.Level.ERROR, this.component, logMsg, this.now());
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable e) {
        String logMsg = this.toLog(message, new Object[0]);
        if (e != null) {
            String string = logMsg;
            String string2 = String.valueOf(LogWrapper.exceptionStacktrace(e));
            logMsg = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("\n").append(string2).toString();
        }
        this.logger.onLogMessage(Logger.Level.WARN, this.component, logMsg, this.now());
    }

    public void info(String message) {
        this.logger.onLogMessage(Logger.Level.INFO, this.component, this.toLog(message, new Object[0]), this.now());
    }

    public void debug(String message, Object ... args) {
        this.debug(message, null, args);
    }

    public boolean logsDebug() {
        return this.logger.getLogLevel().ordinal() <= Logger.Level.DEBUG.ordinal();
    }

    public void debug(String message, Throwable e, Object ... args) {
        if (this.logsDebug()) {
            String logMsg = this.toLog(message, args);
            if (e != null) {
                String string = logMsg;
                String string2 = String.valueOf(LogWrapper.exceptionStacktrace(e));
                logMsg = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("\n").append(string2).toString();
            }
            this.logger.onLogMessage(Logger.Level.DEBUG, this.component, logMsg, this.now());
        }
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private String toLog(String message, Object ... args) {
        String string;
        String formatted;
        String string2 = formatted = args.length > 0 ? String.format(message, args) : message;
        if (this.prefix == null) {
            string = formatted;
        } else {
            String string3 = this.prefix;
            string = new StringBuilder(3 + String.valueOf(string3).length() + String.valueOf(formatted).length()).append(string3).append(" - ").append(formatted).toString();
        }
        return string;
    }
}

