/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection;

import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.WebsocketConnection;
import com.google.firebase.database.logging.LogWrapper;
import java.util.HashMap;
import java.util.Map;

class Connection
implements WebsocketConnection.Delegate {
    private static long connectionIds = 0L;
    private static final String REQUEST_TYPE = "t";
    private static final String REQUEST_TYPE_DATA = "d";
    private static final String REQUEST_PAYLOAD = "d";
    private static final String SERVER_ENVELOPE_TYPE = "t";
    private static final String SERVER_DATA_MESSAGE = "d";
    private static final String SERVER_CONTROL_MESSAGE = "c";
    private static final String SERVER_ENVELOPE_DATA = "d";
    private static final String SERVER_CONTROL_MESSAGE_TYPE = "t";
    private static final String SERVER_CONTROL_MESSAGE_SHUTDOWN = "s";
    private static final String SERVER_CONTROL_MESSAGE_RESET = "r";
    private static final String SERVER_CONTROL_MESSAGE_HELLO = "h";
    private static final String SERVER_CONTROL_MESSAGE_DATA = "d";
    private static final String SERVER_HELLO_TIMESTAMP = "ts";
    private static final String SERVER_HELLO_HOST = "h";
    private static final String SERVER_HELLO_SESSION_ID = "s";
    private HostInfo hostInfo;
    private WebsocketConnection conn;
    private Delegate delegate;
    private State state;
    private final LogWrapper logger;

    public Connection(ConnectionContext context, HostInfo hostInfo, String cachedHost, Delegate delegate, String optLastSessionId) {
        long connId = connectionIds++;
        this.hostInfo = hostInfo;
        this.delegate = delegate;
        this.logger = new LogWrapper(context.getLogger(), "Connection", new StringBuilder(25).append("conn_").append(connId).toString());
        this.state = State.REALTIME_CONNECTING;
        this.conn = new WebsocketConnection(context, hostInfo, cachedHost, this, optLastSessionId);
    }

    public void open() {
        if (this.logger.logsDebug()) {
            this.logger.debug("Opening a connection", new Object[0]);
        }
        this.conn.open();
    }

    public void close(DisconnectReason reason) {
        if (this.state != State.REALTIME_DISCONNECTED) {
            if (this.logger.logsDebug()) {
                this.logger.debug("closing realtime connection", new Object[0]);
            }
            this.state = State.REALTIME_DISCONNECTED;
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
            this.delegate.onDisconnect(reason);
        }
    }

    public void close() {
        this.close(DisconnectReason.OTHER);
    }

    public void sendRequest(Map<String, Object> message, boolean isSensitive) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("t", "d");
        request.put("d", message);
        this.sendData(request, isSensitive);
    }

    @Override
    public void onMessage(Map<String, Object> message) {
        try {
            String messageType = (String)message.get("t");
            if (messageType != null) {
                if (messageType.equals("d")) {
                    Map data = (Map)message.get("d");
                    this.onDataMessage(data);
                } else if (messageType.equals(SERVER_CONTROL_MESSAGE)) {
                    Map data = (Map)message.get("d");
                    this.onControlMessage(data);
                } else if (this.logger.logsDebug()) {
                    String string = String.valueOf(messageType);
                    this.logger.debug(string.length() != 0 ? "Ignoring unknown server message type: ".concat(string) : new String("Ignoring unknown server message type: "), new Object[0]);
                }
            } else {
                if (this.logger.logsDebug()) {
                    String string = String.valueOf(message.toString());
                    this.logger.debug(string.length() != 0 ? "Failed to parse server message: missing message type:".concat(string) : new String("Failed to parse server message: missing message type:"), new Object[0]);
                }
                this.close();
            }
        }
        catch (ClassCastException e) {
            if (this.logger.logsDebug()) {
                String string = String.valueOf(e.toString());
                this.logger.debug(string.length() != 0 ? "Failed to parse server message: ".concat(string) : new String("Failed to parse server message: "), new Object[0]);
            }
            this.close();
        }
    }

    @Override
    public void onDisconnect(boolean wasEverConnected) {
        this.conn = null;
        if (!wasEverConnected && this.state == State.REALTIME_CONNECTING) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Realtime connection failed", new Object[0]);
            }
        } else if (this.logger.logsDebug()) {
            this.logger.debug("Realtime connection lost", new Object[0]);
        }
        this.close();
    }

    private void onDataMessage(Map<String, Object> data) {
        if (this.logger.logsDebug()) {
            String string = String.valueOf(data.toString());
            this.logger.debug(string.length() != 0 ? "received data message: ".concat(string) : new String("received data message: "), new Object[0]);
        }
        this.delegate.onDataMessage(data);
    }

    private void onControlMessage(Map<String, Object> data) {
        if (this.logger.logsDebug()) {
            String string = String.valueOf(data.toString());
            this.logger.debug(string.length() != 0 ? "Got control message: ".concat(string) : new String("Got control message: "), new Object[0]);
        }
        try {
            String messageType = (String)data.get("t");
            if (messageType != null) {
                if (messageType.equals("s")) {
                    String reason = (String)data.get("d");
                    this.onConnectionShutdown(reason);
                } else if (messageType.equals(SERVER_CONTROL_MESSAGE_RESET)) {
                    String host = (String)data.get("d");
                    this.onReset(host);
                } else if (messageType.equals("h")) {
                    Map handshakeData = (Map)data.get("d");
                    this.onHandshake(handshakeData);
                } else if (this.logger.logsDebug()) {
                    String string = String.valueOf(messageType);
                    this.logger.debug(string.length() != 0 ? "Ignoring unknown control message: ".concat(string) : new String("Ignoring unknown control message: "), new Object[0]);
                }
            } else {
                if (this.logger.logsDebug()) {
                    String string = String.valueOf(data.toString());
                    this.logger.debug(string.length() != 0 ? "Got invalid control message: ".concat(string) : new String("Got invalid control message: "), new Object[0]);
                }
                this.close();
            }
        }
        catch (ClassCastException e) {
            if (this.logger.logsDebug()) {
                String string = String.valueOf(e.toString());
                this.logger.debug(string.length() != 0 ? "Failed to parse control message: ".concat(string) : new String("Failed to parse control message: "), new Object[0]);
            }
            this.close();
        }
    }

    private void onConnectionShutdown(String reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Connection shutdown command received. Shutting down...", new Object[0]);
        }
        this.delegate.onKill(reason);
        this.close();
    }

    private void onHandshake(Map<String, Object> handshake) {
        long timestamp = (Long)handshake.get(SERVER_HELLO_TIMESTAMP);
        String host = (String)handshake.get("h");
        this.delegate.onCacheHost(host);
        String sessionId = (String)handshake.get("s");
        if (this.state == State.REALTIME_CONNECTING) {
            this.conn.start();
            this.onConnectionReady(timestamp, sessionId);
        }
    }

    private void onConnectionReady(long timestamp, String sessionId) {
        if (this.logger.logsDebug()) {
            this.logger.debug("realtime connection established", new Object[0]);
        }
        this.state = State.REALTIME_CONNECTED;
        this.delegate.onReady(timestamp, sessionId);
    }

    private void onReset(String host) {
        if (this.logger.logsDebug()) {
            String string = String.valueOf(this.hostInfo.getHost());
            this.logger.debug(new StringBuilder(62 + String.valueOf(string).length() + String.valueOf(host).length()).append("Got a reset; killing connection to ").append(string).append("; Updating internalHost to ").append(host).toString(), new Object[0]);
        }
        this.delegate.onCacheHost(host);
        this.close(DisconnectReason.SERVER_RESET);
    }

    private void sendData(Map<String, Object> data, boolean isSensitive) {
        if (this.state != State.REALTIME_CONNECTED) {
            this.logger.debug("Tried to send on an unconnected connection", new Object[0]);
        } else {
            if (isSensitive) {
                this.logger.debug("Sending data (contents hidden)", new Object[0]);
            } else {
                this.logger.debug("Sending data: %s", data);
            }
            this.conn.send(data);
        }
    }

    public void injectConnectionFailure() {
        this.close();
    }

    private static enum State {
        REALTIME_CONNECTING,
        REALTIME_CONNECTED,
        REALTIME_DISCONNECTED;

    }

    public static interface Delegate {
        public void onCacheHost(String var1);

        public void onReady(long var1, String var3);

        public void onDataMessage(Map<String, Object> var1);

        public void onDisconnect(DisconnectReason var1);

        public void onKill(String var1);
    }

    public static enum DisconnectReason {
        SERVER_RESET,
        OTHER;

    }
}

