/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.connection.PersistentConnectionImpl;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.JvmAuthTokenProvider;
import com.google.firebase.database.core.Platform;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.ThreadPoolEventTarget;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.logging.DefaultLogger;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.logging.Logger;
import com.google.firebase.database.tubesock.ThreadInitializer;
import com.google.firebase.database.tubesock.WebSocket;
import com.google.firebase.database.utilities.DefaultRunLoop;
import com.google.firebase.internal.GaeThreadFactory;
import com.google.firebase.internal.Log;
import com.google.firebase.internal.RevivingScheduledExecutor;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

class GaePlatform
implements Platform {
    private static final String TAG = "GaePlatform";
    ThreadFactory threadFactoryInstance;
    private final FirebaseApp firebaseApp;

    public GaePlatform(FirebaseApp firebaseApp) {
        this.firebaseApp = firebaseApp;
    }

    @Override
    public Logger newLogger(Context ctx, Logger.Level level, List<String> components) {
        return new DefaultLogger(level, components);
    }

    private ThreadFactory getGaeThreadFactory() {
        if (this.threadFactoryInstance == null) {
            this.threadFactoryInstance = GaeThreadFactory.tryCreate(true);
            if (this.threadFactoryInstance == null) {
                Log.w(TAG, "Failed to initialize GAE thread factory, using default factory instead.");
                this.threadFactoryInstance = Executors.defaultThreadFactory();
            }
        }
        return this.threadFactoryInstance;
    }

    public static boolean isActive() {
        return GaeThreadFactory.isAvailable();
    }

    public void initialize() {
        WebSocket.setThreadFactory(this.getGaeThreadFactory(), new ThreadInitializer(this){

            @Override
            public void setName(Thread thread, String s) {
            }
        });
    }

    @Override
    public EventTarget newEventTarget(Context ctx) {
        RevivingScheduledExecutor eventExecutor = new RevivingScheduledExecutor(this.getGaeThreadFactory(), "FirebaseDatabaseEventTarget", true);
        return new ThreadPoolEventTarget(eventExecutor);
    }

    @Override
    public RunLoop newRunLoop(Context context) {
        final LogWrapper logger = context.getLogger("RunLoop");
        return new DefaultRunLoop(this, this.getGaeThreadFactory(), true, context){

            @Override
            public void handleException(Throwable e) {
                logger.error(DefaultRunLoop.messageForException(e), e);
            }
        };
    }

    @Override
    public AuthTokenProvider newAuthTokenProvider(ScheduledExecutorService executorService) {
        return new JvmAuthTokenProvider(this.firebaseApp, executorService);
    }

    @Override
    public PersistentConnection newPersistentConnection(Context context, ConnectionContext connectionContext, HostInfo info, PersistentConnection.Delegate delegate) {
        return new PersistentConnectionImpl(context.getConnectionContext(), info, delegate);
    }

    @Override
    public String getUserAgent(Context ctx) {
        String deviceName = "AppEngine";
        String systemVersion = System.getProperty("java.specification.version", "Unknown");
        return new StringBuilder(1 + String.valueOf(systemVersion).length() + String.valueOf(deviceName).length()).append(systemVersion).append("/").append(deviceName).toString();
    }

    @Override
    public String getPlatformVersion() {
        String string = String.valueOf(FirebaseDatabase.getSdkVersion());
        return string.length() != 0 ? "gae-".concat(string) : new String("gae-");
    }

    @Override
    public PersistenceManager createPersistenceManager(Context ctx, String namespace) {
        return null;
    }
}

