/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.utilities.encoding;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.Exclude;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.IgnoreExtraProperties;
import com.google.firebase.database.PropertyName;
import com.google.firebase.database.ThrowOnExtraProperties;
import com.google.firebase.database.utilities.Utilities;
import com.google.firebase.internal.Log;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CustomClassMapper {
    private static final String LOG_TAG = "ClassMapper";
    private static final ConcurrentMap<Class<?>, BeanMapper<?>> mappers = new ConcurrentHashMap();

    public static Object convertToPlainJavaTypes(Object object) {
        return CustomClassMapper.serialize(object);
    }

    public static Map<String, Object> convertToPlainJavaTypes(Map<String, Object> update) {
        Object converted = CustomClassMapper.serialize(update);
        Utilities.hardAssert(converted instanceof Map);
        return (Map)converted;
    }

    public static <T> T convertToCustomClass(Object object, Class<T> clazz) {
        return CustomClassMapper.deserializeToClass(object, clazz);
    }

    public static <T> T convertToCustomClass(Object object, GenericTypeIndicator<T> typeIndicator) {
        Class<?> clazz = typeIndicator.getClass();
        Type genericTypeIndicatorType = clazz.getGenericSuperclass();
        if (genericTypeIndicatorType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericTypeIndicatorType;
            if (!parameterizedType.getRawType().equals(GenericTypeIndicator.class)) {
                String string = String.valueOf(genericTypeIndicatorType);
                throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Not a direct subclass of GenericTypeIndicator: ").append(string).toString());
            }
            Type type = parameterizedType.getActualTypeArguments()[0];
            return CustomClassMapper.deserializeToType(object, type);
        }
        String string = String.valueOf(genericTypeIndicatorType);
        throw new DatabaseException(new StringBuilder(47 + String.valueOf(string).length()).append("Not a direct subclass of GenericTypeIndicator: ").append(string).toString());
    }

    private static <T> Object serialize(T o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            if (o instanceof Float) {
                return ((Float)o).doubleValue();
            }
            if (o instanceof Short) {
                throw new DatabaseException("Shorts are not supported, please use int or long");
            }
            if (o instanceof Byte) {
                throw new DatabaseException("Bytes are not supported, please use int or long");
            }
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Boolean) {
            return o;
        }
        if (o instanceof Character) {
            throw new DatabaseException("Characters are not supported, please strings");
        }
        if (o instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    String keyString = (String)key;
                    result.put(keyString, CustomClassMapper.serialize(entry.getValue()));
                    continue;
                }
                throw new DatabaseException("Maps with non-string keys are not supported");
            }
            return result;
        }
        if (o instanceof Collection) {
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (Object object : list) {
                    result.add(CustomClassMapper.serialize(object));
                }
                return result;
            }
            throw new DatabaseException("Serializing Collections is not supported, please use Lists instead");
        }
        if (o.getClass().isArray()) {
            throw new DatabaseException("Serializing Arrays is not supported, please use Lists instead");
        }
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        Class<?> clazz = o.getClass();
        BeanMapper<?> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        return mapper.serialize(o);
    }

    private static <T> T deserializeToType(Object o, Type type) {
        if (o == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return CustomClassMapper.deserializeToParameterizedType(o, (ParameterizedType)type);
        }
        if (type instanceof Class) {
            return CustomClassMapper.deserializeToClass(o, (Class)type);
        }
        if (type instanceof WildcardType) {
            throw new DatabaseException("Generic wildcard types are not supported");
        }
        if (type instanceof GenericArrayType) {
            throw new DatabaseException("Generic Arrays are not supported, please use Lists instead");
        }
        String string = String.valueOf(type);
        throw new IllegalStateException(new StringBuilder(26 + String.valueOf(string).length()).append("Unknown type encountered: ").append(string).toString());
    }

    private static <T> T deserializeToClass(Object o, Class<T> clazz) {
        if (o == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return CustomClassMapper.deserializeToPrimitive(o, clazz);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertString(o);
        }
        if (clazz.isArray()) {
            throw new DatabaseException("Converting to Arrays is not supported, please use Listsinstead");
        }
        if (clazz.getTypeParameters().length > 0) {
            String string = String.valueOf(clazz.getName());
            throw new DatabaseException(new StringBuilder(75 + String.valueOf(string).length()).append("Class ").append(string).append(" has generic type parameters, please use GenericTypeIndicator instead").toString());
        }
        if (clazz.equals(Object.class)) {
            return (T)o;
        }
        if (clazz.isEnum()) {
            return CustomClassMapper.deserializeToEnum(o, clazz);
        }
        return CustomClassMapper.convertBean(o, clazz);
    }

    private static <T> T deserializeToParameterizedType(Object o, ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        if (List.class.isAssignableFrom(rawType)) {
            Type genericType = type.getActualTypeArguments()[0];
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<T> result = new ArrayList<T>(list.size());
                for (Object object : list) {
                    result.add(CustomClassMapper.deserializeToType(object, genericType));
                }
                return (T)result;
            }
            String list = String.valueOf(o.getClass());
            throw new DatabaseException(new StringBuilder(47 + String.valueOf(list).length()).append("Expected a List while deserializing, but got a ").append(list).toString());
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (!keyType.equals(String.class)) {
                String result = String.valueOf(keyType);
                throw new DatabaseException(new StringBuilder(70 + String.valueOf(result).length()).append("Only Maps with string keys are supported, but found Map with key type ").append(result).toString());
            }
            Map<String, Object> map = CustomClassMapper.expectMap(o);
            HashMap<String, T> result = new HashMap<String, T>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                result.put(entry.getKey(), CustomClassMapper.deserializeToType(entry.getValue(), valueType));
            }
            return (T)result;
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            throw new DatabaseException("Collections are not supported, please use Lists instead");
        }
        Map<String, Object> map = CustomClassMapper.expectMap(o);
        BeanMapper mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(rawType);
        HashMap typeMapping = new HashMap();
        TypeVariable<Class<T>>[] typeVariables = mapper.clazz.getTypeParameters();
        Type[] types = type.getActualTypeArguments();
        if (types.length != typeVariables.length) {
            throw new IllegalStateException("Mismatched lengths for type variables and actual types");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            typeMapping.put(typeVariables[i], types[i]);
        }
        return mapper.deserialize(map, typeMapping);
    }

    private static <T> T deserializeToPrimitive(Object o, Class<T> clazz) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertInteger(o);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBoolean(o);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDouble(o);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertLong(o);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(CustomClassMapper.convertDouble(o).floatValue());
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            throw new DatabaseException("Deserializing to shorts is not supported");
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            throw new DatabaseException("Deserializing to bytes is not supported");
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            throw new DatabaseException("Deserializing to char is not supported");
        }
        String string = String.valueOf(clazz);
        throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Unknown primitive type: ").append(string).toString());
    }

    private static <T> T deserializeToEnum(Object object, Class<T> clazz) {
        if (object instanceof String) {
            String value = (String)object;
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                String string = String.valueOf(clazz.getName());
                throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length() + String.valueOf(value).length()).append("Could not find enum value of ").append(string).append(" for value \"").append(value).append("\"").toString());
            }
        }
        String string = String.valueOf(clazz);
        String string2 = String.valueOf(object.getClass());
        throw new DatabaseException(new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Expected a String while deserializing to enum ").append(string).append(" but got a ").append(string2).toString());
    }

    private static <T> BeanMapper<T> loadOrCreateBeanMapperForClass(Class<T> clazz) {
        BeanMapper<T> mapper = (BeanMapper<T>)mappers.get(clazz);
        if (mapper == null) {
            mapper = new BeanMapper<T>(clazz);
            mappers.put(clazz, mapper);
        }
        return mapper;
    }

    private static Map<String, Object> expectMap(Object object) {
        if (object instanceof Map) {
            return (Map)object;
        }
        String string = String.valueOf(object.getClass());
        throw new DatabaseException(new StringBuilder(46 + String.valueOf(string).length()).append("Expected a Map while deserializing, but got a ").append(string).toString());
    }

    private static Integer convertInteger(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long || o instanceof Double) {
            double value = ((Number)o).doubleValue();
            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                return ((Number)o).intValue();
            }
            throw new DatabaseException(new StringBuilder(124).append("Numeric value out of 32-bit integer range: ").append(value).append(". Did you mean to use a long or double instead of an int?").toString());
        }
        String string = String.valueOf(o.getClass().getName());
        throw new DatabaseException(new StringBuilder(41 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to int").toString());
    }

    private static Long convertLong(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Double) {
            Double value = (Double)o;
            if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
                return value.longValue();
            }
            String string = String.valueOf(value);
            throw new DatabaseException(new StringBuilder(89 + String.valueOf(string).length()).append("Numeric value out of 64-bit long range: ").append(string).append(". Did you mean to use a double instead of a long?").toString());
        }
        String string = String.valueOf(o.getClass().getName());
        throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to long").toString());
    }

    private static Double convertDouble(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            Long value = (Long)o;
            Double doubleValue = ((Long)o).doubleValue();
            if (doubleValue.longValue() == value.longValue()) {
                return doubleValue;
            }
            String string = String.valueOf(o);
            throw new DatabaseException(new StringBuilder(97 + String.valueOf(string).length()).append("Loss of precision while converting number to double: ").append(string).append(". Did you mean to use a 64-bit long instead?").toString());
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        String string = String.valueOf(o.getClass().getName());
        throw new DatabaseException(new StringBuilder(44 + String.valueOf(string).length()).append("Failed to convert a value of type ").append(string).append(" to double").toString());
    }

    private static Boolean convertBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String string = String.valueOf(o.getClass().getName());
        throw new DatabaseException(new StringBuilder(43 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to boolean").toString());
    }

    private static String convertString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        String string = String.valueOf(o.getClass().getName());
        throw new DatabaseException(new StringBuilder(42 + String.valueOf(string).length()).append("Failed to convert value of type ").append(string).append(" to String").toString());
    }

    private static <T> T convertBean(Object o, Class<T> clazz) {
        BeanMapper<T> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        if (o instanceof Map) {
            return mapper.deserialize(CustomClassMapper.expectMap(o));
        }
        String string = String.valueOf(o.getClass().getName());
        String string2 = String.valueOf(clazz.getName());
        throw new DatabaseException(new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't convert object of type ").append(string).append(" to type ").append(string2).toString());
    }

    private static class BeanMapper<T> {
        private final Class<T> clazz;
        private final Constructor<T> constructor;
        private final boolean throwOnUnknownProperties;
        private final boolean warnOnUnknownProperties;
        private final Map<String, String> properties;
        private final Map<String, Method> getters;
        private final Map<String, Method> setters;
        private final Map<String, Field> fields;

        /*
         * WARNING - void declaration
         */
        public BeanMapper(Class<T> clazz) {
            this.clazz = clazz;
            this.throwOnUnknownProperties = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
            this.warnOnUnknownProperties = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
            this.properties = new HashMap<String, String>();
            this.setters = new HashMap<String, Method>();
            this.getters = new HashMap<String, Method>();
            this.fields = new HashMap<String, Field>();
            Constructor<T> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
            this.constructor = constructor;
            for (Method method : clazz.getMethods()) {
                if (!BeanMapper.shouldIncludeGetter(method)) continue;
                String string = BeanMapper.propertyName(method);
                this.addProperty(string);
                method.setAccessible(true);
                if (this.getters.containsKey(string)) {
                    String string2 = String.valueOf(method.getName());
                    throw new DatabaseException(string2.length() != 0 ? "Found conflicting getters for name: ".concat(string2) : new String("Found conflicting getters for name: "));
                }
                this.getters.put(string, method);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                if (!BeanMapper.shouldIncludeField((Field)accessibleObject)) continue;
                String string = BeanMapper.propertyName((Field)accessibleObject);
                this.addProperty(string);
            }
            Class<T> currentClass = clazz;
            do {
                void var6_13;
                int n;
                AccessibleObject[] accessibleObjectArray = currentClass.getDeclaredMethods();
                int n2 = accessibleObjectArray.length;
                boolean bl = false;
                while (n < n2) {
                    String propertyName2;
                    String existingPropertyName;
                    Method method = accessibleObjectArray[n];
                    if (BeanMapper.shouldIncludeSetter(method) && (existingPropertyName = this.properties.get((propertyName2 = BeanMapper.propertyName(method)).toLowerCase())) != null) {
                        if (!existingPropertyName.equals(propertyName2)) {
                            String string = String.valueOf(method.getName());
                            throw new DatabaseException(string.length() != 0 ? "Found setter with invalid case-sensitive name: ".concat(string) : new String("Found setter with invalid case-sensitive name: "));
                        }
                        Method existingSetter = this.setters.get(propertyName2);
                        if (existingSetter == null) {
                            method.setAccessible(true);
                            this.setters.put(propertyName2, method);
                        } else if (!BeanMapper.isSetterOverride(method, existingSetter)) {
                            String string = String.valueOf(method.getName());
                            String string3 = String.valueOf(existingSetter.getName());
                            String string4 = String.valueOf(existingSetter.getDeclaringClass().getName());
                            throw new DatabaseException(new StringBuilder(69 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Found a conflicting setters with name: ").append(string).append(" (conflicts with ").append(string3).append(" defined on ").append(string4).append(")").toString());
                        }
                    }
                    n += 1;
                }
                accessibleObjectArray = currentClass.getDeclaredFields();
                n2 = accessibleObjectArray.length;
                n = 0;
                while (var6_13 < n2) {
                    AccessibleObject accessibleObject = accessibleObjectArray[var6_13];
                    String propertyName = BeanMapper.propertyName((Field)accessibleObject);
                    if (this.properties.containsKey(propertyName.toLowerCase()) && !this.fields.containsKey(propertyName)) {
                        ((Field)accessibleObject).setAccessible(true);
                        this.fields.put(propertyName, (Field)accessibleObject);
                    }
                    ++var6_13;
                }
            } while ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(Object.class));
            if (this.properties.isEmpty()) {
                String string = String.valueOf(clazz.getName());
                throw new DatabaseException(string.length() != 0 ? "No properties to serialize found on class ".concat(string) : new String("No properties to serialize found on class "));
            }
        }

        private void addProperty(String property) {
            String oldValue = this.properties.put(property.toLowerCase(), property);
            if (oldValue != null && !property.equals(oldValue)) {
                String string = String.valueOf(property.toLowerCase());
                throw new DatabaseException(string.length() != 0 ? "Found two getters or fields with conflicting case sensitivity for property: ".concat(string) : new String("Found two getters or fields with conflicting case sensitivity for property: "));
            }
        }

        public T deserialize(Map<String, Object> values) {
            return this.deserialize(values, Collections.emptyMap());
        }

        public T deserialize(Map<String, Object> values, Map<TypeVariable<Class<T>>, Type> types) {
            T instance;
            if (this.constructor == null) {
                String string = String.valueOf(this.clazz.getName());
                throw new DatabaseException(new StringBuilder(49 + String.valueOf(string).length()).append("Class ").append(string).append(" is missing a constructor with no arguments").toString());
            }
            try {
                instance = this.constructor.newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                String propertyName = entry.getKey();
                if (this.setters.containsKey(propertyName)) {
                    Method setter = this.setters.get(propertyName);
                    Type[] params = setter.getGenericParameterTypes();
                    if (params.length != 1) {
                        throw new IllegalStateException("Setter does not have exactly one parameter");
                    }
                    Type resolvedType = this.resolveType(params[0], types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType);
                    try {
                        setter.invoke(instance, value);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.fields.containsKey(propertyName)) {
                    Field field = this.fields.get(propertyName);
                    Type resolvedType = this.resolveType(field.getGenericType(), types);
                    Object value = CustomClassMapper.deserializeToType(entry.getValue(), resolvedType);
                    try {
                        field.set(instance, value);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                String string = String.valueOf(this.clazz.getName());
                String message = new StringBuilder(36 + String.valueOf(propertyName).length() + String.valueOf(string).length()).append("No setter/field for ").append(propertyName).append(" found on class ").append(string).toString();
                if (this.properties.containsKey(propertyName.toLowerCase())) {
                    message = String.valueOf(message).concat(" (fields/setters are case sensitive!)");
                }
                if (this.throwOnUnknownProperties) {
                    throw new DatabaseException(message);
                }
                if (!this.warnOnUnknownProperties) continue;
                Log.w(CustomClassMapper.LOG_TAG, message);
            }
            return instance;
        }

        private Type resolveType(Type type, Map<TypeVariable<Class<T>>, Type> types) {
            if (type instanceof TypeVariable) {
                Type resolvedType = types.get(type);
                if (resolvedType == null) {
                    String string = String.valueOf(type);
                    throw new IllegalStateException(new StringBuilder(23 + String.valueOf(string).length()).append("Could not resolve type ").append(string).toString());
                }
                return resolvedType;
            }
            return type;
        }

        public Map<String, Object> serialize(T object) {
            if (!this.clazz.isAssignableFrom(object.getClass())) {
                String string = String.valueOf(object.getClass());
                String string2 = String.valueOf(this.clazz);
                throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Can't serialize object of class ").append(string).append(" with BeanMapper for class ").append(string2).toString());
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String property : this.properties.values()) {
                Object propertyValue;
                if (this.getters.containsKey(property)) {
                    Method getter = this.getters.get(property);
                    try {
                        propertyValue = getter.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                Field field = this.fields.get(property);
                if (field == null) {
                    String string = String.valueOf(property);
                    throw new IllegalStateException(string.length() != 0 ? "Bean property without field or getter:".concat(string) : new String("Bean property without field or getter:"));
                }
                try {
                    propertyValue = field.get(object);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                Object serializedValue = CustomClassMapper.serialize(propertyValue);
                result.put(property, serializedValue);
            }
            return result;
        }

        private static boolean shouldIncludeGetter(Method method) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 0) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeSetter(Method method) {
            if (!method.getName().startsWith("set")) {
                return false;
            }
            if (method.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
            if (method.getParameterTypes().length != 1) {
                return false;
            }
            return !method.isAnnotationPresent(Exclude.class);
        }

        private static boolean shouldIncludeField(Field field) {
            if (field.getDeclaringClass().equals(Object.class)) {
                return false;
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            if (Modifier.isTransient(field.getModifiers())) {
                return false;
            }
            return !field.isAnnotationPresent(Exclude.class);
        }

        private static boolean isSetterOverride(Method base, Method override) {
            Utilities.hardAssert(base.getDeclaringClass().isAssignableFrom(override.getDeclaringClass()), "Expected override from a base class");
            Utilities.hardAssert(base.getReturnType().equals(Void.TYPE), "Expected void return type");
            Utilities.hardAssert(override.getReturnType().equals(Void.TYPE), "Expected void return type");
            Class<?>[] baseParameterTypes = base.getParameterTypes();
            Class<?>[] overrideParameterTypes = override.getParameterTypes();
            Utilities.hardAssert(baseParameterTypes.length == 1, "Expected exactly one parameter");
            Utilities.hardAssert(overrideParameterTypes.length == 1, "Expected exactly one parameter");
            return base.getName().equals(override.getName()) && baseParameterTypes[0].equals(overrideParameterTypes[0]);
        }

        private static String propertyName(Field field) {
            String annotatedName = BeanMapper.annotatedName(field);
            return annotatedName != null ? annotatedName : field.getName();
        }

        private static String propertyName(Method method) {
            String annotatedName = BeanMapper.annotatedName(method);
            return annotatedName != null ? annotatedName : BeanMapper.serializedName(method.getName());
        }

        private static String annotatedName(AccessibleObject obj) {
            if (obj.isAnnotationPresent(PropertyName.class)) {
                PropertyName annotation = obj.getAnnotation(PropertyName.class);
                return annotation.value();
            }
            return null;
        }

        private static String serializedName(String methodName) {
            String[] prefixes = new String[]{"get", "set", "is"};
            String methodPrefix = null;
            for (String prefix : prefixes) {
                if (!methodName.startsWith(prefix)) continue;
                methodPrefix = prefix;
            }
            if (methodPrefix == null) {
                String string = String.valueOf(methodName);
                throw new IllegalArgumentException(string.length() != 0 ? "Unknown Bean prefix for method: ".concat(string) : new String("Unknown Bean prefix for method: "));
            }
            String strippedName = methodName.substring(methodPrefix.length());
            char[] chars = strippedName.toCharArray();
            for (int pos = 0; pos < chars.length && Character.isUpperCase(chars[pos]); ++pos) {
                chars[pos] = Character.toLowerCase(chars[pos]);
            }
            return new String(chars);
        }
    }
}

