/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core.view.filter;

import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.snapshot.ChildKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChildChangeAccumulator {
    private final Map<ChildKey, Change> changeMap = new HashMap<ChildKey, Change>();

    /*
     * Enabled aggressive block sorting
     */
    public void trackChildChange(Change change) {
        Event.EventType type = change.getEventType();
        ChildKey childKey = change.getChildKey();
        assert (type == Event.EventType.CHILD_ADDED || type == Event.EventType.CHILD_CHANGED || type == Event.EventType.CHILD_REMOVED) : "Only child changes supported for tracking";
        assert (!change.getChildKey().isPriorityChildName());
        if (!this.changeMap.containsKey(childKey)) {
            this.changeMap.put(change.getChildKey(), change);
            return;
        }
        Change oldChange = this.changeMap.get(childKey);
        Event.EventType oldType = oldChange.getEventType();
        if (type == Event.EventType.CHILD_ADDED && oldType == Event.EventType.CHILD_REMOVED) {
            this.changeMap.put(change.getChildKey(), Change.childChangedChange(childKey, change.getIndexedNode(), oldChange.getIndexedNode()));
            return;
        }
        if (type == Event.EventType.CHILD_REMOVED && oldType == Event.EventType.CHILD_ADDED) {
            this.changeMap.remove(childKey);
            return;
        }
        if (type == Event.EventType.CHILD_REMOVED && oldType == Event.EventType.CHILD_CHANGED) {
            this.changeMap.put(childKey, Change.childRemovedChange(childKey, oldChange.getOldIndexedNode()));
            return;
        }
        if (type == Event.EventType.CHILD_CHANGED && oldType == Event.EventType.CHILD_ADDED) {
            this.changeMap.put(childKey, Change.childAddedChange(childKey, change.getIndexedNode()));
            return;
        }
        if (type == Event.EventType.CHILD_CHANGED && oldType == Event.EventType.CHILD_CHANGED) {
            this.changeMap.put(childKey, Change.childChangedChange(childKey, change.getIndexedNode(), oldChange.getOldIndexedNode()));
            return;
        }
        String string = String.valueOf(change);
        String string2 = String.valueOf(oldChange);
        throw new IllegalStateException(new StringBuilder(48 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Illegal combination of changes: ").append(string).append(" occurred after ").append(string2).toString());
    }

    public List<Change> getChanges() {
        return new ArrayList<Change>(this.changeMap.values());
    }
}

