/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedMapIterator;
import com.google.firebase.database.collection.LLRBBlackValueNode;
import com.google.firebase.database.collection.LLRBEmptyNode;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.LLRBRedValueNode;
import com.google.firebase.database.collection.LLRBValueNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RBTreeSortedMap<K, V>
extends ImmutableSortedMap<K, V> {
    private LLRBNode<K, V> root;
    private Comparator<K> comparator;

    RBTreeSortedMap(Comparator<K> comparator) {
        this.root = LLRBEmptyNode.getInstance();
        this.comparator = comparator;
    }

    private RBTreeSortedMap(LLRBNode<K, V> root, Comparator<K> comparator) {
        this.root = root;
        this.comparator = comparator;
    }

    LLRBNode<K, V> getRoot() {
        return this.root;
    }

    private LLRBNode<K, V> getNode(K key) {
        LLRBNode<K, V> node = this.root;
        while (!node.isEmpty()) {
            int cmp = this.comparator.compare(key, node.getKey());
            if (cmp < 0) {
                node = node.getLeft();
                continue;
            }
            if (cmp == 0) {
                return node;
            }
            node = node.getRight();
        }
        return null;
    }

    @Override
    public boolean containsKey(K key) {
        return this.getNode(key) != null;
    }

    @Override
    public V get(K key) {
        LLRBNode<K, V> node = this.getNode(key);
        return node != null ? (V)node.getValue() : null;
    }

    @Override
    public ImmutableSortedMap<K, V> remove(K key) {
        if (!this.containsKey(key)) {
            return this;
        }
        LLRBNode<Object, Object> newRoot = this.root.remove(key, this.comparator).copy(null, null, LLRBNode.Color.BLACK, null, null);
        return new RBTreeSortedMap<Object, Object>(newRoot, this.comparator);
    }

    @Override
    public ImmutableSortedMap<K, V> insert(K key, V value) {
        LLRBNode<Object, Object> newRoot = this.root.insert(key, value, this.comparator).copy(null, null, LLRBNode.Color.BLACK, null, null);
        return new RBTreeSortedMap<Object, Object>(newRoot, this.comparator);
    }

    @Override
    public K getMinKey() {
        return this.root.getMin().getKey();
    }

    @Override
    public K getMaxKey() {
        return this.root.getMax().getKey();
    }

    @Override
    public int size() {
        return this.root.count();
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public void inOrderTraversal(LLRBNode.NodeVisitor<K, V> visitor) {
        this.root.inOrderTraversal(visitor);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new ImmutableSortedMapIterator<Object, V>(this.root, null, this.comparator, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iteratorFrom(K key) {
        return new ImmutableSortedMapIterator<K, V>(this.root, key, this.comparator, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> reverseIteratorFrom(K key) {
        return new ImmutableSortedMapIterator<K, V>(this.root, key, this.comparator, true);
    }

    @Override
    public Iterator<Map.Entry<K, V>> reverseIterator() {
        return new ImmutableSortedMapIterator<Object, V>(this.root, null, this.comparator, true);
    }

    @Override
    public K getPredecessorKey(K key) {
        LLRBNode<K, V> node = this.root;
        LLRBNode<K, V> rightParent = null;
        while (!node.isEmpty()) {
            int cmp = this.comparator.compare(key, node.getKey());
            if (cmp == 0) {
                if (!node.getLeft().isEmpty()) {
                    node = node.getLeft();
                    while (!node.getRight().isEmpty()) {
                        node = node.getRight();
                    }
                    return node.getKey();
                }
                if (rightParent != null) {
                    return rightParent.getKey();
                }
                return null;
            }
            if (cmp < 0) {
                node = node.getLeft();
                continue;
            }
            rightParent = node;
            node = node.getRight();
        }
        String string = String.valueOf(key);
        throw new IllegalArgumentException(new StringBuilder(50 + String.valueOf(string).length()).append("Couldn't find predecessor key of non-present key: ").append(string).toString());
    }

    @Override
    public K getSuccessorKey(K key) {
        LLRBNode<K, V> node = this.root;
        LLRBNode<K, V> leftParent = null;
        while (!node.isEmpty()) {
            int cmp = this.comparator.compare(node.getKey(), key);
            if (cmp == 0) {
                if (!node.getRight().isEmpty()) {
                    node = node.getRight();
                    while (!node.getLeft().isEmpty()) {
                        node = node.getLeft();
                    }
                    return node.getKey();
                }
                if (leftParent != null) {
                    return leftParent.getKey();
                }
                return null;
            }
            if (cmp < 0) {
                node = node.getRight();
                continue;
            }
            leftParent = node;
            node = node.getLeft();
        }
        String string = String.valueOf(key);
        throw new IllegalArgumentException(new StringBuilder(48 + String.valueOf(string).length()).append("Couldn't find successor key of non-present key: ").append(string).toString());
    }

    @Override
    public Comparator<K> getComparator() {
        return this.comparator;
    }

    public static <A, B, C> RBTreeSortedMap<A, C> buildFrom(List<A> keys, Map<B, C> values, ImmutableSortedMap.Builder.KeyTranslator<A, B> translator, Comparator<A> comparator) {
        return Builder.buildFrom(keys, values, translator, comparator);
    }

    public static <A, B> RBTreeSortedMap<A, B> fromMap(Map<A, B> values, Comparator<A> comparator) {
        return Builder.buildFrom(new ArrayList<A>(values.keySet()), values, ImmutableSortedMap.Builder.identityTranslator(), comparator);
    }

    private static class Builder<A, B, C> {
        private final List<A> keys;
        private final Map<B, C> values;
        private final ImmutableSortedMap.Builder.KeyTranslator<A, B> keyTranslator;
        private LLRBValueNode<A, C> root;
        private LLRBValueNode<A, C> leaf;

        private Builder(List<A> keys, Map<B, C> values, ImmutableSortedMap.Builder.KeyTranslator<A, B> translator) {
            this.keys = keys;
            this.values = values;
            this.keyTranslator = translator;
        }

        private C getValue(A key) {
            return this.values.get(this.keyTranslator.translate(key));
        }

        private LLRBNode<A, C> buildBalancedTree(int start, int size) {
            if (size == 0) {
                return LLRBEmptyNode.getInstance();
            }
            if (size == 1) {
                A key = this.keys.get(start);
                return new LLRBBlackValueNode<A, C>(key, this.getValue(key), null, null);
            }
            int half = size / 2;
            int middle = start + half;
            LLRBNode<A, C> left = this.buildBalancedTree(start, half);
            LLRBNode<A, C> right = this.buildBalancedTree(middle + 1, half);
            A key = this.keys.get(middle);
            return new LLRBBlackValueNode<A, C>(key, this.getValue(key), left, right);
        }

        private void buildPennant(LLRBNode.Color color, int chunkSize, int start) {
            LLRBNode<A, C> treeRoot = this.buildBalancedTree(start + 1, chunkSize - 1);
            A key = this.keys.get(start);
            LLRBValueNode node = color == LLRBNode.Color.RED ? new LLRBRedValueNode<A, C>(key, this.getValue(key), null, treeRoot) : new LLRBBlackValueNode<A, C>(key, this.getValue(key), null, treeRoot);
            if (this.root == null) {
                this.root = node;
                this.leaf = node;
            } else {
                this.leaf.setLeft(node);
                this.leaf = node;
            }
        }

        public static <A, B, C> RBTreeSortedMap<A, C> buildFrom(List<A> keys, Map<B, C> values, ImmutableSortedMap.Builder.KeyTranslator<A, B> translator, Comparator<A> comparator) {
            Builder<A, B, C> builder = new Builder<A, B, C>(keys, values, translator);
            Collections.sort(keys, comparator);
            Iterator<BooleanChunk> iter = new Base1_2(keys.size()).iterator();
            int index = keys.size();
            while (iter.hasNext()) {
                BooleanChunk next = iter.next();
                index -= next.chunkSize;
                if (next.isOne) {
                    super.buildPennant(LLRBNode.Color.BLACK, next.chunkSize, index);
                    continue;
                }
                super.buildPennant(LLRBNode.Color.BLACK, next.chunkSize, index);
                super.buildPennant(LLRBNode.Color.RED, next.chunkSize, index -= next.chunkSize);
            }
            return new RBTreeSortedMap(builder.root == null ? LLRBEmptyNode.getInstance() : builder.root, comparator);
        }

        static class Base1_2
        implements Iterable<BooleanChunk> {
            private long value;
            private final int length;

            public Base1_2(int size) {
                int toCalc = size + 1;
                this.length = (int)Math.floor(Math.log(toCalc) / Math.log(2.0));
                long mask = (long)Math.pow(2.0, this.length) - 1L;
                this.value = (long)toCalc & mask;
            }

            @Override
            public Iterator<BooleanChunk> iterator() {
                return new Iterator<BooleanChunk>(){
                    private int current;
                    {
                        this.current = length - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current >= 0;
                    }

                    @Override
                    public BooleanChunk next() {
                        long result = value & (long)(1 << this.current);
                        BooleanChunk next = new BooleanChunk();
                        next.isOne = result == 0L;
                        next.chunkSize = (int)Math.pow(2.0, this.current);
                        --this.current;
                        return next;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        }

        static class BooleanChunk {
            public boolean isOne;
            public int chunkSize;

            BooleanChunk() {
            }
        }
    }
}

