/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.Key;
import java.io.IOException;
import java.util.Map;

public final class FirebaseToken {
    private final FirebaseTokenImpl token;

    FirebaseToken(FirebaseTokenImpl token) {
        this.token = token;
    }

    public String getUid() {
        return this.token.getPayload().getSubject();
    }

    public String getIssuer() {
        return this.token.getPayload().getIssuer();
    }

    public String getName() {
        return this.token.getPayload().getName();
    }

    public String getPicture() {
        return this.token.getPayload().getPicture();
    }

    public String getEmail() {
        return this.token.getPayload().getEmail();
    }

    public boolean isEmailVerified() {
        return this.token.getPayload().isEmailVerified();
    }

    public Map<String, Object> getClaims() {
        return this.token.getPayload();
    }

    FirebaseTokenImpl getToken() {
        return this.token;
    }

    static FirebaseToken parse(JsonFactory jsonFactory, String tokenString) throws IOException {
        JsonWebSignature jws = JsonWebSignature.parser((JsonFactory)jsonFactory).setPayloadClass(FirebaseTokenImpl.Payload.class).parse(tokenString);
        return new FirebaseToken(new FirebaseTokenImpl(jws.getHeader(), (FirebaseTokenImpl.Payload)jws.getPayload(), jws.getSignatureBytes(), jws.getSignedContentBytes()));
    }

    static class FirebaseTokenImpl
    extends IdToken {
        FirebaseTokenImpl(JsonWebSignature.Header header, Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
            super(header, (IdToken.Payload)payload, signatureBytes, signedContentBytes);
        }

        public Payload getPayload() {
            return (Payload)super.getPayload();
        }

        public static class Payload
        extends IdToken.Payload {
            @Key(value="auth_time")
            private long authTime;
            @Key
            private String email;
            @Key(value="email_verified")
            private boolean emailVerified;
            @Key
            private String name;
            @Key
            private String picture;

            public String getUid() {
                return this.getSubject();
            }

            public long getAuthTime() {
                return this.authTime;
            }

            public String getEmail() {
                return this.email;
            }

            public boolean isEmailVerified() {
                return this.emailVerified;
            }

            public String getName() {
                return this.name;
            }

            public String getPicture() {
                return this.picture;
            }
        }
    }
}

