/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.gradle;

import com.android.build.api.variant.AndroidComponentsExtension;
import com.google.devtools.ksp.gradle.AndroidPluginIntegration;
import com.google.devtools.ksp.gradle.KgpUtilsKt;
import com.google.devtools.ksp.gradle.KspConfigurations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.AppliedPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinSingleTargetExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinBaseApiPlugin;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinCommonCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmAndroidCompilation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ\u001a\u0010 \u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\u000bH\u0002J\u001c\u0010\"\u001a\u00020\u000b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010!\u001a\u00020#H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/google/devtools/ksp/gradle/KspConfigurations;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "allowAllTargetConfiguration", "", "configurationForAll", "Lorg/gradle/api/artifacts/Configuration;", "kotlin.jvm.PlatformType", "configurationNameOf", "", "parts", "", "([Ljava/lang/String;)Ljava/lang/String;", "createAndroidSourceSetConfigurations", "", "kotlinTarget", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "createConfiguration", "name", "readableSetName", "decorateKotlinProject", "kotlin", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinProjectExtension;", "decorateKotlinTarget", "target", "isKotlinMultiplatform", "find", "", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "getAndroidConfigurationName", "sourceSet", "getKotlinConfigurationName", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "Companion", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nKspConfigurations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KspConfigurations.kt\ncom/google/devtools/ksp/gradle/KspConfigurations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1#2:216\n1#2:233\n1628#3,3:217\n1628#3,3:220\n1611#3,9:223\n1863#3:232\n1864#3:234\n1620#3:235\n*S KotlinDebug\n*F\n+ 1 KspConfigurations.kt\ncom/google/devtools/ksp/gradle/KspConfigurations\n*L\n196#1:233\n181#1:217,3\n186#1:220,3\n196#1:223,9\n196#1:232\n196#1:234\n196#1:235\n*E\n"})
public final class KspConfigurations {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean allowAllTargetConfiguration;
    private final Configuration configurationForAll;
    @NotNull
    private static final String PREFIX = "ksp";

    /*
     * WARNING - void declaration
     */
    public KspConfigurations(@NotNull Project project) {
        void $this$configurationForAll_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Object object = (String)this.project.getProviders().gradleProperty("ksp.allow.all.target.configuration").getOrNull();
        this.allowAllTargetConfiguration = object != null ? Boolean.parseBoolean((String)object) : true;
        object = this.project.getConfigurations().create(PREFIX);
        Configuration configuration = (Configuration)object;
        KspConfigurations kspConfigurations = this;
        boolean bl = false;
        $this$configurationForAll_u24lambda_u240.setCanBeConsumed(false);
        $this$configurationForAll_u24lambda_u240.setCanBeResolved(false);
        $this$configurationForAll_u24lambda_u240.setVisible(false);
        kspConfigurations.configurationForAll = (Configuration)object;
        this.project.getPlugins().withType(KotlinBasePluginWrapper.class).configureEach(arg_0 -> KspConfigurations._init_$lambda$3((Function1)new Function1<KotlinBasePluginWrapper, Unit>(){

            public final void invoke(KotlinBasePluginWrapper it) {
                this.decorateKotlinProject(KotlinProjectExtensionKt.getKotlinExtension((Project)project), project);
            }
        }, arg_0));
        this.project.getPlugins().withType(KotlinBaseApiPlugin.class).configureEach(arg_0 -> KspConfigurations._init_$lambda$4((Function1)new Function1<KotlinBaseApiPlugin, Unit>(){

            public final void invoke(KotlinBaseApiPlugin it) {
                this.createAndroidSourceSetConfigurations(project, null);
            }
        }, arg_0));
        this.project.getPluginManager().withPlugin("com.android.base", arg_0 -> KspConfigurations._init_$lambda$5((Function1)new Function1<AppliedPlugin, Unit>(){

            public final void invoke(AppliedPlugin it) {
                block1: {
                    AndroidComponentsExtension androidComponents;
                    if (AndroidPluginIntegration.INSTANCE.useLegacyVariantApi(project)) break block1;
                    AndroidComponentsExtension androidComponentsExtension = androidComponents = (AndroidComponentsExtension)project.getExtensions().findByType(AndroidComponentsExtension.class);
                    if (androidComponentsExtension != null) {
                        androidComponentsExtension.addKspConfigurations(allowAllTargetConfiguration);
                    }
                }
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final String configurationNameOf(String ... parts) {
        String string;
        String string2 = ArraysKt.joinToString$default((Object[])parts, (CharSequence)"", null, null, (int)0, null, (Function1)configurationNameOf.1.INSTANCE, (int)30, null);
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }

    private final Configuration createConfiguration(String name, String readableSetName) {
        Object object = this.project.getConfigurations().maybeCreate(name);
        Configuration $this$createConfiguration_u24lambda_u242 = (Configuration)object;
        boolean bl = false;
        $this$createConfiguration_u24lambda_u242.setDescription("KSP dependencies for the '" + readableSetName + "' source set.");
        $this$createConfiguration_u24lambda_u242.setCanBeResolved(false);
        $this$createConfiguration_u24lambda_u242.setCanBeConsumed(false);
        $this$createConfiguration_u24lambda_u242.setVisible(false);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"apply(...)");
        return (Configuration)object2;
    }

    private final String getAndroidConfigurationName(KotlinTarget kotlinTarget, String sourceSet) {
        String string;
        boolean isMain = StringsKt.endsWith((String)sourceSet, (String)"main", (boolean)true);
        if (isMain) {
            String string2 = sourceSet.substring(0, sourceSet.length() - 4);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = sourceSet;
        }
        String nameWithoutMain = string;
        String[] stringArray = new String[3];
        stringArray[0] = PREFIX;
        Object object = kotlinTarget;
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        stringArray[1] = object;
        stringArray[2] = nameWithoutMain;
        return this.configurationNameOf(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private final String getKotlinConfigurationName(KotlinCompilation<?> compilation, KotlinSourceSet sourceSet) {
        String[] stringArray;
        Object object;
        boolean isDefault;
        boolean isMain = Intrinsics.areEqual((Object)compilation.getName(), (Object)"main");
        boolean bl = isDefault = Intrinsics.areEqual((Object)sourceSet.getName(), (Object)compilation.getDefaultSourceSet().getName()) && !(compilation instanceof KotlinCommonCompilation);
        if (isMain && isDefault) {
            String targetName = compilation.getTarget().getName();
            object = (Intrinsics.areEqual((Object)targetName, (Object)"jsLegacy") ? true : Intrinsics.areEqual((Object)targetName, (Object)"jsIr")) ? "js" : targetName;
        } else if (compilation instanceof KotlinCommonCompilation) {
            Object object2;
            String string = sourceSet.getName();
            stringArray = compilation.getTarget().getName();
            if (((CharSequence)stringArray).length() > 0) {
                void p0;
                char c = stringArray.charAt(0);
                String string2 = string;
                boolean bl2 = false;
                char c2 = Character.toUpperCase((char)p0);
                string = string2;
                c = c2;
                Object object3 = stringArray;
                int n = 1;
                String string3 = object3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                object3 = string3;
                object2 = c + (String)object3;
            } else {
                object2 = stringArray;
            }
            object = string + (String)object2;
        } else {
            object = sourceSet.getName();
        }
        String name = object;
        stringArray = new String[2];
        stringArray[0] = PREFIX;
        Intrinsics.checkNotNull((Object)name);
        stringArray[1] = name;
        return this.configurationNameOf(stringArray);
    }

    private final void decorateKotlinProject(KotlinProjectExtension kotlin, Project project) {
        KotlinProjectExtension kotlinProjectExtension = kotlin;
        if (kotlinProjectExtension instanceof KotlinSingleTargetExtension) {
            this.decorateKotlinTarget(((KotlinSingleTargetExtension)kotlin).getTarget(), false);
        } else if (kotlinProjectExtension instanceof KotlinMultiplatformExtension) {
            ((KotlinMultiplatformExtension)kotlin).getTargets().configureEach(arg_0 -> KspConfigurations.decorateKotlinProject$lambda$6((Function1)new Function1<KotlinTarget, Unit>(this){
                final /* synthetic */ KspConfigurations this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(KotlinTarget it) {
                    Intrinsics.checkNotNull((Object)it);
                    KspConfigurations.access$decorateKotlinTarget(this.this$0, it, true);
                }
            }, arg_0));
            Ref.BooleanRef reported = new Ref.BooleanRef();
            this.configurationForAll.getDependencies().whenObjectAdded(arg_0 -> KspConfigurations.decorateKotlinProject$lambda$7((Function1)new Function1<Dependency, Unit>(reported, this, project){
                final /* synthetic */ Ref.BooleanRef $reported;
                final /* synthetic */ KspConfigurations this$0;
                final /* synthetic */ Project $project;
                {
                    this.$reported = $reported;
                    this.this$0 = $receiver;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(Dependency it) {
                    if (!this.$reported.element) {
                        this.$reported.element = true;
                        String msg = "The 'ksp' configuration is deprecated in Kotlin Multiplatform projects. Please use target-specific configurations like 'kspJvm' instead.";
                        if (KspConfigurations.access$getAllowAllTargetConfiguration$p(this.this$0)) {
                            this.$project.getLogger().warn(msg);
                        } else {
                            throw new InvalidUserCodeException(msg);
                        }
                    }
                }
            }, arg_0));
        }
    }

    private final void decorateKotlinTarget(KotlinTarget target, boolean isKotlinMultiplatform) {
        if (target.getPlatformType() == KotlinPlatformType.androidJvm) {
            if (AndroidPluginIntegration.INSTANCE.useLegacyVariantApi(this.project) || isKotlinMultiplatform) {
                this.createAndroidSourceSetConfigurations(target.getProject(), target);
            }
        } else {
            target.getCompilations().configureEach(arg_0 -> KspConfigurations.decorateKotlinTarget$lambda$8((Function1)new Function1<KotlinCompilation<? extends Object>, Unit>(this){
                final /* synthetic */ KspConfigurations this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(KotlinCompilation<? extends Object> compilation) {
                    Intrinsics.checkNotNull(compilation);
                    KgpUtilsKt.getKotlinSourceSetsObservable(compilation).forAll((Function1)new Function1<KotlinSourceSet, Unit>(this.this$0, compilation){
                        final /* synthetic */ KspConfigurations this$0;
                        final /* synthetic */ KotlinCompilation<? extends Object> $compilation;
                        {
                            this.this$0 = $receiver;
                            this.$compilation = $compilation;
                            super(1);
                        }

                        public final void invoke(KotlinSourceSet sourceSet) {
                            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                            KotlinCompilation<? extends Object> kotlinCompilation = this.$compilation;
                            Intrinsics.checkNotNull(kotlinCompilation);
                            String string = KspConfigurations.access$getKotlinConfigurationName(this.this$0, kotlinCompilation, sourceSet);
                            String string2 = sourceSet.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                            KspConfigurations.access$createConfiguration(this.this$0, string, string2);
                        }
                    });
                }
            }, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Configuration> find(@NotNull KotlinCompilation<?> compilation) {
        void $this$mapNotNullTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(compilation, (String)"compilation");
        List results = new ArrayList();
        if (compilation instanceof KotlinCommonCompilation) {
            results.add(this.getKotlinConfigurationName(compilation, compilation.getDefaultSourceSet()));
        }
        Iterable iterable = compilation.getKotlinSourceSets();
        Collection destination$iv = results;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(this.getKotlinConfigurationName(compilation, (KotlinSourceSet)it));
        }
        if (compilation.getPlatformType() == KotlinPlatformType.androidJvm) {
            KotlinJvmAndroidCompilation cfr_ignored_0 = (KotlinJvmAndroidCompilation)compilation;
            $this$mapTo$iv = AndroidPluginIntegration.INSTANCE.getCompilationSourceSets((KotlinJvmAndroidCompilation)compilation);
            destination$iv = results;
            $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                it = (String)item$iv;
                collection = destination$iv;
                boolean bl = false;
                collection.add(this.getAndroidConfigurationName((KotlinTarget)((KotlinJvmAndroidCompilation)compilation).getTarget(), it));
            }
        }
        if (this.allowAllTargetConfiguration) {
            String string = this.configurationForAll.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            results.add(string);
        }
        Iterable $this$mapNotNull$iv = results;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$mapTo2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Configuration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((Configuration)compilation.getTarget().getProject().getConfigurations().findByName(it2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final void createAndroidSourceSetConfigurations(Project project, KotlinTarget kotlinTarget) {
        AndroidPluginIntegration.INSTANCE.forEachAndroidSourceSet(project, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, kotlinTarget){
            final /* synthetic */ KspConfigurations this$0;
            final /* synthetic */ KotlinTarget $kotlinTarget;
            {
                this.this$0 = $receiver;
                this.$kotlinTarget = $kotlinTarget;
                super(1);
            }

            public final void invoke(String sourceSet) {
                Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
                KspConfigurations.access$createConfiguration(this.this$0, KspConfigurations.access$getAndroidConfigurationName(this.this$0, this.$kotlinTarget, sourceSet), sourceSet + " (Android)");
            }
        }));
    }

    private static final void _init_$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void _init_$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void _init_$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void decorateKotlinProject$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void decorateKotlinProject$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void decorateKotlinTarget$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$decorateKotlinTarget(KspConfigurations $this, KotlinTarget target, boolean isKotlinMultiplatform) {
        $this.decorateKotlinTarget(target, isKotlinMultiplatform);
    }

    public static final /* synthetic */ Configuration access$createConfiguration(KspConfigurations $this, String name, String readableSetName) {
        return $this.createConfiguration(name, readableSetName);
    }

    public static final /* synthetic */ String access$getKotlinConfigurationName(KspConfigurations $this, KotlinCompilation compilation, KotlinSourceSet sourceSet) {
        return $this.getKotlinConfigurationName(compilation, sourceSet);
    }

    public static final /* synthetic */ String access$getAndroidConfigurationName(KspConfigurations $this, KotlinTarget kotlinTarget, String sourceSet) {
        return $this.getAndroidConfigurationName(kotlinTarget, sourceSet);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/devtools/ksp/gradle/KspConfigurations$Companion;", "", "()V", "PREFIX", "", "gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

