/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.indexing.FileContent;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<ClassFileDecompilers.Full> {
    private static final Logger LOG = Logger.getInstance(ClassFileStubBuilder.class);
    public static final int STUB_VERSION = 27;

    @Override
    @NotNull
    public VirtualFileFilter getFileFilter() {
        VirtualFileFilter virtualFileFilter = VirtualFileFilter.ALL;
        if (virtualFileFilter == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(0);
        }
        return virtualFileFilter;
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    @NotNull
    public Stream<ClassFileDecompilers.Full> getAllSubBuilders() {
        Stream<ClassFileDecompilers.Full> stream = ClassFileDecompilers.getInstance().EP_NAME.getExtensionList().stream().filter(d2 -> d2 instanceof ClassFileDecompilers.Full).map(d2 -> (ClassFileDecompilers.Full)d2);
        if (stream == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(2);
        }
        return stream;
    }

    @Override
    @Nullable
    public ClassFileDecompilers.Full getSubBuilder(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(3);
        }
        return fileContent.getFile().computeWithPreloadedContentHint(fileContent.getContent(), () -> ClassFileDecompilers.getInstance().find(fileContent.getFile(), ClassFileDecompilers.Full.class));
    }

    @Override
    @NotNull
    public String getSubBuilderVersion(@Nullable ClassFileDecompilers.Full decompiler) {
        if (decompiler == null) {
            return "default";
        }
        int version = decompiler.getStubBuilder().getStubVersion();
        String string = decompiler.getClass().getName() + ":" + version;
        if (string == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable ClassFileDecompilers.Full decompiler) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(5);
        }
        if (decompiler == null) {
            return null;
        }
        return fileContent.getFile().computeWithPreloadedContentHint(fileContent.getContent(), () -> {
            VirtualFile file = fileContent.getFile();
            try {
                return decompiler.getStubBuilder().buildFileStub(fileContent);
            }
            catch (ClsFormatException e2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file.getPath(), e2);
                } else {
                    LOG.info(file.getPath() + ": " + e2.getMessage());
                }
                return null;
            }
        });
    }

    @Override
    public int getStubVersion() {
        return 27;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileFilter";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubBuilders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBuilderVersion";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

