/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stub;

import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaStubImplUtil {
    public static int getMethodStubIndex(PsiMethod method) {
        if (!(method instanceof PsiMethodImpl)) {
            return -1;
        }
        PsiFileImpl file = (PsiFileImpl)method.getContainingFile();
        StubbedSpine spine = file.getStubbedSpine();
        int result2 = 0;
        for (int i2 = 0; i2 < spine.getStubCount(); ++i2) {
            if (spine.getStubType(i2) != JavaElementType.METHOD) continue;
            if (spine.getStubPsi(i2) == method) {
                return result2;
            }
            ++result2;
        }
        return -1;
    }

    public static <T extends PsiMember & PsiJavaDocumentedElement> boolean isMemberDeprecated(@NotNull T member, @Nullable PsiMemberStub<?> stub2) {
        if (member == null) {
            JavaStubImplUtil.$$$reportNull$$$0(0);
        }
        if (stub2 != null) {
            return stub2.isDeprecated() || stub2.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(member);
        }
        return PsiImplUtil.isDeprecatedByDocTag(member) || PsiImplUtil.isDeprecatedByAnnotation(member);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/stub/JavaStubImplUtil", "isMemberDeprecated"));
    }
}

