/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.experimental;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/experimental/RedundantExplicitTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "isSame", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "other", "Lorg/jetbrains/kotlin/name/ClassId;", "hasSameNameWithoutModifiers", "name", "Lorg/jetbrains/kotlin/name/Name;", "checkers"})
@SourceDebugExtension(value={"SMAP\nRedundantExplicitTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantExplicitTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/experimental/RedundantExplicitTypeChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class RedundantExplicitTypeChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final RedundantExplicitTypeChecker INSTANCE = new RedundantExplicitTypeChecker();

    private RedundantExplicitTypeChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration2) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!declaration2.isLocal()) {
            return;
        }
        if (declaration2.getReturnTypeRef().getSource() == null) {
            return;
        }
        FirExpression firExpression = declaration2.getInitializer();
        FirExpression firExpression2 = firExpression;
        if (firExpression == null) return;
        if ((firExpression2 = FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2)) == null) {
            return;
        }
        FirExpression initializer = firExpression2;
        FirTypeRef it = firTypeRef = declaration2.getReturnTypeRef();
        boolean bl2 = false;
        if (it instanceof FirErrorTypeRef) return;
        FirTypeRef firTypeRef2 = firTypeRef;
        if (firTypeRef2 == null) {
            return;
        }
        FirTypeRef typeReference = firTypeRef2;
        KtSourceElement ktSourceElement = typeReference.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(typeReference), context2.getSession(), null, 2, null);
        if (AbbreviatedTypeAttributeKt.getAbbreviatedType(type2) != null) {
            return;
        }
        if (!((Collection)typeReference.getAnnotations()).isEmpty()) {
            return;
        }
        boolean bl3 = false;
        if (bl3) {
            return;
        }
        FirExpression firExpression3 = initializer;
        if (firExpression3 instanceof FirLiteralExpression) {
            IElementType iElementType;
            KtSourceElement ktSourceElement2 = ((FirLiteralExpression)initializer).getSource();
            IElementType iElementType2 = iElementType = ktSourceElement2 != null ? ktSourceElement2.getElementType() : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getBoolean())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                if (Intrinsics.areEqual((Object)((FirLiteralExpression)initializer).getKind(), (Object)ConstantValueKind.Long.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getLong()) : !this.isSame(type2, StandardClassIds.INSTANCE.getInt())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
                if (Intrinsics.areEqual((Object)((FirLiteralExpression)initializer).getKind(), (Object)ConstantValueKind.Float.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getFloat()) : !this.isSame(type2, StandardClassIds.INSTANCE.getDouble())) {
                    return;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getChar())) {
                    return;
                }
            } else {
                if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.STRING_TEMPLATE)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        } else if (firExpression3 instanceof FirFunctionCall) {
            if (!this.hasSameNameWithoutModifiers(type2, ((FirFunctionCall)initializer).getCalleeReference().getName())) {
                return;
            }
        } else {
            if (firExpression3 instanceof FirGetClassCall) {
                return;
            }
            if (firExpression3 instanceof FirResolvedQualifier) {
                if (!this.isSame(type2, ((FirResolvedQualifier)initializer).getClassId())) {
                    return;
                }
            } else {
                if (!(firExpression3 instanceof FirStringConcatenationCall)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_TYPE(), null, 8, null);
    }

    private final boolean isSame(ConeKotlinType $this$isSame, ClassId other) {
        if (ConeTypeUtilsKt.isMarkedNullable($this$isSame)) {
            return false;
        }
        return Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId($this$isSame), (Object)other);
    }

    private final boolean hasSameNameWithoutModifiers(ConeKotlinType $this$hasSameNameWithoutModifiers, Name name2) {
        return $this$hasSameNameWithoutModifiers instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)$this$hasSameNameWithoutModifiers).getLookupTag().getName(), (Object)name2) && $this$hasSameNameWithoutModifiers.getTypeArguments().length == 0 && !((ConeClassLikeType)$this$hasSameNameWithoutModifiers).isMarkedNullable();
    }
}

