/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@PhaseDescription(name="EnumExternalEntries")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0018\u00010\fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "state", "Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "EntriesMappingState", "backend.jvm.lower"})
public final class EnumExternalEntriesLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @Nullable
    private EntriesMappingState state;

    public EnumExternalEntriesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.EnumEntries)) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        boolean shouldBeLowered;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrSimpleFunction owner = (IrSimpleFunction)expression2.getSymbol().getOwner();
        IrDeclarationParent irDeclarationParent = owner.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return super.visitCall(expression2);
        }
        IrClass parentClass = irClass;
        boolean bl2 = shouldBeLowered = Intrinsics.areEqual((Object)owner.getName(), (Object)SpecialNames.ENUM_GET_ENTRIES) && JvmIrUtilsKt.isEnumClassWhichRequiresExternalEntries(parentClass);
        if (!shouldBeLowered) {
            return super.visitCall(expression2);
        }
        EntriesMappingState entriesMappingState = this.state;
        Intrinsics.checkNotNull((Object)entriesMappingState);
        IrField field = entriesMappingState.getEntriesFieldForEnum(parentClass);
        return BuildersKt.IrGetFieldImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), field.getSymbol(), field.getType(), null, null, 48, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        EntriesMappingState mappingState;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        EntriesMappingState oldState = this.state;
        this.state = mappingState = new EntriesMappingState();
        super.visitClassNew(declaration2);
        for (Map.Entry<IrClass, IrField> object : mappingState.getMappings().entrySet()) {
            void $this$visitClassNew_u24lambda_u241_u24lambda_u240;
            void $this$visitClassNew_u24lambda_u241;
            IrCall irCall;
            IrClass irClass = object.getKey();
            IrField field = object.getValue();
            IrSimpleFunction enumValues = JvmIrUtilsKt.findEnumValuesFunction(irClass, this.context);
            DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)field.getSymbol(), 0, 0, 6, null);
            IrField irField = field;
            boolean bl2 = false;
            IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$visitClassNew_u24lambda_u241, this.context.getSymbols().getCreateEnumEntries());
            IrBuilder irBuilder = (IrBuilder)$this$visitClassNew_u24lambda_u241;
            boolean bl3 = false;
            $this$visitClassNew_u24lambda_u241_u24lambda_u240.getArguments().set(0, ExpressionHelpersKt.irCall((IrBuilder)$this$visitClassNew_u24lambda_u241, enumValues));
            irField.setInitializer(ExpressionHelpersKt.irExprBody(irBuilder, irCall));
        }
        if (!mappingState.getMappings().isEmpty()) {
            IrClass irClass;
            Collection collection = declaration2.getDeclarations();
            IrClass $this$visitClassNew_u24lambda_u242 = irClass = mappingState.getMappingsClass();
            boolean bl4 = false;
            $this$visitClassNew_u24lambda_u242.setParent(declaration2);
            IrClass irClass2 = irClass;
            collection.add(irClass2);
        }
        this.state = oldState;
        return declaration2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState;", "", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering;)V", "mappings", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getMappings", "()Ljava/util/Map;", "mappingsClass", "getMappingsClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "mappingsClass$delegate", "Lkotlin/Lazy;", "getEntriesFieldForEnum", "enumClass", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nEnumExternalEntriesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumExternalEntriesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,135:1\n382#2,3:136\n385#2,4:150\n81#3:139\n75#3,10:140\n51#3,4:154\n*S KotlinDebug\n*F\n+ 1 EnumExternalEntriesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/EnumExternalEntriesLowering$EntriesMappingState\n*L\n87#1:136,3\n87#1:150,4\n88#1:139\n88#1:140,10\n78#1:154,4\n*E\n"})
    private final class EntriesMappingState {
        @NotNull
        private final Map<IrClass, IrField> mappings = new LinkedHashMap();
        @NotNull
        private final Lazy mappingsClass$delegate = LazyKt.lazy(() -> EntriesMappingState.mappingsClass_delegate$lambda$2(EnumExternalEntriesLowering.this));

        @NotNull
        public final Map<IrClass, IrField> getMappings() {
            return this.mappings;
        }

        @NotNull
        public final IrClass getMappingsClass() {
            Lazy lazy = this.mappingsClass$delegate;
            return (IrClass)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IrField getEntriesFieldForEnum(@NotNull IrClass enumClass) {
            Object object;
            void key$iv;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)enumClass, (String)"enumClass");
            Map<IrClass, IrField> map = this.mappings;
            IrClass irClass = enumClass;
            EnumExternalEntriesLowering enumExternalEntriesLowering = EnumExternalEntriesLowering.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                IrField irField;
                boolean bl2 = false;
                IrClass $this$addField$iv = this.getMappingsClass();
                boolean $i$f$addField = false;
                IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
                boolean $i$f$buildField = false;
                IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
                boolean bl3 = false;
                IrFieldBuilder $this$getEntriesFieldForEnum_u24lambda_u244_u24lambda_u243 = $this$buildField_u24lambda_u244$iv$iv;
                boolean bl4 = false;
                Name name2 = Name.identifier("entries$" + this.mappings.size());
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                $this$getEntriesFieldForEnum_u24lambda_u244_u24lambda_u243.setName(name2);
                IrType[] irTypeArray = new IrType[]{IrUtilsKt.getDefaultType(enumClass)};
                $this$getEntriesFieldForEnum_u24lambda_u244_u24lambda_u243.setType(IrTypesKt.typeWith((IrClassifierSymbol)enumExternalEntriesLowering.context.getSymbols().getEnumEntries(), irTypeArray));
                $this$getEntriesFieldForEnum_u24lambda_u244_u24lambda_u243.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getENUM_MAPPINGS_FOR_ENTRIES());
                $this$getEntriesFieldForEnum_u24lambda_u244_u24lambda_u243.setFinal(true);
                $this$getEntriesFieldForEnum_u24lambda_u244_u24lambda_u243.setStatic(true);
                IrField field$iv = irField = DeclarationBuildersKt.buildField($this$buildField$iv$iv, $this$buildField_u24lambda_u244$iv$iv);
                boolean bl5 = false;
                field$iv.setParent($this$addField$iv);
                $this$addField$iv.getDeclarations().add(field$iv);
                IrField answer$iv = irField;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (IrField)object;
        }

        private static final IrClass mappingsClass_delegate$lambda$2(EnumExternalEntriesLowering this$0) {
            IrClass irClass;
            IrFactory $this$buildClass$iv = this$0.context.getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
            boolean bl2 = false;
            IrClassBuilder $this$mappingsClass_delegate_u24lambda_u242_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
            boolean bl3 = false;
            Name name2 = Name.identifier("EntriesMappings");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            $this$mappingsClass_delegate_u24lambda_u242_u24lambda_u240.setName(name2);
            $this$mappingsClass_delegate_u24lambda_u242_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getENUM_MAPPINGS_FOR_ENTRIES());
            IrClass $this$mappingsClass_delegate_u24lambda_u242_u24lambda_u241 = irClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
            boolean bl4 = false;
            IrUtilsKt.createThisReceiverParameter($this$mappingsClass_delegate_u24lambda_u242_u24lambda_u241);
            return irClass;
        }
    }
}

