/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.util.SmartFMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ObservableBindingTrace
implements BindingTrace {
    private final BindingTrace originalTrace;
    private SmartFMap<WritableSlice, RecordHandler> handlers = SmartFMap.emptyMap();

    public ObservableBindingTrace(BindingTrace originalTrace) {
        this.originalTrace = originalTrace;
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            ObservableBindingTrace.$$$reportNull$$$0(0);
        }
        this.originalTrace.report(diagnostic);
    }

    @Override
    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext = this.originalTrace.getBindingContext();
        if (bindingContext == null) {
            ObservableBindingTrace.$$$reportNull$$$0(1);
        }
        return bindingContext;
    }

    @Override
    public <K, V> void record(WritableSlice<K, V> slice, K key, V value2) {
        this.originalTrace.record(slice, key, value2);
        RecordHandler recordHandler = this.handlers.get(slice);
        if (recordHandler != null) {
            recordHandler.handleRecord(slice, key, value2);
        }
    }

    @Override
    public <K> void record(WritableSlice<K, Boolean> slice, K key) {
        this.record(slice, key, true);
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return this.originalTrace.get(slice, key);
    }

    @Override
    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        Collection<K> collection = this.originalTrace.getKeys(slice);
        if (collection == null) {
            ObservableBindingTrace.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @Nullable
    public KotlinType getType(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            ObservableBindingTrace.$$$reportNull$$$0(3);
        }
        return this.originalTrace.getType(expression2);
    }

    @Override
    public void recordType(@NotNull KtExpression expression2, @Nullable KotlinType type2) {
        if (expression2 == null) {
            ObservableBindingTrace.$$$reportNull$$$0(4);
        }
        this.originalTrace.recordType(expression2, type2);
    }

    public <K, V> ObservableBindingTrace addHandler(@NotNull WritableSlice<K, V> slice, @NotNull RecordHandler<K, V> handler2) {
        if (slice == null) {
            ObservableBindingTrace.$$$reportNull$$$0(5);
        }
        if (handler2 == null) {
            ObservableBindingTrace.$$$reportNull$$$0(6);
        }
        this.handlers = this.handlers.plus(slice, handler2);
        return this;
    }

    @Override
    public boolean wantsDiagnostics() {
        return this.originalTrace.wantsDiagnostics();
    }

    public String toString() {
        return "ObservableTrace over " + this.originalTrace.toString();
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.originalTrace.getProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/ObservableBindingTrace";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/ObservableBindingTrace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "report";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "recordType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RecordHandler<K, V> {
        public void handleRecord(WritableSlice<K, V> var1, K var2, V var3);
    }
}

