/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationsKt;
import org.jetbrains.kotlin.resolve.checkers.KotlinVersionStringAnnotationValueChecker;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SinceKotlinAnnotationValueChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/KotlinVersionStringAnnotationValueChecker;", "<init>", "()V", "extraCheck", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "version", "", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class SinceKotlinAnnotationValueChecker
extends KotlinVersionStringAnnotationValueChecker {
    @NotNull
    public static final SinceKotlinAnnotationValueChecker INSTANCE = new SinceKotlinAnnotationValueChecker();

    private SinceKotlinAnnotationValueChecker() {
        super(AnnotationsKt.getSINCE_KOTLIN_FQ_NAME());
    }

    @Override
    public void extraCheck(@NotNull KtDeclaration declaration2, @NotNull AnnotationDescriptor annotation, @NotNull String version, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        ApiVersion apiVersion = ApiVersion.Companion.parse(version);
        ApiVersion specified = languageVersionSettings.getApiVersion();
        if (apiVersion != null && apiVersion.compareTo(specified) > 0) {
            PsiElement psiElement = PsiSourceElementKt.getPsi(annotation.getSource());
            if (psiElement == null) {
                psiElement = declaration2;
            }
            diagnosticHolder.report(Errors.NEWER_VERSION_IN_SINCE_KOTLIN.on(psiElement, specified.getVersionString()));
        }
    }
}

