/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.PrimitivesKt;
import org.jetbrains.kotlin.fir.StandardTypes;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.PrimitiveConeNumericComparisonInfo;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u001a\f\u0010\u000f\u001a\u00020\f*\u00020\fH\u0002\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\f*\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0012"}, d2={"left", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;", "getLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirComparisonExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "right", "getRight", "inferPrimitiveNumericComparisonInfo", "Lorg/jetbrains/kotlin/fir/backend/PrimitiveConeNumericComparisonInfo;", "c", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "leastCommonPrimitiveNumericType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "t1", "t2", "promoteIntegerTypeToIntIfRequired", "getPrimitiveTypeOrSupertype", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nPrimitiveComparison.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveComparison.kt\norg/jetbrains/kotlin/fir/backend/PrimitiveComparisonKt\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,79:1\n46#2:80\n*S KotlinDebug\n*F\n+ 1 PrimitiveComparison.kt\norg/jetbrains/kotlin/fir/backend/PrimitiveComparisonKt\n*L\n25#1:80\n*E\n"})
public final class PrimitiveComparisonKt {
    @NotNull
    public static final FirExpression getLeft(@NotNull FirComparisonExpression $this$left) {
        Intrinsics.checkNotNullParameter((Object)$this$left, (String)"<this>");
        FirExpression firExpression = $this$left.getCompareToCall().getExplicitReceiver();
        if (firExpression == null) {
            throw new IllegalStateException(("There should be an explicit receiver for " + UtilsKt.render($this$left.getCompareToCall())).toString());
        }
        return firExpression;
    }

    @NotNull
    public static final FirExpression getRight(@NotNull FirComparisonExpression $this$right) {
        Intrinsics.checkNotNullParameter((Object)$this$right, (String)"<this>");
        FirCall $this$arguments$iv = $this$right.getCompareToCall();
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), (int)0);
        if (firExpression == null) {
            throw new IllegalStateException(("There should be a first arg for " + UtilsKt.render($this$right.getCompareToCall())).toString());
        }
        return firExpression;
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull FirComparisonExpression $this$inferPrimitiveNumericComparisonInfo, @NotNull Fir2IrComponents c2) {
        Intrinsics.checkNotNullParameter((Object)$this$inferPrimitiveNumericComparisonInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        return PrimitiveComparisonKt.inferPrimitiveNumericComparisonInfo(PrimitiveComparisonKt.getLeft($this$inferPrimitiveNumericComparisonInfo), PrimitiveComparisonKt.getRight($this$inferPrimitiveNumericComparisonInfo), c2);
    }

    @Nullable
    public static final PrimitiveConeNumericComparisonInfo inferPrimitiveNumericComparisonInfo(@NotNull FirExpression left, @NotNull FirExpression right, @NotNull Fir2IrComponents c2) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        ConeKotlinType leftType = FirTypeUtilsKt.getResolvedType(left);
        ConeKotlinType rightType = FirTypeUtilsKt.getResolvedType(right);
        ConeClassLikeType coneClassLikeType = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(leftType, c2);
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType leftPrimitiveOrNullableType = coneClassLikeType;
        ConeClassLikeType coneClassLikeType2 = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(rightType, c2);
        if (coneClassLikeType2 == null) {
            return null;
        }
        ConeClassLikeType rightPrimitiveOrNullableType = coneClassLikeType2;
        ConeClassLikeType leastCommonType = PrimitiveComparisonKt.leastCommonPrimitiveNumericType(leftPrimitiveOrNullableType, rightPrimitiveOrNullableType);
        return new PrimitiveConeNumericComparisonInfo(leastCommonType, leftPrimitiveOrNullableType, rightPrimitiveOrNullableType);
    }

    private static final ConeClassLikeType leastCommonPrimitiveNumericType(ConeClassLikeType t1, ConeClassLikeType t2) {
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType pt1 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t1);
        ConeClassLikeType pt2 = PrimitiveComparisonKt.promoteIntegerTypeToIntIfRequired(t2);
        if (PrimitivesKt.isDouble(pt1) || PrimitivesKt.isDouble(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getDouble();
        } else if (PrimitivesKt.isFloat(pt1) || PrimitivesKt.isFloat(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getFloat();
        } else if (PrimitivesKt.isLong(pt1) || PrimitivesKt.isLong(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getLong();
        } else if (PrimitivesKt.isInt(pt1) || PrimitivesKt.isInt(pt2)) {
            coneClassLikeType = StandardTypes.INSTANCE.getInt();
        } else {
            throw new IllegalStateException(("Unexpected types: t1=" + t1 + ", t2=" + t2).toString());
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType promoteIntegerTypeToIntIfRequired(ConeClassLikeType $this$promoteIntegerTypeToIntIfRequired) {
        ConeClassLikeType coneClassLikeType;
        ClassId classId = $this$promoteIntegerTypeToIntIfRequired.getLookupTag().getClassId();
        if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getByte()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getShort())) {
            coneClassLikeType = StandardTypes.INSTANCE.getInt();
        } else if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getLong()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getInt()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getFloat()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getDouble()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getChar())) {
            coneClassLikeType = $this$promoteIntegerTypeToIntIfRequired;
        } else {
            throw new IllegalStateException(("Primitive number type expected: " + $this$promoteIntegerTypeToIntIfRequired).toString());
        }
        return coneClassLikeType;
    }

    private static final ConeClassLikeType getPrimitiveTypeOrSupertype(ConeKotlinType $this$getPrimitiveTypeOrSupertype, Fir2IrComponents c2) {
        ConeClassLikeType coneClassLikeType;
        block3: {
            if ($this$getPrimitiveTypeOrSupertype instanceof ConeTypeParameterType) {
                for (FirTypeRef it : (Iterable)((FirTypeParameter)((ConeTypeParameterType)$this$getPrimitiveTypeOrSupertype).getLookupTag().getTypeParameterSymbol().getFir()).getBounds()) {
                    boolean bl2 = false;
                    ConeClassLikeType coneClassLikeType2 = PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(FirTypeUtilsKt.getConeType(it), c2);
                    if (coneClassLikeType2 == null) continue;
                    coneClassLikeType = coneClassLikeType2;
                    break block3;
                }
                coneClassLikeType = null;
            } else {
                coneClassLikeType = $this$getPrimitiveTypeOrSupertype instanceof ConeClassLikeType && PrimitivesKt.isPrimitiveNumberType((ConeClassLikeType)$this$getPrimitiveTypeOrSupertype) ? (ConeClassLikeType)$this$getPrimitiveTypeOrSupertype : ($this$getPrimitiveTypeOrSupertype instanceof ConeFlexibleType ? PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(((ConeFlexibleType)$this$getPrimitiveTypeOrSupertype).getLowerBound(), c2) : ($this$getPrimitiveTypeOrSupertype instanceof ConeCapturedType ? PrimitiveComparisonKt.getPrimitiveTypeOrSupertype(Fir2IrTypeConverterKt.approximateForIrOrSelf($this$getPrimitiveTypeOrSupertype, c2), c2) : null));
            }
        }
        return coneClassLikeType;
    }
}

