/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionOverrideFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002\u0018\u0019B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0002\u0082\u0001\u0002\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "isBuiltinFunctionalTypeOrSubtype", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isSuspendFunctionTypeOrSubtype", "findFakeMethodOverridingExternalWithOptionalParams", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n827#2:108\n855#2,2:109\n1617#2,9:111\n1869#2:120\n1870#2:122\n1626#2:123\n1761#2,3:124\n1761#2,3:127\n808#2,11:131\n774#2:142\n865#2,2:143\n295#2,2:145\n1#3:121\n1#3:130\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker\n*L\n55#1:108\n55#1:109,2\n56#1:111,9\n56#1:120\n56#1:122\n56#1:123\n58#1:124,3\n76#1:127,3\n96#1:131,11\n97#1:142\n97#1:143,2\n102#1:145,2\n56#1:121\n*E\n"})
public abstract class FirJsInheritanceClassChecker
extends FirDeclarationChecker<FirClass> {
    private FirJsInheritanceClassChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration2) {
        FirNamedFunctionSymbol fakeOverriddenMethod;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirSession session = context2.getSession();
        boolean isEffectivelyExternal = FirWebCommonHelpersKt.isEffectivelyExternal((FirBasedSymbol)declaration2.getSymbol(), session);
        if (isEffectivelyExternal && declaration2.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl2;
            block13: {
                Iterator $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable iterable = FirDeclarationUtilKt.getSuperConeTypes(declaration2);
                boolean $i$f$filterNot = false;
                void var9_10 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl3 = false;
                    if (ConeBuiltinTypeUtilsKt.isAnyOrNullableAny(it) || ConeBuiltinTypeUtilsKt.isThrowableOrNullableThrowable(it) || ConeBuiltinTypeUtilsKt.isEnum(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FirRegularClassSymbol it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl4 = false;
                    ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                    boolean bl5 = false;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(it, session);
                    if ((firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, session) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List superTypes2 = (List)destination$iv$iv;
                Iterable $this$any$iv = superTypes2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                        boolean bl7 = false;
                        if (!(!FirWebCommonHelpersKt.isEffectivelyExternal(it, session))) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE(), null, 8, null);
            }
        }
        if (!isEffectivelyExternal && (fakeOverriddenMethod = this.findFakeMethodOverridingExternalWithOptionalParams(declaration2, context2)) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getOVERRIDING_EXTERNAL_FUN_WITH_OPTIONAL_PARAMS_WITH_FAKE(), (Object)fakeOverriddenMethod, null, 16, null);
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowImplementingFunctionInterface)) {
            boolean bl8;
            block14: {
                Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes(declaration2);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl8 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl9 = false;
                        if (!(this.isBuiltinFunctionalTypeOrSubtype(it, session) && !this.isSuspendFunctionTypeOrSubtype(it, session))) continue;
                        bl8 = true;
                        break block14;
                    }
                    bl8 = false;
                }
            }
            if (bl8) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getIMPLEMENTING_FUNCTION_INTERFACE(), null, 8, null);
            }
        }
    }

    private final boolean isBuiltinFunctionalTypeOrSubtype(ConeClassLikeType $this$isBuiltinFunctionalTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u244 = TypeComponentsKt.getTypeContext(session);
        boolean bl2 = false;
        return $this$isBuiltinFunctionalTypeOrSubtype_u24lambda_u244.isBuiltinFunctionTypeOrSubtype($this$isBuiltinFunctionalTypeOrSubtype);
    }

    private final boolean isSuspendFunctionTypeOrSubtype(ConeClassLikeType $this$isSuspendFunctionTypeOrSubtype, FirSession session) {
        ConeInferenceContext $this$isSuspendFunctionTypeOrSubtype_u24lambda_u246 = TypeComponentsKt.getTypeContext(session);
        boolean bl2 = false;
        return $this$isSuspendFunctionTypeOrSubtype_u24lambda_u246.isTypeOrSubtypeOf($this$isSuspendFunctionTypeOrSubtype, (Function1<? super ConeKotlinType, Boolean>)((Function1)arg_0 -> FirJsInheritanceClassChecker.isSuspendFunctionTypeOrSubtype$lambda$6$lambda$5(session, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final FirNamedFunctionSymbol findFakeMethodOverridingExternalWithOptionalParams(FirClass $this$findFakeMethodOverridingExternalWithOptionalParams, CheckerContext context2) {
        Object v0;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            FirTypeScope scope = FirHelpersKt.unsubstitutedScope($this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol(), context2);
            Iterable iterable = FirContainingNamesAwareScopeKt.collectAllFunctions(scope);
            boolean $i$f$filterIsInstance = false;
            Iterator iterator2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirIntersectionOverrideFunctionSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv$iv;
                boolean bl2 = false;
                FirClassLikeSymbol<?> container = FirHelpersKt.getContainingClassSymbol(it);
                if (!(Intrinsics.areEqual(container, $this$findFakeMethodOverridingExternalWithOptionalParams.getSymbol()) && !it.getIntersections().isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List members = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = members;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirIntersectionOverrideFunctionSymbol it = (FirIntersectionOverrideFunctionSymbol)element$iv;
                boolean bl3 = false;
                if (!FirJsHelpersKt.isOverridingExternalWithOptionalParams(it, context2)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    private static final boolean isSuspendFunctionTypeOrSubtype$lambda$6$lambda$5(FirSession $session, ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FunctionalTypeUtilsKt.isSuspendOrKSuspendFunctionType(it, $session);
    }

    public /* synthetic */ FirJsInheritanceClassChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers.js"})
    @SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,107:1\n34#2:108\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$ForExpectClass\n*L\n43#1:108\n*E\n"})
    public static final class ForExpectClass
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers.js"})
    @SourceDebugExtension(value={"SMAP\nFirJsInheritanceClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,107:1\n34#2:108\n*S KotlinDebug\n*F\n+ 1 FirJsInheritanceClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsInheritanceClassChecker$Regular\n*L\n35#1:108\n*E\n"})
    public static final class Regular
    extends FirJsInheritanceClassChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration2);
        }
    }
}

