/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PlatformClassMappedToKotlinImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nPlatformClassMappedToKotlinImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformClassMappedToKotlinImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/PlatformClassMappedToKotlinImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1869#2,2:38\n*S KotlinDebug\n*F\n+ 1 PlatformClassMappedToKotlinImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/PlatformClassMappedToKotlinImportsChecker\n*L\n22#1:38,2\n*E\n"})
public final class PlatformClassMappedToKotlinImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final PlatformClassMappedToKotlinImportsChecker INSTANCE = new PlatformClassMappedToKotlinImportsChecker();

    private PlatformClassMappedToKotlinImportsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFile declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Iterable $this$forEach$iv = declaration2.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object classId;
            FqName importedFqName;
            FirImport firImport;
            block8: {
                block7: {
                    firImport = (FirImport)element$iv;
                    boolean bl2 = false;
                    if (firImport.getImportedFqName() == null) {
                        return;
                    }
                    if (importedFqName.isRoot()) break block7;
                    String string = importedFqName.shortName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    if (!(((CharSequence)string).length() == 0)) break block8;
                }
                return;
            }
            Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
            if (object == null || (object = ((FirResolvedImport)object).getResolvedParentClassId()) == null) {
                object = ClassId.Companion.topLevel(importedFqName);
            }
            if (!Intrinsics.areEqual((Object)((ClassId)(classId = object)).asSingleFqName(), (Object)importedFqName)) {
                return;
            }
            ClassId kotlinClass = FirPlatformClassMapperKt.getPlatformClassMapper(context2.getSession()).getCorrespondingKotlinClass((ClassId)classId);
            if (kotlinClass == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getPLATFORM_CLASS_MAPPED_TO_KOTLIN(), classId, null, 16, null);
        }
    }
}

