/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.experimental;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.experimental.CanBeReplacedWithOperatorAssignmentCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSuperReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\bH\u0002J\u0014\u0010\u0016\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/experimental/CanBeReplacedWithOperatorAssignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;)V", "isPropertyAccessWithNoReceiver", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Z", "canBeReplaced", "callee", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "isSamePrecedenceAs", "otherOperator", "Lorg/jetbrains/kotlin/name/Name;", "checkers"})
@SourceDebugExtension(value={"SMAP\nCanBeReplacedWithOperatorAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeReplacedWithOperatorAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/experimental/CanBeReplacedWithOperatorAssignmentChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,95:1\n46#2:96\n*S KotlinDebug\n*F\n+ 1 CanBeReplacedWithOperatorAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/experimental/CanBeReplacedWithOperatorAssignmentChecker\n*L\n79#1:96\n*E\n"})
public final class CanBeReplacedWithOperatorAssignmentChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final CanBeReplacedWithOperatorAssignmentChecker INSTANCE = new CanBeReplacedWithOperatorAssignmentChecker();

    private CanBeReplacedWithOperatorAssignmentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirVariableAssignment expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirReference lValue = ReferenceUtilsKt.getCalleeReference(expression2);
        if (!(lValue instanceof FirResolvedNamedReference)) {
            return;
        }
        KtSourceElement ktSourceElement = expression2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        if (!this.isPropertyAccessWithNoReceiver(expression2.getLValue())) {
            return;
        }
        FirExpression firExpression = expression2.getRValue();
        FirFunctionCall firFunctionCall = firExpression instanceof FirFunctionCall ? (FirFunctionCall)firExpression : null;
        if (firFunctionCall == null) {
            return;
        }
        FirFunctionCall rValue = firFunctionCall;
        KtSourceElement ktSourceElement2 = rValue.getSource();
        if ((ktSourceElement2 != null ? ktSourceElement2.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Object object = rValue.getExplicitReceiver();
        if (!(object != null && (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) != null && (object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)object, context2.getSession(), null, 2, null)) != null ? ConeBuiltinTypeUtilsKt.isPrimitive((ConeKotlinType)object) : false)) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(rValue);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> rValueResolvedSymbol = firCallableSymbol;
        ConeClassLikeType coneClassLikeType = ClassMembersKt.dispatchReceiverClassTypeOrNull(rValueResolvedSymbol);
        if (!(coneClassLikeType != null ? ConeBuiltinTypeUtilsKt.isPrimitive(coneClassLikeType) : false)) {
            return;
        }
        if (this.canBeReplaced(lValue, rValue, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCAN_BE_REPLACED_WITH_OPERATOR_ASSIGNMENT(), null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPropertyAccessWithNoReceiver(FirExpression $this$isPropertyAccessWithNoReceiver) {
        if (!($this$isPropertyAccessWithNoReceiver instanceof FirPropertyAccessExpression)) return false;
        FirExpression it = ((FirPropertyAccessExpression)$this$isPropertyAccessWithNoReceiver).getExplicitReceiver();
        boolean bl2 = false;
        if (it == null) return true;
        if (!(it instanceof FirSuperReceiverExpression)) return false;
        return true;
    }

    private final boolean canBeReplaced(FirReference callee, FirFunctionCall expression2, CheckerContext context2) {
        Name operatorName = expression2.getCalleeReference().getName();
        FirExpression lefter = expression2.getExplicitReceiver();
        if (!OperatorNameConventions.BINARY_OPERATION_NAMES.contains(operatorName)) {
            return false;
        }
        FirPureAbstractElement firPureAbstractElement = lefter instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)lefter : null;
        if (Intrinsics.areEqual(firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? FirReferenceUtilsKt.getSymbol((FirReference)firPureAbstractElement) : null, FirReferenceUtilsKt.getSymbol(callee))) {
            return true;
        }
        FirCall $this$arguments$iv = expression2;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return false;
        }
        FirExpression righter = firExpression;
        boolean isCommutative = Intrinsics.areEqual((Object)operatorName, (Object)OperatorNameConventions.PLUS) || Intrinsics.areEqual((Object)operatorName, (Object)OperatorNameConventions.TIMES);
        return isCommutative && righter instanceof FirQualifiedAccessExpression && Intrinsics.areEqual(FirReferenceUtilsKt.getSymbol(((FirQualifiedAccessExpression)righter).getCalleeReference()), FirReferenceUtilsKt.getSymbol(callee)) ? true : (lefter instanceof FirFunctionCall && this.isSamePrecedenceAs((FirFunctionCall)lefter, operatorName) ? this.canBeReplaced(callee, (FirFunctionCall)lefter, context2) : false);
    }

    private final boolean isSamePrecedenceAs(FirFunctionCall $this$isSamePrecedenceAs, Name otherOperator) {
        KotlinExpressionParsing.Precedence precedence = CanBeReplacedWithOperatorAssignmentCheckerKt.getPRECEDENCE_MAP().get($this$isSamePrecedenceAs.getCalleeReference().getName());
        KotlinExpressionParsing.Precedence precedence2 = CanBeReplacedWithOperatorAssignmentCheckerKt.getPRECEDENCE_MAP().get(otherOperator);
        return Intrinsics.areEqual((Object)(precedence != null ? Integer.valueOf(precedence.ordinal()) : null), (Object)(precedence2 != null ? Integer.valueOf(precedence2.ordinal()) : null));
    }
}

