/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.InsnSequence;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.fixStack.AnalyzeTryCatchBlocksKt;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0010H\u0002J\u0010\u0010+\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0010H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0010H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0010H\u0002J\u0006\u00100\u001a\u00020\u0017J\u0006\u00101\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR9\u0010\u001d\u001a*\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001f0\u001ej\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001f` \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R-\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u001ej\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010` \u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u001e\u0010&\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "breakContinueGotoNodes", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "Lkotlin/collections/LinkedHashSet;", "getBreakContinueGotoNodes", "()Ljava/util/LinkedHashSet;", "fakeAlwaysTrueIfeqMarkers", "Ljava/util/ArrayList;", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/ArrayList;", "getFakeAlwaysTrueIfeqMarkers", "()Ljava/util/ArrayList;", "fakeAlwaysFalseIfeqMarkers", "getFakeAlwaysFalseIfeqMarkers", "isThereAnyTryCatch", "", "()Z", "saveStackMarkerForRestoreMarker", "", "getSaveStackMarkerForRestoreMarker", "()Ljava/util/Map;", "restoreStackMarkersForSaveMarker", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getRestoreStackMarkersForSaveMarker", "()Ljava/util/HashMap;", "openingInlineMethodMarker", "getOpeningInlineMethodMarker", "value", "consistentInlineMarkers", "getConsistentInlineMarkers", "visitFixStackBeforeJump", "", "insnNode", "visitFakeAlwaysTrueIfeq", "visitFakeAlwaysFalseIfeq", "indexOf", "", "node", "hasAnyMarkers", "isAnalysisRequired", "backend"})
@SourceDebugExtension(value={"SMAP\nFixStackContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixStackContext.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n384#2,7:107\n1321#3:114\n1322#3:116\n1#4:115\n*S KotlinDebug\n*F\n+ 1 FixStackContext.kt\norg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext\n*L\n46#1:107,7\n51#1:114\n51#1:116\n*E\n"})
public final class FixStackContext {
    @NotNull
    private final MethodNode methodNode;
    @NotNull
    private final LinkedHashSet<JumpInsnNode> breakContinueGotoNodes;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysTrueIfeqMarkers;
    @NotNull
    private final ArrayList<AbstractInsnNode> fakeAlwaysFalseIfeqMarkers;
    private final boolean isThereAnyTryCatch;
    @NotNull
    private final Map<AbstractInsnNode, AbstractInsnNode> saveStackMarkerForRestoreMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, List<AbstractInsnNode>> restoreStackMarkersForSaveMarker;
    @NotNull
    private final HashMap<AbstractInsnNode, AbstractInsnNode> openingInlineMethodMarker;
    private boolean consistentInlineMarkers;

    public FixStackContext(@NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        this.methodNode = methodNode;
        this.breakContinueGotoNodes = new LinkedHashSet();
        this.fakeAlwaysTrueIfeqMarkers = new ArrayList();
        this.fakeAlwaysFalseIfeqMarkers = new ArrayList();
        this.saveStackMarkerForRestoreMarker = AnalyzeTryCatchBlocksKt.insertTryCatchBlocksMarkers(this.methodNode);
        this.restoreStackMarkersForSaveMarker = new HashMap();
        this.openingInlineMethodMarker = new HashMap();
        this.consistentInlineMarkers = true;
        this.isThereAnyTryCatch = !this.saveStackMarkerForRestoreMarker.isEmpty();
        for (Map.Entry<AbstractInsnNode, AbstractInsnNode> entry : this.saveStackMarkerForRestoreMarker.entrySet()) {
            Object object;
            AbstractInsnNode restore = entry.getKey();
            AbstractInsnNode save = entry.getValue();
            Map $this$getOrPut$iv = this.restoreStackMarkersForSaveMarker;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(save);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new SmartList();
                $this$getOrPut$iv.put(save, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(restore);
        }
        Stack<AbstractInsnNode> inlineMarkersStack = new Stack<AbstractInsnNode>();
        InsnList insnList = this.methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
        Sequence $this$forEach$iv = new InsnSequence(insnList);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl3;
            AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
            boolean bl4 = false;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(insnNode);
            if (pseudoInsn == PseudoInsn.FIX_STACK_BEFORE_JUMP) {
                this.visitFixStackBeforeJump(insnNode);
                continue;
            }
            if (pseudoInsn == PseudoInsn.FAKE_ALWAYS_TRUE_IFEQ) {
                this.visitFakeAlwaysTrueIfeq(insnNode);
                continue;
            }
            if (pseudoInsn == PseudoInsn.FAKE_ALWAYS_FALSE_IFEQ) {
                this.visitFakeAlwaysFalseIfeq(insnNode);
                continue;
            }
            if (InlineCodegenUtilsKt.isBeforeInlineMarker(insnNode)) {
                inlineMarkersStack.push(insnNode);
                continue;
            }
            if (!InlineCodegenUtilsKt.isAfterInlineMarker(insnNode)) continue;
            boolean bl5 = bl3 = !((Collection)inlineMarkersStack).isEmpty();
            if (_Assertions.ENABLED && !bl3) {
                boolean bl6 = false;
                String string = "Mismatching after inline method marker at " + this.indexOf(insnNode);
                throw new AssertionError((Object)string);
            }
            ((Map)this.openingInlineMethodMarker).put(insnNode, inlineMarkersStack.pop());
        }
        if (!((Collection)inlineMarkersStack).isEmpty()) {
            this.consistentInlineMarkers = false;
        }
    }

    @NotNull
    public final MethodNode getMethodNode() {
        return this.methodNode;
    }

    @NotNull
    public final LinkedHashSet<JumpInsnNode> getBreakContinueGotoNodes() {
        return this.breakContinueGotoNodes;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysTrueIfeqMarkers() {
        return this.fakeAlwaysTrueIfeqMarkers;
    }

    @NotNull
    public final ArrayList<AbstractInsnNode> getFakeAlwaysFalseIfeqMarkers() {
        return this.fakeAlwaysFalseIfeqMarkers;
    }

    public final boolean isThereAnyTryCatch() {
        return this.isThereAnyTryCatch;
    }

    @NotNull
    public final Map<AbstractInsnNode, AbstractInsnNode> getSaveStackMarkerForRestoreMarker() {
        return this.saveStackMarkerForRestoreMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, List<AbstractInsnNode>> getRestoreStackMarkersForSaveMarker() {
        return this.restoreStackMarkersForSaveMarker;
    }

    @NotNull
    public final HashMap<AbstractInsnNode, AbstractInsnNode> getOpeningInlineMethodMarker() {
        return this.openingInlineMethodMarker;
    }

    public final boolean getConsistentInlineMarkers() {
        return this.consistentInlineMarkers;
    }

    private final void visitFixStackBeforeJump(AbstractInsnNode insnNode) {
        boolean bl2;
        AbstractInsnNode next = insnNode.getNext();
        boolean bl3 = bl2 = next.getOpcode() == 167;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = this.indexOf(insnNode) + ": should be followed by GOTO";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)next, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        this.breakContinueGotoNodes.add((JumpInsnNode)next);
    }

    private final void visitFakeAlwaysTrueIfeq(AbstractInsnNode insnNode) {
        boolean bl2;
        boolean bl3 = bl2 = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw new AssertionError((Object)string);
        }
        this.fakeAlwaysTrueIfeqMarkers.add(insnNode);
    }

    private final void visitFakeAlwaysFalseIfeq(AbstractInsnNode insnNode) {
        boolean bl2;
        boolean bl3 = bl2 = insnNode.getNext().getOpcode() == 153;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = this.indexOf(insnNode) + ": should be followed by IFEQ";
            throw new AssertionError((Object)string);
        }
        this.fakeAlwaysFalseIfeqMarkers.add(insnNode);
    }

    private final int indexOf(AbstractInsnNode node) {
        return this.methodNode.instructions.indexOf(node);
    }

    public final boolean hasAnyMarkers() {
        return !((Collection)this.breakContinueGotoNodes).isEmpty() || !((Collection)this.fakeAlwaysTrueIfeqMarkers).isEmpty() || !((Collection)this.fakeAlwaysFalseIfeqMarkers).isEmpty() || this.isThereAnyTryCatch || !((Map)this.openingInlineMethodMarker).isEmpty();
    }

    public final boolean isAnalysisRequired() {
        return !((Collection)this.breakContinueGotoNodes).isEmpty() || this.isThereAnyTryCatch || !((Map)this.openingInlineMethodMarker).isEmpty();
    }
}

