/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;

@PhaseDescription(name="ConstEvaluationLowering")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ConstEvaluationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "suppressErrors", "", "configuration", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;ZLorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyIntrinsicConst;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ir.backend.common"})
public final class ConstEvaluationLowering
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;
    private final boolean suppressErrors;
    @NotNull
    private final IrInterpreter interpreter;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final EvaluationMode.OnlyIntrinsicConst mode;

    public ConstEvaluationLowering(@NotNull CommonBackendContext context2, boolean suppressErrors, @NotNull IrInterpreterConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.context = context2;
        this.suppressErrors = suppressErrors;
        this.interpreter = new IrInterpreter(new IrInterpreterEnvironment(this.context.getIrBuiltIns(), configuration2), (Map<IdSignature, ? extends IrBody>)MapsKt.emptyMap());
        this.evaluatedConstTracker = this.context.getConfiguration().get(CommonConfigurationKeys.EVALUATED_CONST_TRACKER);
        this.inlineConstTracker = this.context.getConfiguration().get(CommonConfigurationKeys.INLINE_CONST_TRACKER);
        this.mode = new EvaluationMode.OnlyIntrinsicConst(JsPlatformKt.isJs(configuration2.getPlatform()) || WasmPlatformKt.isWasm(configuration2.getPlatform()));
    }

    public /* synthetic */ ConstEvaluationLowering(CommonBackendContext commonBackendContext, boolean bl2, IrInterpreterConfiguration irInterpreterConfiguration, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl2 = commonBackendContext.getConfiguration().getBoolean(CommonConfigurationKeys.IGNORE_CONST_OPTIMIZATION_ERRORS);
        }
        if ((n2 & 4) != 0) {
            irInterpreterConfiguration = new IrInterpreterConfiguration(null, 0, 0, false, true, false, 47, null);
        }
        this(commonBackendContext, bl2, irInterpreterConfiguration);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrConstTransformerKt.runConstOptimizations(irFile, this.interpreter, this.mode, this.evaluatedConstTracker, this.inlineConstTracker, this.suppressErrors);
    }
}

