/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.ActualizerSymbolRemapper;
import org.jetbrains.kotlin.backend.common.actualizer.ActualizerVisitor;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollector;
import org.jetbrains.kotlin.backend.common.actualizer.FunctionDefaultParametersActualizer;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizedResult;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMap;
import org.jetbrains.kotlin.backend.common.actualizer.IrExtraActualDeclarationExtractor;
import org.jetbrains.kotlin.backend.common.actualizer.SpecialFakeOverrideSymbolsActualizedByFieldsTransformer;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualCheckers;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!J$\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010$\u001a\u00020!H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020&2\u0006\u0010$\u001a\u00020!H\u0002J\u001e\u0010*\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/IrActualizer;", "", "ktDiagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "mainFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependentFragments", "", "extraActualClassExtractors", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExtraActualDeclarationExtractor;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;Ljava/util/List;Ljava/util/List;)V", "getKtDiagnosticReporter", "()Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "getTypeSystemContext", "()Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "getMainFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getDependentFragments", "()Ljava/util/List;", "collector", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualCollector;", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "getClassActualizationInfo", "()Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "actualizeClassifiers", "", "actualizeCallablesAndMergeModules", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMap;", "runChecksAndFinalize", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrActualizedResult;", "expectActualMap", "removeExpectDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldRemoveExpectDeclaration", "", "irDeclaration", "mergeIrFragments", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nIrActualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1869#2,2:140\n1869#2,2:142\n1869#2,2:144\n1374#2:146\n1460#2,5:147\n*S KotlinDebug\n*F\n+ 1 IrActualizer.kt\norg/jetbrains/kotlin/backend/common/actualizer/IrActualizer\n*L\n63#1:140,2\n76#1:142,2\n82#1:144,2\n133#1:146\n133#1:147,5\n*E\n"})
public final class IrActualizer {
    @NotNull
    private final IrDiagnosticReporter ktDiagnosticReporter;
    @NotNull
    private final IrTypeSystemContext typeSystemContext;
    @NotNull
    private final IrModuleFragment mainFragment;
    @NotNull
    private final List<IrModuleFragment> dependentFragments;
    @NotNull
    private final ExpectActualCollector collector;
    @NotNull
    private final ClassActualizationInfo classActualizationInfo;

    public IrActualizer(@NotNull IrDiagnosticReporter ktDiagnosticReporter, @NotNull IrTypeSystemContext typeSystemContext2, @Nullable ExpectActualTracker expectActualTracker, @NotNull IrModuleFragment mainFragment, @NotNull List<? extends IrModuleFragment> dependentFragments, @NotNull List<? extends IrExtraActualDeclarationExtractor> extraActualClassExtractors) {
        Intrinsics.checkNotNullParameter((Object)ktDiagnosticReporter, (String)"ktDiagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)mainFragment, (String)"mainFragment");
        Intrinsics.checkNotNullParameter(dependentFragments, (String)"dependentFragments");
        Intrinsics.checkNotNullParameter(extraActualClassExtractors, (String)"extraActualClassExtractors");
        this.ktDiagnosticReporter = ktDiagnosticReporter;
        this.typeSystemContext = typeSystemContext2;
        this.mainFragment = mainFragment;
        this.dependentFragments = dependentFragments;
        this.collector = new ExpectActualCollector(this.mainFragment, this.dependentFragments, this.typeSystemContext, this.ktDiagnosticReporter, expectActualTracker, extraActualClassExtractors);
        this.classActualizationInfo = this.collector.collectClassActualizationInfo();
    }

    public /* synthetic */ IrActualizer(IrDiagnosticReporter irDiagnosticReporter, IrTypeSystemContext irTypeSystemContext, ExpectActualTracker expectActualTracker, IrModuleFragment irModuleFragment, List list, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(irDiagnosticReporter, irTypeSystemContext, expectActualTracker, irModuleFragment, list, list2);
    }

    @NotNull
    public final IrDiagnosticReporter getKtDiagnosticReporter() {
        return this.ktDiagnosticReporter;
    }

    @NotNull
    public final IrTypeSystemContext getTypeSystemContext() {
        return this.typeSystemContext;
    }

    @NotNull
    public final IrModuleFragment getMainFragment() {
        return this.mainFragment;
    }

    @NotNull
    public final List<IrModuleFragment> getDependentFragments() {
        return this.dependentFragments;
    }

    @NotNull
    public final ClassActualizationInfo getClassActualizationInfo() {
        return this.classActualizationInfo;
    }

    public final void actualizeClassifiers() {
        SymbolRemapper.Empty classSymbolRemapper2 = new SymbolRemapper.Empty(this){
            final /* synthetic */ IrActualizer this$0;
            {
                this.this$0 = $receiver;
            }

            public IrClassSymbol getReferencedClass(IrClassSymbol symbol) {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                if (!((IrClass)symbol.getOwner()).isExpect()) {
                    return symbol;
                }
                if (IrActualizerUtilsKt.containsOptionalExpectation(symbol.getOwner())) {
                    return symbol;
                }
                ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail((IrClass)symbol.getOwner());
                IrBindableSymbol<TypeAliasDescriptor, IrTypeAlias> irBindableSymbol = this.this$0.getClassActualizationInfo().getActualTypeAliases().get(classId);
                if (irBindableSymbol != null) {
                    IrTypeAliasSymbol it = irBindableSymbol;
                    boolean bl2 = false;
                    return IrTypesKt.getClassOrFail(((IrTypeAlias)it.getOwner()).getExpandedType());
                }
                irBindableSymbol = this.this$0.getClassActualizationInfo().getActualClasses().get(classId);
                if (irBindableSymbol != null) {
                    IrBindableSymbol<TypeAliasDescriptor, IrTypeAlias> it = irBindableSymbol;
                    boolean bl3 = false;
                    return it;
                }
                return symbol;
            }
        };
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl2 = false;
            it.transform((IrTransformer)new ActualizerVisitor(classSymbolRemapper2), (Object)null);
        }
    }

    @NotNull
    public final IrExpectActualMap actualizeCallablesAndMergeModules() {
        IrExpectActualMap expectActualMap = this.collector.matchAllExpectDeclarations(this.classActualizationInfo);
        ActualizerSymbolRemapper symbolRemapper = new ActualizerSymbolRemapper(expectActualMap);
        new FunctionDefaultParametersActualizer(symbolRemapper, expectActualMap).actualize();
        ActualizerVisitor actualizerVisitor = new ActualizerVisitor(symbolRemapper);
        Iterable $this$forEach$iv = this.dependentFragments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl2 = false;
            it.transform((IrTransformer)actualizerVisitor, (Object)null);
        }
        if (!expectActualMap.getPropertyAccessorsActualizedByFields().isEmpty()) {
            SpecialFakeOverrideSymbolsActualizedByFieldsTransformer specialFakeOverrideSymbolsActualizedByFieldsTransformer = new SpecialFakeOverrideSymbolsActualizedByFieldsTransformer(expectActualMap.getPropertyAccessorsActualizedByFields());
            Iterable $this$forEach$iv2 = this.dependentFragments;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                IrModuleFragment it = (IrModuleFragment)element$iv;
                boolean bl3 = false;
                it.transform((IrTransformer)specialFakeOverrideSymbolsActualizedByFieldsTransformer, (Object)null);
            }
        }
        this.mergeIrFragments(this.mainFragment, this.dependentFragments);
        return expectActualMap;
    }

    @NotNull
    public final IrActualizedResult runChecksAndFinalize(@NotNull IrExpectActualMap expectActualMap) {
        Intrinsics.checkNotNullParameter((Object)expectActualMap, (String)"expectActualMap");
        List<IrDeclaration> removedExpectDeclarations = this.removeExpectDeclarations(this.dependentFragments, expectActualMap);
        new IrExpectActualCheckers(expectActualMap, this.classActualizationInfo, this.typeSystemContext, this.ktDiagnosticReporter).check();
        return new IrActualizedResult(removedExpectDeclarations, expectActualMap);
    }

    private final List<IrDeclaration> removeExpectDeclarations(List<? extends IrModuleFragment> dependentFragments, IrExpectActualMap expectActualMap) {
        List removedExpectDeclarations = new ArrayList();
        for (IrModuleFragment irModuleFragment : dependentFragments) {
            for (IrFile file : irModuleFragment.getFiles()) {
                file.getDeclarations().removeIf(arg_0 -> IrActualizer.removeExpectDeclarations$lambda$4(arg_0 -> IrActualizer.removeExpectDeclarations$lambda$3(this, expectActualMap, removedExpectDeclarations, arg_0), arg_0));
            }
        }
        return removedExpectDeclarations;
    }

    private final boolean shouldRemoveExpectDeclaration(IrDeclaration irDeclaration, IrExpectActualMap expectActualMap) {
        IrDeclaration irDeclaration2 = irDeclaration;
        return irDeclaration2 instanceof IrClass ? ((IrClass)irDeclaration).isExpect() && (!IrActualizerUtilsKt.containsOptionalExpectation(irDeclaration) || expectActualMap.getExpectToActual().containsKey(((IrClass)irDeclaration).getSymbol())) : (irDeclaration2 instanceof IrProperty ? ((IrProperty)irDeclaration).isExpect() : (irDeclaration2 instanceof IrFunction ? ((IrFunction)irDeclaration).isExpect() : false));
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeIrFragments(IrModuleFragment mainFragment, List<? extends IrModuleFragment> dependentFragments) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.reversed((Iterable)dependentFragments);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List newFiles = (List)destination$iv$iv;
        for (IrFile file : newFiles) {
            file.setModule(mainFragment);
        }
        mainFragment.getFiles().addAll(newFiles);
    }

    private static final boolean removeExpectDeclarations$lambda$3(IrActualizer this$0, IrExpectActualMap $expectActualMap, List $removedExpectDeclarations, IrDeclaration it) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.shouldRemoveExpectDeclaration(it, $expectActualMap)) {
            $removedExpectDeclarations.add(it);
            bl2 = true;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private static final boolean removeExpectDeclarations$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

