/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class MapBackedFMap
extends Int2ObjectOpenHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap2, int keyToExclude) {
        if (oldMap2 == null) {
            MapBackedFMap.$$$reportNull$$$0(0);
        }
        super(oldMap2.size());
        ObjectIterator iterator2 = oldMap2.int2ObjectEntrySet().fastIterator();
        while (iterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator2.next();
            int key = entry.getIntKey();
            if (key != keyToExclude) {
                this.put(key, entry.getValue());
            }
            assert (key >= 0) : key;
        }
        assert (this.size() > 8);
    }

    private MapBackedFMap(@NotNull MapBackedFMap oldMap2, int newKey, @NotNull Object newValue) {
        if (oldMap2 == null) {
            MapBackedFMap.$$$reportNull$$$0(1);
        }
        if (newValue == null) {
            MapBackedFMap.$$$reportNull$$$0(2);
        }
        super(oldMap2.size() + 1);
        this.putAll(oldMap2);
        this.put(newKey, newValue);
        assert (this.size() > 8);
    }

    MapBackedFMap(int @NotNull [] keys, int newKey, @NotNull @NotNull Object @NotNull [] values2, @NotNull Object newValue) {
        if (newValue == null) {
            MapBackedFMap.$$$reportNull$$$0(3);
        }
        if (keys == null) {
            MapBackedFMap.$$$reportNull$$$0(4);
        }
        if (values2 == null) {
            MapBackedFMap.$$$reportNull$$$0(5);
        }
        super(keys.length + 1);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            int key = keys[i2];
            this.put(key, values2[i2]);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value2) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            MapBackedFMap.$$$reportNull$$$0(7);
        }
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        return value2 == oldValue ? this : new MapBackedFMap(this, keyCode, value2);
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(8);
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(9);
            }
            return mapBackedFMap;
        }
        if (oldSize == 9) {
            int[] keys = this.keySet().toIntArray();
            int[] newKeys = ArrayUtil.remove(keys, ArrayUtil.indexOf(keys, keyCode));
            Arrays.sort(newKeys);
            Object[] newValues = new Object[newKeys.length];
            for (int i2 = 0; i2 < newKeys.length; ++i2) {
                Object value2 = this.get(newKeys[i2]);
                assert (value2 != null);
                newValues[i2] = value2;
            }
            return new ArrayBackedFMap(newKeys, newValues);
        }
        return new MapBackedFMap(this, keyCode);
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(10);
        }
        return this.get(key.hashCode());
    }

    @Override
    public Key<?> @NotNull [] getKeys() {
        Key<?>[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keySet().toIntArray());
        if (keyArray == null) {
            MapBackedFMap.$$$reportNull$$$0(11);
        }
        return keyArray;
    }

    @Override
    public int getValueIdentityHashCode() {
        int hash = 0;
        ObjectIterator iterator2 = this.int2ObjectEntrySet().fastIterator();
        while (iterator2.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator2.next();
            int key = entry.getIntKey();
            hash = (hash * 31 + key) * 31 + System.identityHashCode(entry.getValue());
        }
        return hash;
    }

    @Override
    public boolean equalsByReference(@NotNull KeyFMap other) {
        if (other == null) {
            MapBackedFMap.$$$reportNull$$$0(12);
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof MapBackedFMap) || other.size() != this.size()) {
            return false;
        }
        MapBackedFMap map = (MapBackedFMap)other;
        ObjectIterator iterator2 = this.int2ObjectEntrySet().fastIterator();
        while (iterator2.hasNext()) {
            Int2ObjectMap.Entry next = (Int2ObjectMap.Entry)iterator2.next();
            if (map.get(next.getIntKey()) == next.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        this.int2ObjectEntrySet().fastForEach(entry -> s2.append(s2.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(entry.getIntKey())).append(" -> ").append(entry.getValue()));
        return "[" + s2 + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsByReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

