/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManager
implements SavingRequestor {
    @NotNull
    public static FileDocumentManager getInstance() {
        FileDocumentManager fileDocumentManager = ApplicationManager.getApplication().getService(FileDocumentManager.class);
        if (fileDocumentManager == null) {
            FileDocumentManager.$$$reportNull$$$0(0);
        }
        return fileDocumentManager;
    }

    @RequiresReadLock
    @Nullable
    public abstract Document getDocument(@NotNull VirtualFile var1);

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @RequiresReadLock
    @Nullable
    public Document getDocument(@NotNull VirtualFile file, @NotNull Project preferredProject) {
        if (file == null) {
            FileDocumentManager.$$$reportNull$$$0(1);
        }
        if (preferredProject == null) {
            FileDocumentManager.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        try (AccessToken ignored = ProjectLocator.withPreferredProject(file, preferredProject);){
            Document document = this.getDocument(file);
            return document;
        }
    }

    @Nullable
    public abstract Document getCachedDocument(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull Document var1);

    public abstract void saveAllDocuments();

    public abstract void saveDocuments(@NotNull Predicate<? super Document> var1);

    public abstract void saveDocument(@NotNull Document var1);

    public abstract void saveDocumentAsIs(@NotNull Document var1);

    public abstract Document @NotNull [] getUnsavedDocuments();

    public boolean processUnsavedDocuments(Processor<? super Document> processor) {
        for (Document doc : this.getUnsavedDocuments()) {
            if (processor.process(doc)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDocumentUnsaved(@NotNull Document var1);

    public abstract boolean isFileModified(@NotNull VirtualFile var1);

    public abstract boolean isPartialPreviewOfALargeFile(@NotNull Document var1);

    public void reloadFromDisk(@NotNull Document document) {
        if (document == null) {
            FileDocumentManager.$$$reportNull$$$0(3);
        }
        VirtualFile file = Objects.requireNonNull(this.getFile(document));
        this.reloadFromDisk(document, ProjectLocator.getInstance().guessProjectForFile(file));
    }

    public abstract void reloadFromDisk(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public abstract String getLineSeparator(@Nullable VirtualFile var1, @Nullable Project var2);

    public abstract boolean requestWriting(@NotNull Document var1, @Nullable Project var2);

    @NotNull
    public WriteAccessStatus requestWritingStatus(@NotNull Document document, @Nullable Project project) {
        if (document == null) {
            FileDocumentManager.$$$reportNull$$$0(4);
        }
        WriteAccessStatus writeAccessStatus = this.requestWriting(document, project) ? WriteAccessStatus.WRITABLE : WriteAccessStatus.NON_WRITABLE;
        if (writeAccessStatus == null) {
            FileDocumentManager.$$$reportNull$$$0(5);
        }
        return writeAccessStatus;
    }

    public static boolean fileForDocumentCheckedOutSuccessfully(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            FileDocumentManager.$$$reportNull$$$0(6);
        }
        if (project == null) {
            FileDocumentManager.$$$reportNull$$$0(7);
        }
        return FileDocumentManager.getInstance().requestWriting(document, project);
    }

    public abstract void reloadFiles(VirtualFile ... var1);

    @ApiStatus.Internal
    public void reloadBinaryFiles() {
    }

    @ApiStatus.Internal
    @Nullable
    public FileViewProvider findCachedPsiInAnyProject(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManager.$$$reportNull$$$0(8);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredProject";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWritingStatus";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestWritingStatus";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileForDocumentCheckedOutSuccessfully";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiInAnyProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WriteAccessStatus {
        public static final WriteAccessStatus NON_WRITABLE = new WriteAccessStatus(false);
        public static final WriteAccessStatus WRITABLE = new WriteAccessStatus(true);
        private final boolean myWithWriteAccess;
        @NotNull
        private final @NlsContexts.HintText String myReadOnlyMessage;
        @Nullable
        private final HyperlinkListener myHyperlinkListener;

        private WriteAccessStatus(boolean withWriteAccess) {
            this.myWithWriteAccess = withWriteAccess;
            this.myReadOnlyMessage = withWriteAccess ? "" : CoreBundle.message("editing.read.only.file.hint", new Object[0]);
            this.myHyperlinkListener = null;
        }

        public WriteAccessStatus(@NotNull @NlsContexts.HintText String readOnlyMessage) {
            if (readOnlyMessage == null) {
                WriteAccessStatus.$$$reportNull$$$0(0);
            }
            this(readOnlyMessage, null);
        }

        public WriteAccessStatus(@NotNull @NlsContexts.HintText String readOnlyMessage, @Nullable HyperlinkListener hyperlinkListener) {
            if (readOnlyMessage == null) {
                WriteAccessStatus.$$$reportNull$$$0(1);
            }
            this.myWithWriteAccess = false;
            this.myReadOnlyMessage = readOnlyMessage;
            this.myHyperlinkListener = hyperlinkListener;
        }

        public boolean hasWriteAccess() {
            return this.myWithWriteAccess;
        }

        @NotNull
        @NlsContexts.HintText
        public String getReadOnlyMessage() {
            String string = this.myReadOnlyMessage;
            if (string == null) {
                WriteAccessStatus.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myHyperlinkListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/FileDocumentManager$WriteAccessStatus";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/FileDocumentManager$WriteAccessStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadOnlyMessage";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

