/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\b\u0000\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\n\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\u0006\b\u0000\u0012\u00020\b\u0012\u0006\b\u0001\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/model/FileRangePointer;", "T", "Lcom/intellij/model/Pointer;", "base", "Lcom/intellij/psi/SmartPsiFileRange;", "restoration", "Ljava/util/function/BiFunction;", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/psi/SmartPsiFileRange;Ljava/util/function/BiFunction;)V", "dereference", "()Ljava/lang/Object;", "intellij.platform.core"})
@ApiStatus.Internal
public final class FileRangePointer<T>
implements Pointer<T> {
    @NotNull
    private final SmartPsiFileRange base;
    @NotNull
    private final BiFunction<? super PsiFile, ? super TextRange, ? extends T> restoration;

    public FileRangePointer(@NotNull SmartPsiFileRange base, @NotNull BiFunction<? super PsiFile, ? super TextRange, ? extends T> restoration) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter(restoration, (String)"restoration");
        this.base = base;
        this.restoration = restoration;
    }

    @Override
    @Nullable
    public T dereference() {
        PsiFile psiFile = (PsiFile)this.base.getElement();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        Segment segment = this.base.getRange();
        if (segment == null) {
            return null;
        }
        Segment range = segment;
        TextRange textRange = TextRange.create(range);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return this.restoration.apply(file, textRange);
    }
}

