/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Lexer {
    private static final Logger LOG = Logger.getInstance(Lexer.class);
    private static final long LEXER_START_THRESHOLD = 500L;

    public abstract void start(@NotNull CharSequence var1, int var2, int var3, int var4);

    private void startMeasured(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            Lexer.$$$reportNull$$$0(0);
        }
        if (!LOG.isDebugEnabled()) {
            this.start(buffer, startOffset, endOffset, initialState);
            return;
        }
        long start = System.currentTimeMillis();
        this.start(buffer, startOffset, endOffset, initialState);
        long startDuration = System.currentTimeMillis() - start;
        if (startDuration > 500L) {
            LOG.debug("Starting lexer took: ", startDuration, "; at ", startOffset, " - ", endOffset, "; state: ", initialState, "; text: ", StringUtil.shortenTextWithEllipsis(buffer.toString(), 1024, 500));
        }
    }

    public final void start(@NotNull CharSequence buf, int start, int end) {
        if (buf == null) {
            Lexer.$$$reportNull$$$0(1);
        }
        this.startMeasured(buf, start, end, 0);
    }

    public final void start(@NotNull CharSequence buf) {
        if (buf == null) {
            Lexer.$$$reportNull$$$0(2);
        }
        this.startMeasured(buf, 0, buf.length(), 0);
    }

    @NotNull
    public CharSequence getTokenSequence() {
        CharSequence charSequence = this.getBufferSequence().subSequence(this.getTokenStart(), this.getTokenEnd());
        if (charSequence == null) {
            Lexer.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @NotNull
    public String getTokenText() {
        String string = this.getTokenSequence().toString();
        if (string == null) {
            Lexer.$$$reportNull$$$0(4);
        }
        return string;
    }

    public abstract int getState();

    @Nullable
    public abstract IElementType getTokenType();

    public abstract int getTokenStart();

    public abstract int getTokenEnd();

    public abstract void advance();

    @NotNull
    public abstract LexerPosition getCurrentPosition();

    public abstract void restore(@NotNull LexerPosition var1);

    @NotNull
    public abstract CharSequence getBufferSequence();

    public abstract int getBufferEnd();

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/Lexer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/Lexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startMeasured";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

