/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.DeclarationGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LocalClassGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "<init>", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "generateObjectLiteral", "Lorg/jetbrains/kotlin/ir/IrStatement;", "ktObjectLiteral", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "generateLocalClass", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ir.psi2ir"})
public final class LocalClassGenerator
extends StatementGeneratorExtension {
    public LocalClassGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkNotNullParameter((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }

    @NotNull
    public final IrStatement generateObjectLiteral(@NotNull KtObjectLiteralExpression ktObjectLiteral) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)ktObjectLiteral, (String)"ktObjectLiteral");
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(ktObjectLiteral);
        int endOffset = PsiUtilsKt.getEndOffset(ktObjectLiteral);
        IrType objectLiteralType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, ktObjectLiteral));
        IrBlockImpl irBlock = BuildersKt.IrBlockImpl(startOffset, endOffset, objectLiteralType, IrStatementOrigin.Companion.getOBJECT_LITERAL());
        DeclarationGenerator declarationGenerator = new DeclarationGenerator(this.getStatementGenerator().getContext());
        KtObjectDeclaration ktObjectDeclaration = ktObjectLiteral.getObjectDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"getObjectDeclaration(...)");
        IrClass irClass = declarationGenerator.generateClassOrObjectDeclaration(ktObjectDeclaration);
        irBlock.getStatements().add(irClass);
        ClassConstructorDescriptor classConstructorDescriptor = irClass.getDescriptor().getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            throw new AssertionError((Object)("Object literal should have a primary constructor: " + irClass.getDescriptor()));
        }
        ClassConstructorDescriptor objectConstructor = classConstructorDescriptor;
        boolean bl3 = bl2 = objectConstructor.getDispatchReceiverParameter() == null;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-LocalClassGenerator$generateObjectLiteral$42 = false;
            String $i$a$-assert-LocalClassGenerator$generateObjectLiteral$42 = "Object literal constructor should have no dispatch receiver parameter: " + objectConstructor;
            throw new AssertionError((Object)$i$a$-assert-LocalClassGenerator$generateObjectLiteral$42);
        }
        boolean bl4 = bl2 = objectConstructor.getExtensionReceiverParameter() == null;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-LocalClassGenerator$generateObjectLiteral$52 = false;
            String $i$a$-assert-LocalClassGenerator$generateObjectLiteral$52 = "Object literal constructor should have no extension receiver parameter: " + objectConstructor;
            throw new AssertionError((Object)$i$a$-assert-LocalClassGenerator$generateObjectLiteral$52);
        }
        boolean bl5 = bl2 = objectConstructor.getValueParameters().size() == 0;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string2 = "Object literal constructor should have no value parameters: " + objectConstructor;
            throw new AssertionError((Object)string2);
        }
        irBlock.getStatements().add(BuildersKt.fromSymbolDescriptor(IrConstructorCallImpl.Companion, startOffset, endOffset, objectLiteralType, this.getContext().getSymbolTable().getDescriptorExtension().referenceConstructor(objectConstructor), IrStatementOrigin.Companion.getOBJECT_LITERAL()));
        return irBlock;
    }

    @NotNull
    public final IrStatement generateLocalClass(@NotNull KtClassOrObject ktClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)ktClassOrObject, (String)"ktClassOrObject");
        return new DeclarationGenerator(this.getStatementGenerator().getContext()).generateClassOrObjectDeclaration(ktClassOrObject);
    }
}

