/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeCompatibilityHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.TypeInfo;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/ArgumentInfo;", "", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "userType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "originalType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getArgument", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getUserType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getOriginalType", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "smartCastType", "getSmartCastType", "smartCastType$delegate", "Lkotlin/Lazy;", "originalTypeInfo", "Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "getOriginalTypeInfo", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/TypeInfo;", "smartCastTypeInfo", "getSmartCastTypeInfo", "toString", "", "checkers"})
public final class ArgumentInfo {
    @NotNull
    private final FirExpression argument;
    @NotNull
    private final ConeKotlinType userType;
    @NotNull
    private final ConeKotlinType originalType;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy smartCastType$delegate;

    public ArgumentInfo(@NotNull FirExpression argument, @NotNull ConeKotlinType userType, @NotNull ConeKotlinType originalType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)userType, (String)"userType");
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.argument = argument;
        this.userType = userType;
        this.originalType = originalType;
        this.session = session;
        this.smartCastType$delegate = LazyKt.lazy(() -> ArgumentInfo.smartCastType_delegate$lambda$0(this));
    }

    @NotNull
    public final FirExpression getArgument() {
        return this.argument;
    }

    @NotNull
    public final ConeKotlinType getUserType() {
        return this.userType;
    }

    @NotNull
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ConeKotlinType getSmartCastType() {
        Lazy lazy = this.smartCastType$delegate;
        return (ConeKotlinType)lazy.getValue();
    }

    @NotNull
    public final TypeInfo getOriginalTypeInfo() {
        return FirTypeCompatibilityHelpersKt.toTypeInfo(this.originalType, this.session);
    }

    @NotNull
    public final TypeInfo getSmartCastTypeInfo() {
        return FirTypeCompatibilityHelpersKt.toTypeInfo(this.getSmartCastType(), this.session);
    }

    @NotNull
    public String toString() {
        KtSourceElement ktSourceElement = this.argument.getSource();
        return (ktSourceElement != null ? KtSourceElementKt.getText(ktSourceElement) : null) + " :: " + this.userType;
    }

    private static final ConeKotlinType smartCastType_delegate$lambda$0(ArgumentInfo this$0) {
        return TypeExpansionUtilsKt.fullyExpandedType$default(this$0.userType, this$0.session, null, 2, null);
    }
}

