/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.JdkZipResourceFile;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClassPath {
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";
    static final boolean recordLoadingInfo = Boolean.getBoolean("idea.record.classpath.info");
    static final boolean recordLoadingTime = recordLoadingInfo || Boolean.getBoolean("idea.record.classloading.stats");
    static final boolean logLoadingInfo = Boolean.getBoolean("idea.log.classpath.info");
    private static final boolean isNewClassLoadingEnabled = false;
    private static final Collection<Map.Entry<String, Path>> loadedClasses;
    private static final Measurer classLoading;
    private static final Measurer resourceLoading;
    private static final AtomicLong classDefineTotalTime;
    private Path[] files;
    private int searchOffset;
    @NotNull
    private final Function<Path, ResourceFile> resourceFileFactory;
    final boolean mimicJarUrlConnection;
    private final List<Loader> loaders;
    private volatile boolean allUrlsWereProcessed;
    private final AtomicInteger lastLoaderProcessed;
    private final ClasspathCache cache;
    private final boolean useCache;
    final boolean isClassPathIndexEnabled;
    @Nullable
    private final CachePoolImpl cachePool;
    @Nullable
    private final Predicate<? super Path> cachingCondition;

    public ClassPath(@NotNull Collection<Path> files2, @NotNull UrlClassLoader.Builder configuration2, @Nullable Function<Path, ResourceFile> resourceFileFactory, boolean mimicJarUrlConnection) {
        if (files2 == null) {
            ClassPath.$$$reportNull$$$0(0);
        }
        if (configuration2 == null) {
            ClassPath.$$$reportNull$$$0(1);
        }
        this.searchOffset = 0;
        this.loaders = new ArrayList<Loader>();
        this.lastLoaderProcessed = new AtomicInteger();
        this.cache = new ClasspathCache();
        this.useCache = configuration2.useCache;
        this.cachePool = configuration2.cachePool;
        this.cachingCondition = configuration2.cachingCondition;
        this.isClassPathIndexEnabled = configuration2.isClassPathIndexEnabled;
        this.mimicJarUrlConnection = mimicJarUrlConnection;
        this.files = files2.toArray(new Path[0]);
        this.resourceFileFactory = resourceFileFactory == null ? file2 -> new JdkZipResourceFile((Path)file2, configuration2.lockJars) : resourceFileFactory;
    }

    synchronized List<Path> getFiles() {
        return Arrays.asList(this.files);
    }

    synchronized void reset(Collection<Path> newClassPath) {
        this.reset();
        this.files = newClassPath.toArray(new Path[0]);
    }

    public synchronized void reset() {
        this.lastLoaderProcessed.set(0);
        this.allUrlsWereProcessed = false;
        this.loaders.clear();
        this.searchOffset = 0;
        this.cache.clearCache();
    }

    @NotNull
    public static Collection<Map.Entry<String, Path>> getLoadedClasses() {
        return new ArrayList<Map.Entry<String, Path>>(loadedClasses);
    }

    @NotNull
    public static Map<String, Long> getLoadingStats() {
        HashMap<String, Long> result2 = new HashMap<String, Long>(6);
        result2.put("classLoadingTime", classLoading.timeCounter.get());
        result2.put("classDefineTime", classDefineTotalTime.get());
        result2.put("classRequests", Long.valueOf(classLoading.requestCounter.get()));
        result2.put("resourceLoadingTime", resourceLoading.timeCounter.get());
        result2.put("resourceRequests", Long.valueOf(resourceLoading.requestCounter.get()));
        result2.put("identity", Long.valueOf(ClassPath.class.hashCode()));
        HashMap<String, Long> hashMap = result2;
        if (hashMap == null) {
            ClassPath.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    synchronized void addFile(@NotNull Path file2) {
        if (file2 == null) {
            ClassPath.$$$reportNull$$$0(3);
        }
        for (Path existingFile : this.files) {
            if (!existingFile.equals(file2)) continue;
            return;
        }
        Path[] result2 = Arrays.copyOf(this.files, this.files.length + 1);
        result2[result2.length - 1] = file2;
        this.files = result2;
        this.allUrlsWereProcessed = false;
    }

    public synchronized void addFiles(@NotNull Collection<Path> newList) {
        if (newList == null) {
            ClassPath.$$$reportNull$$$0(4);
        }
        if (newList.isEmpty()) {
            return;
        }
        if (newList.size() == 1) {
            this.addFile(newList instanceof List ? (Path)((List)newList).get(0) : newList.iterator().next());
            return;
        }
        LinkedHashSet<Path> result2 = new LinkedHashSet<Path>(this.files.length + newList.size());
        Collections.addAll(result2, this.files);
        result2.addAll(newList);
        if (result2.size() == this.files.length) {
            return;
        }
        this.files = result2.toArray(new Path[0]);
        this.allUrlsWereProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> findClass(String className, String fileName2, long packageNameHash, ClassDataConsumer classDataConsumer) throws IOException {
        long start = classLoading.startTiming();
        try {
            int i2;
            if (this.useCache) {
                boolean allUrlsWereProcessedBeforeAccessingCache = this.allUrlsWereProcessed;
                int lastLoaderProcessedBeforeAccessingCache = this.lastLoaderProcessed.get();
                Loader[] loaders = this.cache.getClassLoadersByPackageNameHash(packageNameHash);
                if (loaders != null) {
                    for (Loader loader : loaders) {
                        Class<?> result2 = ClassPath.findClassInLoader(fileName2, className, classDataConsumer, loader);
                        if (result2 == null) continue;
                        Class<?> clazz = result2;
                        return clazz;
                    }
                }
                if (allUrlsWereProcessedBeforeAccessingCache) {
                    Loader[] loaderArray = null;
                    return loaderArray;
                }
                i2 = lastLoaderProcessedBeforeAccessingCache;
            } else {
                i2 = 0;
            }
            Class<?> clazz = this.findClassWithoutCache(className, fileName2, i2, classDataConsumer);
            return clazz;
        }
        finally {
            classLoading.record(start, className);
        }
    }

    @Nullable
    private Class<?> findClassWithoutCache(String className, String fileName2, int initialLoaderIndex, ClassDataConsumer classDataConsumer) throws IOException {
        int loaderIndex = initialLoaderIndex;
        while (true) {
            Loader loader;
            Loader loader2 = loader = loaderIndex < this.lastLoaderProcessed.get() ? this.loaders.get(loaderIndex) : this.getLoaderSlowPath(loaderIndex);
            if (loader == null) {
                return null;
            }
            Class<?> result2 = ClassPath.findClassInLoader(fileName2, className, classDataConsumer, loader);
            if (result2 != null) {
                return result2;
            }
            ++loaderIndex;
        }
    }

    @Nullable
    private static Class<?> findClassInLoader(@NotNull String fileName2, @NotNull String className, @NotNull ClassDataConsumer classConsumer, @NotNull Loader loader) throws IOException {
        Class<?> result2;
        if (fileName2 == null) {
            ClassPath.$$$reportNull$$$0(5);
        }
        if (className == null) {
            ClassPath.$$$reportNull$$$0(6);
        }
        if (classConsumer == null) {
            ClassPath.$$$reportNull$$$0(7);
        }
        if (loader == null) {
            ClassPath.$$$reportNull$$$0(8);
        }
        if ((result2 = loader.findClass(fileName2, className, classConsumer)) == null) {
            return null;
        }
        if (loadedClasses != null) {
            loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(fileName2, loader.getPath()));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Resource findResource(@NotNull String resourceName) {
        if (resourceName == null) {
            ClassPath.$$$reportNull$$$0(9);
        }
        long start = resourceLoading.startTiming();
        try {
            Loader loader;
            int i2;
            if (this.useCache) {
                boolean allUrlsWereProcessedBeforeAccessingCache = this.allUrlsWereProcessed;
                int i3 = this.lastLoaderProcessed.get();
                Loader[] loaders = this.cache.getLoadersByName(resourceName);
                if (loaders != null) {
                    for (Loader loader2 : loaders) {
                        Resource resource = loader2.getResource(resourceName);
                        if (resource == null) continue;
                        if (loadedClasses != null) {
                            loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(resourceName, loader2.getPath()));
                        }
                        Resource resource2 = resource;
                        return resource2;
                    }
                }
                if (allUrlsWereProcessedBeforeAccessingCache) {
                    Resource resource = null;
                    return resource;
                }
            } else {
                i2 = 0;
            }
            while ((loader = this.getLoader(i2++)) != null) {
                Resource resource = loader.getResource(resourceName);
                if (resource == null) continue;
                if (loadedClasses != null) {
                    loadedClasses.add(new AbstractMap.SimpleImmutableEntry<String, Path>(resourceName, loader.getPath()));
                }
                Resource resource3 = resource;
                return resource3;
            }
        }
        finally {
            resourceLoading.record(start, resourceName);
        }
        return null;
    }

    @NotNull
    public Enumeration<URL> getResources(@NotNull String name2) {
        if (name2 == null) {
            ClassPath.$$$reportNull$$$0(10);
        }
        if (name2.endsWith("/")) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        if (this.useCache && this.allUrlsWereProcessed) {
            Loader[] loaders = this.cache.getLoadersByName(name2);
            return loaders == null || loaders.length == 0 ? Collections.emptyEnumeration() : new ResourceEnumeration(name2, loaders);
        }
        return new UncachedResourceEnumeration(name2, this);
    }

    void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer2) throws IOException {
        block6: {
            Loader loader;
            block5: {
                if (dir == null) {
                    ClassPath.$$$reportNull$$$0(11);
                }
                if (fileNameFilter == null) {
                    ClassPath.$$$reportNull$$$0(12);
                }
                if (consumer2 == null) {
                    ClassPath.$$$reportNull$$$0(13);
                }
                if (!this.useCache || !this.allUrlsWereProcessed) break block5;
                Loader[] loaders = this.cache.getLoadersByResourcePackageDir(dir);
                if (loaders == null) break block6;
                for (Loader loader2 : loaders) {
                    loader2.processResources(dir, fileNameFilter, consumer2);
                }
                break block6;
            }
            int index2 = 0;
            while ((loader = this.getLoader(index2++)) != null) {
                loader.processResources(dir, fileNameFilter, consumer2);
            }
        }
    }

    @Nullable
    private Loader getLoader(int loaderIndex) {
        return loaderIndex < this.lastLoaderProcessed.get() ? this.loaders.get(loaderIndex) : this.getLoaderSlowPath(loaderIndex);
    }

    @Nullable
    private synchronized Loader getLoaderSlowPath(int loaderIndex) {
        while (this.loaders.size() < loaderIndex + 1) {
            if (this.searchOffset == this.files.length) {
                if (this.useCache) {
                    this.allUrlsWereProcessed = true;
                }
                return null;
            }
            Path path = this.files[this.searchOffset++].toAbsolutePath();
            try {
                Loader loader = this.createLoader(path);
                if (loader == null) continue;
                if (this.useCache && this.searchOffset == this.files.length) {
                    this.allUrlsWereProcessed = true;
                }
                this.loaders.add(loader);
                this.lastLoaderProcessed.incrementAndGet();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return this.loaders.get(loaderIndex);
    }

    @NotNull
    public List<Path> getBaseUrls() {
        ArrayList<Path> result2 = new ArrayList<Path>();
        for (Loader loader : this.loaders) {
            result2.add(loader.getPath());
        }
        ArrayList<Path> arrayList = result2;
        if (arrayList == null) {
            ClassPath.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    private Loader createLoader(@NotNull Path file2) throws IOException {
        String filePath2;
        BasicFileAttributes fileAttributes;
        if (file2 == null) {
            ClassPath.$$$reportNull$$$0(15);
        }
        try {
            fileAttributes = Files.readAttributes(file2, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException ignore) {
            return null;
        }
        catch (RuntimeException e2) {
            throw new RuntimeException("Failed to read attributes of file from " + file2.getFileSystem(), e2);
        }
        if (fileAttributes.isDirectory()) {
            return this.useCache ? FileLoader.createCachingFileLoader(file2, this.cachePool, this.cachingCondition, this.isClassPathIndexEnabled, this.cache) : new FileLoader(file2);
        }
        if (!fileAttributes.isRegularFile()) {
            return null;
        }
        ResourceFile zipFile = this.resourceFileFactory.apply(file2);
        JarLoader loader = new JarLoader(file2, this, zipFile);
        if (this.useCache) {
            ClasspathCache.IndexRegistrar data;
            ClasspathCache.IndexRegistrar indexRegistrar = data = this.cachePool == null ? null : this.cachePool.loaderIndexCache.get(file2);
            if (data == null) {
                data = zipFile.buildClassPathCacheData();
                if (this.cachePool != null && this.cachingCondition != null && this.cachingCondition.test(file2)) {
                    this.cachePool.loaderIndexCache.put(file2, data);
                }
            }
            this.cache.applyLoaderData(data, loader);
        }
        if ((filePath2 = file2.toString()).startsWith(CLASSPATH_JAR_FILE_NAME_PREFIX, filePath2.lastIndexOf(File.separatorChar) + 1)) {
            this.addFromManifestClassPathIfNeeded(file2, zipFile, loader);
        }
        return loader;
    }

    private void addFromManifestClassPathIfNeeded(@NotNull Path file2, ResourceFile zipFile, JarLoader loader) {
        String[] referencedJars;
        if (file2 == null) {
            ClassPath.$$$reportNull$$$0(16);
        }
        if ((referencedJars = this.loadManifestClasspath(loader, zipFile)) != null) {
            long startReferenced = logLoadingInfo ? System.nanoTime() : 0L;
            ArrayList<Path> files2 = new ArrayList<Path>(referencedJars.length);
            for (String referencedJar : referencedJars) {
                try {
                    files2.add(Paths.get(UrlClassLoader.urlToFilePath(referencedJar), new String[0]));
                }
                catch (Exception e2) {
                    System.err.println("file: " + file2 + " / " + referencedJar + " " + e2);
                }
            }
            this.addFiles(files2);
            if (logLoadingInfo) {
                System.out.println("Loaded all " + referencedJars.length + " files " + (System.nanoTime() - startReferenced) / 1000000L + "ms");
            }
        }
    }

    private String @Nullable [] loadManifestClasspath(@NotNull JarLoader loader, @NotNull ResourceFile zipFile) {
        if (loader == null) {
            ClassPath.$$$reportNull$$$0(17);
        }
        if (zipFile == null) {
            ClassPath.$$$reportNull$$$0(18);
        }
        try {
            String[] urls;
            String classPath2;
            Map<JarLoader.Attribute, String> result2;
            Map<JarLoader.Attribute, String> map = result2 = this.useCache && this.cachePool != null ? this.cachePool.getManifestData(loader.getPath()) : null;
            if (result2 == null) {
                Attributes manifestAttributes = zipFile.loadManifestAttributes();
                Map<Object, Object> map2 = result2 = manifestAttributes == null ? Collections.emptyMap() : JarLoader.getAttributes(manifestAttributes);
                if (this.useCache && this.cachePool != null && this.cachingCondition != null && this.cachingCondition.test(loader.getPath())) {
                    this.cachePool.cacheManifestData(loader.getPath(), result2);
                }
            }
            if ((classPath2 = (String)result2.get((Object)JarLoader.Attribute.CLASS_PATH)) != null && (urls = classPath2.split(" ")).length > 0 && urls[0].startsWith("file:")) {
                return urls;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        classLoading = new Measurer();
        resourceLoading = new Measurer();
        classDefineTotalTime = new AtomicLong();
        ConcurrentLinkedQueue concurrentLinkedQueue = loadedClasses = recordLoadingInfo ? new ConcurrentLinkedQueue() : null;
        if (logLoadingInfo) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> System.out.println("Classloading requests: " + ClassPath.class.getClassLoader() + ", class=" + classLoading + ", resource=" + resourceLoading), "Shutdown hook for tracing classloading information"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ClassPath";
                break;
            }
            case 3: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classConsumer";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findClassInLoader";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResources";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLoader";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFromManifestClassPathIfNeeded";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadManifestClasspath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Measurer {
        private final AtomicLong timeCounter = new AtomicLong();
        private final AtomicInteger requestCounter = new AtomicInteger();
        private final ThreadLocal<Boolean> doingTiming = new ThreadLocal();

        private Measurer() {
        }

        long startTiming() {
            if (!recordLoadingTime || this.doingTiming.get() != null) {
                return -1L;
            }
            this.doingTiming.set(Boolean.TRUE);
            return System.nanoTime();
        }

        void record(long start, String resourceName) {
            if (start == -1L) {
                return;
            }
            this.doingTiming.set(null);
            long time = System.nanoTime() - start;
            long totalTime = this.timeCounter.addAndGet(time);
            int totalRequests = this.requestCounter.incrementAndGet();
            if (logLoadingInfo) {
                if (time > 3000000L) {
                    System.out.println(TimeUnit.NANOSECONDS.toMillis(time) + " ms for " + resourceName);
                }
                if (totalRequests % 10000 == 0) {
                    System.out.println(ClassPath.class.getClassLoader() + ", requests: " + totalRequests + ", time:" + TimeUnit.NANOSECONDS.toMillis(totalTime) + "ms");
                }
            }
        }

        public String toString() {
            return "Measurer(time=" + TimeUnit.NANOSECONDS.toMillis(this.timeCounter.get()) + "ms, requests=" + this.requestCounter + ')';
        }
    }

    public static interface ClassDataConsumer {
        public boolean isByteBufferSupported(String var1);

        public Class<?> consumeClassData(String var1, byte[] var2) throws IOException;

        public Class<?> consumeClassData(String var1, ByteBuffer var2) throws IOException;
    }

    private static final class ResourceEnumeration
    implements Enumeration<URL> {
        private int index;
        private Resource resource;
        private final String name;
        private final Loader[] loaders;

        ResourceEnumeration(@NotNull String name2, Loader[] loaders) {
            if (name2 == null) {
                ResourceEnumeration.$$$reportNull$$$0(0);
            }
            this.name = name2;
            this.loaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.resource != null) {
                return true;
            }
            long start = resourceLoading.startTiming();
            try {
                while (this.index < this.loaders.length) {
                    Loader loader = this.loaders[this.index++];
                    this.resource = loader.getResource(this.name);
                    if (this.resource == null) continue;
                    boolean bl2 = true;
                    return bl2;
                }
            }
            finally {
                resourceLoading.record(start, this.name);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.resource;
            this.resource = null;
            return resource.getURL();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/lang/ClassPath$ResourceEnumeration", "<init>"));
        }
    }

    private static final class UncachedResourceEnumeration
    implements Enumeration<URL> {
        private int index;
        private Resource resource;
        private final String name;
        private final ClassPath classPath;

        UncachedResourceEnumeration(@NotNull String name2, @NotNull ClassPath classPath2) {
            if (name2 == null) {
                UncachedResourceEnumeration.$$$reportNull$$$0(0);
            }
            if (classPath2 == null) {
                UncachedResourceEnumeration.$$$reportNull$$$0(1);
            }
            this.name = name2;
            this.classPath = classPath2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.resource != null) {
                return true;
            }
            long start = resourceLoading.startTiming();
            try {
                Loader loader;
                while ((loader = this.classPath.getLoader(this.index++)) != null) {
                    this.resource = loader.getResource(this.name);
                    if (this.resource == null) continue;
                    boolean bl2 = true;
                    return bl2;
                }
            }
            finally {
                resourceLoading.record(start, this.name);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.resource;
            this.resource = null;
            return resource.getURL();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "classPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/lang/ClassPath$UncachedResourceEnumeration";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MeasuringClassDataConsumer
    implements ClassDataConsumer {
        private static final ThreadLocal<Boolean> doingClassDefineTiming = new ThreadLocal();
        private final ClassDataConsumer classDataConsumer;

        MeasuringClassDataConsumer(ClassDataConsumer classDataConsumer) {
            this.classDataConsumer = classDataConsumer;
        }

        @Override
        public boolean isByteBufferSupported(String name2) {
            return this.classDataConsumer.isByteBufferSupported(name2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> consumeClassData(String name2, byte[] data) throws IOException {
            long start = MeasuringClassDataConsumer.startTiming();
            try {
                Class<?> clazz = this.classDataConsumer.consumeClassData(name2, data);
                return clazz;
            }
            finally {
                MeasuringClassDataConsumer.record(start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> consumeClassData(String name2, ByteBuffer data) throws IOException {
            long start = MeasuringClassDataConsumer.startTiming();
            try {
                Class<?> clazz = this.classDataConsumer.consumeClassData(name2, data);
                return clazz;
            }
            finally {
                MeasuringClassDataConsumer.record(start);
            }
        }

        private static long startTiming() {
            if (doingClassDefineTiming.get() != null) {
                return -1L;
            }
            doingClassDefineTiming.set(Boolean.TRUE);
            return System.nanoTime();
        }

        private static void record(long start) {
            if (start != -1L) {
                doingClassDefineTiming.set(null);
                classDefineTotalTime.addAndGet(System.nanoTime() - start);
            }
        }
    }
}

