/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeTypeSubstitutorByTypeConstructor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "map", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "approximateIntegerLiterals", "", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;Z)V", "substituteType", "type", "toString", "", "providers"})
final class ConeTypeSubstitutorByTypeConstructor
extends AbstractConeSubstitutor
implements TypeSubstitutorMarker {
    @NotNull
    private final Map<TypeConstructorMarker, ConeKotlinType> map;
    private final boolean approximateIntegerLiterals;

    public ConeTypeSubstitutorByTypeConstructor(@NotNull Map<TypeConstructorMarker, ? extends ConeKotlinType> map, @NotNull ConeTypeContext typeContext2, boolean approximateIntegerLiterals) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)typeContext2, (String)"typeContext");
        super(typeContext2);
        this.map = map;
        this.approximateIntegerLiterals = approximateIntegerLiterals;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (!(type2 instanceof ConeLookupTagBasedType || type2 instanceof ConeStubType || type2 instanceof ConeTypeVariableType)) {
            return null;
        }
        ConeKotlinType coneKotlinType = this.map.get(TypeSystemContextHelpersKt.typeConstructor(type2, this.getTypeContext()));
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType coneKotlinType2 = coneKotlinType;
        ConeKotlinType approximatedIntegerLiteralType = this.approximateIntegerLiterals ? ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType$default(coneKotlinType2, null, 1, null) : coneKotlinType2;
        return LookupTagUtilsKt.withCombinedAttributesFrom(this.updateNullabilityIfNeeded(approximatedIntegerLiteralType, type2), type2);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.map.entrySet(), (CharSequence)" | ", (CharSequence)"{", (CharSequence)"}", (int)0, null, ConeTypeSubstitutorByTypeConstructor::toString$lambda$0, (int)24, null);
    }

    private static final CharSequence toString$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        TypeConstructorMarker constructor = (TypeConstructorMarker)entry.getKey();
        ConeKotlinType type2 = (ConeKotlinType)entry.getValue();
        return constructor + " -> " + ConeTypeUtilsKt.renderForDebugging(type2);
    }
}

