/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.symbols.pointers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.KaBaseCachedSymbolPointer;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\rH\u0015\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/symbols/pointers/KaFirClassLikeSymbolPointer;", "T", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/symbols/pointers/KaBaseCachedSymbolPointer;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "expectedClass", "Lkotlin/reflect/KClass;", "originalSymbol", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lkotlin/reflect/KClass;Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;)V", "restoreIfNotCached", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassLikeSymbol;", "pointsToTheSameSymbolAs", "", "other", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "analysis-api-fir"})
public final class KaFirClassLikeSymbolPointer<T extends KaClassLikeSymbol>
extends KaBaseCachedSymbolPointer<T> {
    @NotNull
    private final ClassId classId;
    @NotNull
    private final KClass<T> expectedClass;

    public KaFirClassLikeSymbolPointer(@NotNull ClassId classId, @NotNull KClass<T> expectedClass, @Nullable T originalSymbol) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter(expectedClass, (String)"expectedClass");
        super((KaSymbol)originalSymbol);
        this.classId = classId;
        this.expectedClass = expectedClass;
    }

    @Override
    @KaImplementationDetail
    @Nullable
    protected T restoreIfNotCached(@NotNull KaSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        if (!(analysisSession instanceof KaFirSession)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KaClassLikeSymbol kaClassLikeSymbol = ((KaFirSession)analysisSession).getFirSymbolBuilder$analysis_api_fir().getClassifierBuilder().buildClassLikeSymbolByClassId(this.classId);
        if (kaClassLikeSymbol == null) {
            return null;
        }
        KaClassLikeSymbol classLikeSymbol = kaClassLikeSymbol;
        if (!this.expectedClass.isInstance((Object)classLikeSymbol)) {
            return null;
        }
        return (T)classLikeSymbol;
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return other == this || other instanceof KaFirClassLikeSymbolPointer && Intrinsics.areEqual((Object)((KaFirClassLikeSymbolPointer)other).classId, (Object)this.classId) && Intrinsics.areEqual(((KaFirClassLikeSymbolPointer)other).expectedClass, this.expectedClass);
    }
}

