/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathCustomizer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.system.CpuArch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.properties.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String SYSTEM_PATHS_CUSTOMIZER = "idea.paths.customizer";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String PROPERTY_VENDOR_NAME = "idea.vendor.name";
    private static final String JRE_DIRECTORY = "jbr";
    private static final String LIB_DIRECTORY = "lib";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String BIN_DIRECTORY = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String SYSTEM_DIRECTORY = "system";
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final String COMMUNITY_MARKER = "intellij.idea.community.main.iml";
    private static final String ULTIMATE_MARKER = ".ultimate.root.marker";
    private static final String PRODUCT_INFO_JSON = "product-info.json";
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static Path ourCommonDataPath;
    private static String ourConfigPath;
    private static String ourSystemPath;
    private static String ourScratchPath;
    private static String ourPluginPath;
    private static String ourLogPath;
    private static Path ourStartupScriptDir;
    private static Path ourOriginalConfigDir;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result2 = ourHomePath;
        if (result2 != null) {
            return result2;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result2 = ourHomePath;
            if (result2 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result2;
            }
            String explicit = PathManager.getExplicitPath(PROPERTY_HOME_PATH);
            if (explicit == null) {
                explicit = PathManager.getExplicitPath(PROPERTY_HOME);
            }
            if (explicit != null) {
                result2 = explicit;
                if (!Files.isDirectory(Paths.get(result2, new String[0]), new LinkOption[0])) {
                    ourHomePath = result2;
                    throw new RuntimeException("Invalid home path '" + result2 + "'");
                }
            } else if (insideIde && (result2 = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result2 != null && SystemInfoRt.isWindows) {
                try {
                    result2 = Paths.get(result2, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException advice) {
                    // empty catch block
                }
            }
            if (result2 == null) {
                ourBinDirectories = Collections.emptyList();
            } else {
                Path root = Paths.get(result2, new String[0]);
                if (Boolean.getBoolean("idea.use.dev.build.server")) {
                    root = root.resolve("../../../..").normalize();
                }
                ourBinDirectories = PathManager.getBinDirectories(root);
            }
            ourHomePath = result2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result2;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result2 = ourBinDirectories;
        if (result2 == null) {
            PathManager.getHomePath(true);
            result2 = ourBinDirectories;
        }
        return result2;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        try {
            return PathManager.isUnderHomeDirectory(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e2) {
            return false;
        }
    }

    public static boolean isUnderHomeDirectory(@NotNull Path target) {
        if (target == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        Path home = Paths.get(PathManager.getHomePath(), new String[0]);
        try {
            home = home.toRealPath(new LinkOption[0]);
            target = target.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return target.startsWith(home);
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        Path result2;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return (result2 = PathManager.getHomeDirFor(aClass)) == null ? null : result2.toString();
    }

    @Nullable
    public static Path getHomeDirFor(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        Path result2 = null;
        String rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        if (rootPath != null) {
            Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
            while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
            }
            result2 = root;
        }
        return result2;
    }

    private static boolean isIdeaHome(Path root) {
        return Files.isRegularFile(root.resolve(PRODUCT_INFO_JSON), new LinkOption[0]) || Files.isRegularFile(root.resolve(BIN_DIRECTORY).resolve(PROPERTIES_FILE_NAME), new LinkOption[0]) || Files.isRegularFile(root.resolve(COMMUNITY_MARKER), new LinkOption[0]) || Files.isRegularFile(root.resolve(ULTIMATE_MARKER), new LinkOption[0]);
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        Path[] candidates2 = new Path[]{root.resolve(BIN_DIRECTORY), Paths.get(PathManager.getCommunityHomePath(root.toString()), BIN_DIRECTORY)};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (Path dir : candidates2) {
            String arch;
            if (binDirs.contains(dir) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            if (!SystemInfoRt.isWindows && !SystemInfoRt.isLinux) continue;
            String string2 = CpuArch.isIntel64() ? "amd64" : (arch = CpuArch.isArm64() ? "aarch64" : null);
            if (arch == null || !Files.isDirectory(dir = dir.resolve(arch), new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + '/' + BIN_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Nullable
    public static Path findBinFile(@NotNull String fileName2) {
        if (fileName2 == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate = binDir.resolve(fileName2);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static Path findBinFileWithException(@NotNull String fileName2) {
        Path file2;
        if (fileName2 == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        if ((file2 = PathManager.findBinFile(fileName2)) != null) {
            Path path = file2;
            if (path == null) {
                PathManager.$$$reportNull$$$0(8);
            }
            return path;
        }
        StringBuilder message = new StringBuilder();
        message.append('\'').append(fileName2).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message.append('\n').append(directory);
        }
        throw new RuntimeException(message.toString());
    }

    @NotNull
    public static String getLibPath() {
        String string2 = PathManager.getHomePath() + '/' + LIB_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string2 = PathManager.getHomePath() + '/' + PLUGINS_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public static String getBundledRuntimePath() {
        String string2 = PathManager.getHomePath() + '/' + JRE_DIRECTORY + (SystemInfoRt.isMac ? "/Contents/Home" : "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    public static synchronized Path getCommonDataPath() {
        Path path = ourCommonDataPath;
        if (path == null) {
            path = Paths.get(PathManager.platformPath("", "Application Support", "", "APPDATA", "", "XDG_DATA_HOME", ".local/share", ""), new String[0]);
            if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            ourCommonDataPath = path;
        }
        Path path2 = path;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(12);
        }
        return path2;
    }

    @Nullable
    public static String getPathsSelector() {
        return PATHS_SELECTOR;
    }

    @NotNull
    public static Path getConfigDir() {
        Path path = Paths.get(PathManager.getConfigPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return path;
    }

    @NotNull
    public static String getConfigPath() {
        String path = ourConfigPath;
        if (path == null) {
            String explicit = PathManager.getExplicitPath(PROPERTY_CONFIG_PATH);
            path = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + CONFIG_DIRECTORY);
            ourConfigPath = path;
        }
        String string2 = path;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @TestOnly
    public static void setExplicitConfigPath(@Nullable String path) {
        ourConfigPath = path;
    }

    @NotNull
    public static String getScratchPath() {
        String path = ourScratchPath;
        if (path == null) {
            String explicit = PathManager.getExplicitPath(PROPERTY_SCRATCH_PATH);
            path = explicit == null ? PathManager.getConfigPath() : explicit;
            ourScratchPath = path;
        }
        String string2 = path;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @NotNull
    public static String getOptionsPath() {
        String string2 = PathManager.getConfigPath() + '/' + OPTIONS_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NotNull
    public static File getOptionsFile(@NotNull String fileName2) {
        if (fileName2 == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        File file2 = Paths.get(PathManager.getOptionsPath(), fileName2 + DEFAULT_EXT).toFile();
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        return file2;
    }

    @NotNull
    public static Path getPluginsDir() {
        Path path = Paths.get(PathManager.getPluginsPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(21);
        }
        return path;
    }

    @NotNull
    public static String getPluginsPath() {
        String path = ourPluginPath;
        if (path == null) {
            String explicit = PathManager.getExplicitPath(PROPERTY_PLUGINS_PATH);
            path = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_CONFIG_PATH) == null ? PathManager.getDefaultPluginPathFor(PATHS_SELECTOR) : PathManager.getConfigPath() + '/' + PLUGINS_DIRECTORY);
            ourPluginPath = path;
        }
        String string2 = path;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(22);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(23);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", PLUGINS_DIRECTORY, "APPDATA", PLUGINS_DIRECTORY, "XDG_DATA_HOME", ".local/share", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        return string2;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : null;
    }

    @NotNull
    public static Path getSystemDir() {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        return path;
    }

    @NotNull
    public static String getSystemPath() {
        String path = ourSystemPath;
        if (path == null) {
            String explicit = PathManager.getExplicitPath(PROPERTY_SYSTEM_PATH);
            path = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + SYSTEM_DIRECTORY);
            ourSystemPath = path;
        }
        String string2 = path;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        String string2 = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultUnixSystemPath(@NotNull String userHome, @NotNull String selector) {
        if (userHome == null) {
            PathManager.$$$reportNull$$$0(29);
        }
        if (selector == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        String string2 = PathManager.getUnixPlatformPath(userHome, selector, null, ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        return string2;
    }

    @NotNull
    public static String getTempPath() {
        String string2 = PathManager.getSystemPath() + "/tmp";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        return string2;
    }

    @NotNull
    public static Path getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        Path path = Paths.get(indexRootPath, new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        return path;
    }

    @NotNull
    public static Path getLogDir() {
        Path path = Paths.get(PathManager.getLogPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        return path;
    }

    @NotNull
    public static String getLogPath() {
        String path = ourLogPath;
        if (path == null) {
            String explicit = PathManager.getExplicitPath(PROPERTY_LOG_PATH);
            path = explicit != null ? explicit : (PATHS_SELECTOR != null && System.getProperty(PROPERTY_SYSTEM_PATH) == null ? PathManager.getDefaultLogPathFor(PATHS_SELECTOR) : PathManager.getSystemPath() + '/' + LOG_DIRECTORY);
            ourLogPath = path;
        }
        String string2 = path;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        return string2;
    }

    @NotNull
    public static String getDefaultLogPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        String string2 = PathManager.platformPath(selector, "Logs", "", "LOCALAPPDATA", LOG_DIRECTORY, "XDG_CACHE_HOME", ".cache", LOG_DIRECTORY);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getStartupScriptDir() {
        if (ourStartupScriptDir != null) {
            Path path = ourStartupScriptDir;
            if (path == null) {
                PathManager.$$$reportNull$$$0(38);
            }
            return path;
        }
        Path path = PathManager.getSystemDir().resolve(PLUGINS_DIRECTORY);
        if (path == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getPluginTempPath() {
        String string2 = PathManager.getSystemPath() + '/' + PLUGINS_DIRECTORY;
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(40);
        }
        return string2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context2, @NotNull String path) {
        URL url;
        if (context2 == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        if ((url = context2.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader classLoader, @NotNull String resourcePath) {
        URL url;
        if (classLoader == null) {
            PathManager.$$$reportNull$$$0(43);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        return (url = classLoader.getResource(resourcePath)) == null ? null : PathManager.extractRoot(url, "/" + resourcePath);
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.isEmpty() || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            File result2;
            try {
                result2 = new File(resourceURL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException("URL='" + resourceURL + "'", e2);
            }
            String path = result2.getPath();
            String testPath = path.replace('\\', '/');
            String testResourcePath = resourcePath.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath)) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
            if (jarPath != null) {
                resultPath = jarPath;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(@NotNull String url) {
        int pivot;
        if (url == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        if ((pivot = url.indexOf("!/")) < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            File result2;
            URL parsedUrl = new URL(jarPath);
            try {
                result2 = new File(parsedUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException("URL='" + parsedUrl + "'", e2);
            }
            return result2.getPath().replace('\\', '/');
        }
        catch (Exception e3) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    @ApiStatus.Internal
    public static void loadProperties() {
        String optionsDir;
        ArrayList<Path> files2 = new ArrayList<Path>();
        String customFile = System.getProperty(PROPERTIES_FILE);
        if (customFile != null) {
            files2.add(Paths.get(customFile, new String[0]));
        }
        if ((optionsDir = PathManager.getCustomOptionsDirectory()) != null) {
            files2.add(Paths.get(optionsDir, PROPERTIES_FILE_NAME));
        }
        files2.add(Paths.get(System.getProperty("user.home"), PROPERTIES_FILE_NAME));
        for (Path binDir : PathManager.getBinDirectories()) {
            files2.add(binDir.resolve(PROPERTIES_FILE_NAME));
        }
        final Properties sysProperties = System.getProperties();
        final String homePath = PathManager.getHomePath(true);
        for (final Path file2 : files2) {
            try {
                BufferedReader reader = Files.newBufferedReader(file2);
                try {
                    new Properties(){

                        @Override
                        public Object put(Object key, Object value2) {
                            if (PathManager.PROPERTY_HOME_PATH.equals(key) || PathManager.PROPERTY_HOME.equals(key)) {
                                PathManager.log(file2 + ": '" + key + "' cannot be redefined");
                            } else if (!sysProperties.containsKey(key)) {
                                sysProperties.setProperty((String)key, PathManager.substituteVars((String)value2, homePath));
                            }
                            return null;
                        }
                    }.load(reader);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (AccessDeniedException | NoSuchFileException reader) {
            }
            catch (IOException e2) {
                PathManager.log("Can't read property file '" + file2 + "': " + e2.getMessage());
            }
        }
        if (SystemInfoRt.isJBSystemMenu) {
            sysProperties.setProperty("apple.laf.useScreenMenuBar", "false");
        }
    }

    public static void customizePaths() {
        String property2 = System.getProperty(SYSTEM_PATHS_CUSTOMIZER);
        if (property2 == null) {
            return;
        }
        try {
            PathCustomizer.CustomPaths paths2;
            Class<?> aClass = PathManager.class.getClassLoader().loadClass(property2);
            Object customizer = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (customizer instanceof PathCustomizer && (paths2 = ((PathCustomizer)customizer).customizePaths()) != null) {
                ourOriginalConfigDir = PathManager.getConfigDir();
                if (paths2.configPath != null) {
                    System.setProperty(PROPERTY_CONFIG_PATH, paths2.configPath);
                }
                if (paths2.systemPath != null) {
                    System.setProperty(PROPERTY_SYSTEM_PATH, paths2.systemPath);
                }
                if (paths2.pluginsPath != null) {
                    System.setProperty(PROPERTY_PLUGINS_PATH, paths2.pluginsPath);
                }
                if (paths2.logDirPath != null) {
                    System.setProperty(PROPERTY_LOG_PATH, paths2.logDirPath);
                }
                if (paths2.startupScriptDir != null) {
                    ourStartupScriptDir = paths2.startupScriptDir;
                }
                ourConfigPath = null;
                ourSystemPath = null;
                ourPluginPath = null;
                ourScratchPath = null;
                ourLogPath = null;
            }
        }
        catch (Throwable e2) {
            PathManager.log("Failed to set up '" + property2 + "' as PathCustomizer: " + e2);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getOriginalConfigDir() {
        return ourOriginalConfigDir != null ? ourOriginalConfigDir : PathManager.getConfigDir();
    }

    @Contract(value="null -> null")
    public static String substituteVars(String s2) {
        return PathManager.substituteVars(s2, PathManager.getHomePath());
    }

    @Contract(value="null, _ -> null")
    public static String substituteVars(String s2, @NotNull String ideaHomePath) {
        if (ideaHomePath == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        if (s2 == null) {
            return null;
        }
        if (s2.startsWith("..")) {
            s2 = ideaHomePath + '/' + BIN_DIRECTORY + '/' + s2;
        }
        Matcher m4 = Lazy.PROPERTY_REF.matcher(s2);
        while (m4.find()) {
            String key = m4.group(1);
            String value2 = System.getProperty(key);
            if (value2 == null) {
                switch (key) {
                    case "idea.home.path": 
                    case "idea.home": {
                        value2 = ideaHomePath;
                        break;
                    }
                    case "idea.config.path": {
                        value2 = PathManager.getConfigPath();
                        break;
                    }
                    case "idea.system.path": {
                        value2 = PathManager.getSystemPath();
                    }
                }
            }
            if (value2 == null) {
                PathManager.log("Unknown property: " + key);
                value2 = "";
            }
            s2 = s2.replace(m4.group(), value2);
            m4 = Lazy.PROPERTY_REF.matcher(s2);
        }
        return s2;
    }

    @NotNull
    public static File findFileInLibDirectory(@NotNull String relativePath) {
        Path file2;
        if (relativePath == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        if (!Files.exists(file2 = Paths.get(PathManager.getLibPath(), relativePath), new LinkOption[0])) {
            file2 = Paths.get(PathManager.getHomePath(), "community/lib/" + relativePath);
        }
        File file3 = file2.toFile();
        if (file3 == null) {
            PathManager.$$$reportNull$$$0(48);
        }
        return file3;
    }

    @NotNull
    public static String getCommunityHomePath() {
        return PathManager.getCommunityHomePath(PathManager.getHomePath());
    }

    private static boolean isDevServer() {
        return Boolean.getBoolean("idea.use.dev.build.server");
    }

    @NotNull
    private static String getCommunityHomePath(@NotNull String homePath) {
        boolean isRunningFromSources;
        if (homePath == null) {
            PathManager.$$$reportNull$$$0(49);
        }
        if (!(isRunningFromSources = Files.isDirectory(Paths.get(homePath, ".idea"), new LinkOption[0])) && !PathManager.isDevServer()) {
            String string2 = homePath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(50);
            }
            return string2;
        }
        ArrayList<Path> possibleCommunityPathList = new ArrayList<Path>();
        possibleCommunityPathList.add(Paths.get(homePath, "community"));
        possibleCommunityPathList.add(Paths.get(homePath, "..", "..", "..", "community"));
        possibleCommunityPathList.add(Paths.get(homePath, "..", "..", "..", "..", "community"));
        for (Path possibleCommunityPath : possibleCommunityPathList) {
            if (!Files.isRegularFile(possibleCommunityPath.resolve(COMMUNITY_MARKER), new LinkOption[0])) continue;
            String string3 = possibleCommunityPath.normalize().toString();
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(51);
            }
            return string3;
        }
        String string4 = homePath;
        if (string4 == null) {
            PathManager.$$$reportNull$$$0(52);
        }
        return string4;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        Path resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(53);
        }
        return (resourceRoot = PathManager.getJarForClass(aClass)) == null ? null : resourceRoot.toString();
    }

    @Nullable
    public static Path getJarForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null ? null : Paths.get(resourceRoot, new String[0]).toAbsolutePath();
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        String string2 = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        return string2;
    }

    @Nullable
    private static String getExplicitPath(@NotNull String property2) {
        String path;
        if (property2 == null) {
            PathManager.$$$reportNull$$$0(57);
        }
        if ((path = System.getProperty(property2)) == null) {
            return null;
        }
        boolean quoted = path.length() > 1 && '\"' == path.charAt(0) && '\"' == path.charAt(path.length() - 1);
        return PathManager.getAbsolutePath(quoted ? path.substring(1, path.length() - 1) : path);
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = System.getProperty("user.home");
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            String dir = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            return PathManager.getUnixPlatformPath(userHome, selector, xdgVar, xdgDfl, xdgSub);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String getUnixPlatformPath(String userHome, String selector, @Nullable String xdgVar, String xdgDfl, String xdgSub) {
        String dir;
        String string2 = dir = xdgVar != null ? System.getenv(xdgVar) : null;
        if (dir == null || dir.isEmpty()) {
            dir = userHome + '/' + xdgDfl;
        }
        dir = dir + '/' + PathManager.vendorName();
        if (!selector.isEmpty()) {
            dir = dir + '/' + selector;
        }
        if (!xdgSub.isEmpty()) {
            dir = dir + '/' + xdgSub;
        }
        return dir;
    }

    private static String vendorName() {
        String property2 = System.getProperty(PROPERTY_VENDOR_NAME);
        if (property2 == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance2 = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property2 = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty(PROPERTY_VENDOR_NAME, property2 != null ? property2 : "JetBrains");
        }
        return property2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 42: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 4: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: 
            case 23: 
            case 27: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHome";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledRuntimePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonDataPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsDir";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDir";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixSystemPath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDir";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLogPathFor";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupScriptDir";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHomeDirFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUnixSystemPath";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLogPathFor";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCommunityHomePath";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getJarForClass";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 30: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 53: 
            case 54: 
            case 55: 
            case 57: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

