/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "<init>", "()V", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findSourceOrBinaryVirtualFile", "findKotlinClassOrContent", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "classFileName", "", "jClass", "SERVICE", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileFinder.kt\norg/jetbrains/kotlin/load/kotlin/VirtualFileFinder\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,67:1\n19#2:68\n*S KotlinDebug\n*F\n+ 1 VirtualFileFinder.kt\norg/jetbrains/kotlin/load/kotlin/VirtualFileFinder\n*L\n46#1:68\n*E\n"})
public abstract class VirtualFileFinder
implements KotlinClassFinder {
    @NotNull
    public static final SERVICE SERVICE = new SERVICE(null);

    @Nullable
    public abstract VirtualFile findVirtualFileWithHeader(@NotNull ClassId var1);

    @Nullable
    public abstract VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId var1);

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, file2, metadataVersion, null, 4, null);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Object object = javaClass instanceof VirtualFileBoundJavaClass ? (VirtualFileBoundJavaClass)javaClass : null;
        if (object == null || (object = object.getVirtualFile()) == null) {
            return null;
        }
        Object file2 = object;
        if (javaClass.getOuterClass() != null) {
            VirtualFile virtualFile = ((VirtualFile)file2).getParent();
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile $this$sure$iv = virtualFile.findChild(this.classFileName(javaClass) + ".class");
            boolean $i$f$sure = false;
            VirtualFile virtualFile2 = $this$sure$iv;
            if (virtualFile2 == null) {
                boolean bl2 = false;
                String string2 = "Virtual file not found for " + javaClass;
                throw new AssertionError((Object)string2);
            }
            file2 = virtualFile2;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, (VirtualFile)file2, metadataVersion, null, 4, null);
    }

    private final String classFileName(JavaClass jClass) {
        String string2 = jClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String simpleName2 = string2;
        JavaClass javaClass = jClass.getOuterClass();
        if (javaClass == null) {
            return simpleName2;
        }
        JavaClass outerClass = javaClass;
        return this.classFileName(outerClass) + '$' + simpleName2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder$SERVICE;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "frontend.java"})
    public static final class SERVICE {
        private SERVICE() {
        }

        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            return VirtualFileFinderFactory.SERVICE.getInstance(project).create(project, module2);
        }

        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFileFinderFactory virtualFileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            return virtualFileFinderFactory.create(globalSearchScope);
        }

        public /* synthetic */ SERVICE(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

