/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002!\"B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001e\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ2\u0010\u001d\u001a\u00020\f*\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u00182\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "supertypeSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "resolveDeprecations", "", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;Z)V", "candidates", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "value", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "applicability", "getApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "processCandidate", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "isVisible", "getResult", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "filterOutAmbiguousTypealiases", "TypeResolutionResult", "TypeCandidate", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTypeCandidateCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeCandidateCollector.kt\norg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1#2:156\n*E\n"})
public final class FirTypeCandidateCollector {
    @NotNull
    private final FirSession session;
    @Nullable
    private final FirFile useSiteFile;
    @NotNull
    private final List<FirDeclaration> containingDeclarations;
    @NotNull
    private final SupertypeSupplier supertypeSupplier;
    private final boolean resolveDeprecations;
    @NotNull
    private final Set<TypeCandidate> candidates;
    @Nullable
    private CandidateApplicability applicability;

    public FirTypeCandidateCollector(@NotNull FirSession session, @Nullable FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @NotNull SupertypeSupplier supertypeSupplier, boolean resolveDeprecations) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
        Intrinsics.checkNotNullParameter((Object)supertypeSupplier, (String)"supertypeSupplier");
        this.session = session;
        this.useSiteFile = useSiteFile;
        this.containingDeclarations = containingDeclarations;
        this.supertypeSupplier = supertypeSupplier;
        this.resolveDeprecations = resolveDeprecations;
        this.candidates = new LinkedHashSet();
    }

    public /* synthetic */ FirTypeCandidateCollector(FirSession firSession, FirFile firFile, List list, SupertypeSupplier supertypeSupplier, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            supertypeSupplier = SupertypeSupplier.Default.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        this(firSession, firFile, list, supertypeSupplier, bl2);
    }

    @Nullable
    public final CandidateApplicability getApplicability() {
        return this.applicability;
    }

    public final void processCandidate(@NotNull FirBasedSymbol<?> symbol, @Nullable ConeSubstitutor substitutor2) {
        ConeDiagnostic diagnostic;
        CandidateApplicability symbolApplicability;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                symbolApplicability = CandidateApplicability.RESOLVED;
                diagnostic = null;
                if (!this.isVisible(symbol, this.useSiteFile, this.containingDeclarations, this.supertypeSupplier)) {
                    boolean fromCodeFragment = CollectionsKt.getOrNull(this.containingDeclarations, (int)1) instanceof FirCodeFragment;
                    CandidateApplicability applicability = fromCodeFragment ? CandidateApplicability.RESOLVED_LOW_PRIORITY : CandidateApplicability.K2_VISIBILITY_ERROR;
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Comparable)((Object)applicability)), (Comparable)((Comparable)((Object)symbolApplicability))));
                    if (!fromCodeFragment) {
                        diagnostic = new ConeVisibilityError(symbol);
                    }
                }
                if (this.resolveDeprecations && DeprecationUtilsKt.isDeprecationLevelHidden(symbol, this.session)) {
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Comparable)((Object)CandidateApplicability.HIDDEN)), (Comparable)((Comparable)((Object)symbolApplicability))));
                    diagnostic = null;
                }
                if (this.applicability == null) break block7;
                CandidateApplicability candidateApplicability = this.applicability;
                Intrinsics.checkNotNull((Object)((Object)candidateApplicability));
                if (symbolApplicability.compareTo((Enum)candidateApplicability) <= 0) break block8;
            }
            this.applicability = symbolApplicability;
            this.candidates.clear();
        }
        if (symbolApplicability == this.applicability) {
            this.candidates.add(new TypeCandidate(symbol, substitutor2, diagnostic, symbolApplicability));
        }
    }

    public static /* synthetic */ void processCandidate$default(FirTypeCandidateCollector firTypeCandidateCollector, FirBasedSymbol firBasedSymbol, ConeSubstitutor coneSubstitutor, int n2, Object object) {
        if ((n2 & 2) != 0) {
            coneSubstitutor = null;
        }
        firTypeCandidateCollector.processCandidate(firBasedSymbol, coneSubstitutor);
    }

    private final boolean isVisible(FirBasedSymbol<?> $this$isVisible, FirFile useSiteFile, List<? extends FirDeclaration> containingDeclarations, SupertypeSupplier supertypeSupplier) {
        FirBasedSymbol<?> firBasedSymbol = $this$isVisible;
        Object declaration2 = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return useSiteFile != null && declaration2 instanceof FirMemberDeclaration ? FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(this.session), (FirMemberDeclaration)declaration2, this.session, useSiteFile, containingDeclarations, null, false, null, false, supertypeSupplier, 192, null) : true;
    }

    @NotNull
    public final TypeResolutionResult getResult() {
        TypeResolutionResult typeResolutionResult;
        this.filterOutAmbiguousTypealiases(this.candidates);
        int candidateCount = this.candidates.size();
        if (candidateCount == 1) {
            TypeCandidate candidate = (TypeCandidate)CollectionsKt.single((Iterable)this.candidates);
            typeResolutionResult = new TypeResolutionResult.Resolved(candidate);
        } else {
            typeResolutionResult = candidateCount > 1 ? (TypeResolutionResult)new TypeResolutionResult.Ambiguity(CollectionsKt.toList((Iterable)this.candidates)) : (TypeResolutionResult)TypeResolutionResult.Unresolved.INSTANCE;
        }
        return typeResolutionResult;
    }

    private final void filterOutAmbiguousTypealiases(Set<TypeCandidate> candidates2) {
        if (candidates2.size() <= 1) {
            return;
        }
        Set aliasesToRemove = new LinkedHashSet();
        Map<ClassId, ClassId> classTypealiasesThatDontCauseAmbiguity = FirPlatformClassMapperKt.getPlatformClassMapper(this.session).getClassTypealiasesThatDontCauseAmbiguity();
        for (TypeCandidate candidate : candidates2) {
            ClassId it;
            FirBasedSymbol<?> symbol = candidate.getSymbol();
            if (!(symbol instanceof FirClassLikeSymbol)) continue;
            if (classTypealiasesThatDontCauseAmbiguity.get(((FirClassLikeSymbol)symbol).getClassId()) == null) continue;
            boolean bl2 = false;
            aliasesToRemove.add(it);
        }
        if (!((Collection)aliasesToRemove).isEmpty()) {
            CollectionsKt.removeAll((Iterable)candidates2, arg_0 -> FirTypeCandidateCollector.filterOutAmbiguousTypealiases$lambda$2(aliasesToRemove, arg_0));
        }
    }

    private static final boolean filterOutAmbiguousTypealiases$lambda$2(Set $aliasesToRemove, TypeCandidate it) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirBasedSymbol<?> firBasedSymbol = it.getSymbol();
        Object object = firBasedSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firBasedSymbol : null;
        if (object != null && (object = ((FirClassLikeSymbol)object).getClassId()) != null) {
            Object classId = object;
            boolean bl3 = false;
            bl2 = $aliasesToRemove.contains(classId);
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\r\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0086\u0002J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0086\u0002R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCandidate;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "applicability", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getSubstitutor", "()Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "getDiagnostic", "()Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "getApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "equals", "", "other", "", "hashCode", "", "component1", "component2", "resolve"})
    public static final class TypeCandidate
    extends AbstractCandidate {
        @NotNull
        private final FirBasedSymbol<?> symbol;
        @Nullable
        private final ConeSubstitutor substitutor;
        @Nullable
        private final ConeDiagnostic diagnostic;
        @NotNull
        private final CandidateApplicability applicability;

        public TypeCandidate(@NotNull FirBasedSymbol<?> symbol, @Nullable ConeSubstitutor substitutor2, @Nullable ConeDiagnostic diagnostic, @NotNull CandidateApplicability applicability) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            Intrinsics.checkNotNullParameter((Object)((Object)applicability), (String)"applicability");
            this.symbol = symbol;
            this.substitutor = substitutor2;
            this.diagnostic = diagnostic;
            this.applicability = applicability;
        }

        @Override
        @NotNull
        public FirBasedSymbol<?> getSymbol() {
            return this.symbol;
        }

        @Nullable
        public final ConeSubstitutor getSubstitutor() {
            return this.substitutor;
        }

        @Nullable
        public final ConeDiagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public CandidateApplicability getApplicability() {
            return this.applicability;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeCandidate)) {
                return false;
            }
            return Intrinsics.areEqual(this.getSymbol(), ((TypeCandidate)other).getSymbol());
        }

        public int hashCode() {
            return this.getSymbol().hashCode();
        }

        @NotNull
        public final FirBasedSymbol<?> component1() {
            return this.getSymbol();
        }

        @Nullable
        public final ConeSubstitutor component2() {
            return this.substitutor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "", "<init>", "()V", "resolvedCandidateOrNull", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "Ambiguity", "Unresolved", "Resolved", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Unresolved;", "resolve"})
    public static abstract class TypeResolutionResult {
        private TypeResolutionResult() {
        }

        @Nullable
        public final TypeCandidate resolvedCandidateOrNull() {
            Resolved resolved = this instanceof Resolved ? (Resolved)this : null;
            return resolved != null ? resolved.getTypeCandidate() : null;
        }

        public /* synthetic */ TypeResolutionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "typeCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "<init>", "(Ljava/util/List;)V", "getTypeCandidates", "()Ljava/util/List;", "resolve"})
        public static final class Ambiguity
        extends TypeResolutionResult {
            @NotNull
            private final List<TypeCandidate> typeCandidates;

            public Ambiguity(@NotNull List<TypeCandidate> typeCandidates) {
                Intrinsics.checkNotNullParameter(typeCandidates, (String)"typeCandidates");
                super(null);
                this.typeCandidates = typeCandidates;
            }

            @NotNull
            public final List<TypeCandidate> getTypeCandidates() {
                return this.typeCandidates;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "typeCandidate", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;)V", "getTypeCandidate", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "resolve"})
        public static final class Resolved
        extends TypeResolutionResult {
            @NotNull
            private final TypeCandidate typeCandidate;

            public Resolved(@NotNull TypeCandidate typeCandidate) {
                Intrinsics.checkNotNullParameter((Object)typeCandidate, (String)"typeCandidate");
                super(null);
                this.typeCandidate = typeCandidate;
            }

            @NotNull
            public final TypeCandidate getTypeCandidate() {
                return this.typeCandidate;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Unresolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "<init>", "()V", "resolve"})
        public static final class Unresolved
        extends TypeResolutionResult {
            @NotNull
            public static final Unresolved INSTANCE = new Unresolved();

            private Unresolved() {
                super(null);
            }
        }
    }
}

