/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.AnnotationTargetUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.resolve.AnnotationTargetLists;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u0012\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J>\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JO\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0002\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\u0010\u0001(\u0000J*\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020&2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u00101\u001a\u00020\n2\u0006\u00102\u001a\u0002032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u00104\u001a\u00020#*\u00020\u00142\u0006\u00105\u001a\u000206H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002090 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0004\n\u00020&\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "deprecatedClassId", "Lorg/jetbrains/kotlin/name/FqName;", "deprecatedSinceKotlinClassId", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "reportIfMfvc", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "hint", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkMultiFieldValueClassAnnotationRestrictions", "checkAnnotationTarget", "checkAnnotationUseSiteTarget", "annotated", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "applicableTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkPropertyGetter", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory1;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkDeprecatedCalls", "deprecatedSinceKotlin", "deprecated", "checkDeclaredRepeatedAnnotations", "annotationContainer", "checkAllRepeatedAnnotations", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkRepeatedAnnotationsInProperty", "property", "checkPossibleMigrationToPropertyOrField", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "requiresMigrationToPropertyOrFieldWarning", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "JAVA_LANG_PACKAGE", "STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION", "Lorg/jetbrains/kotlin/name/ClassId;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n+ 2 TypeExpansionUtils.kt\norg/jetbrains/kotlin/fir/resolve/TypeExpansionUtilsKt\n+ 3 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,529:1\n237#2:530\n75#3,15:531\n92#3:548\n13472#4,2:546\n1761#5,3:549\n1761#5,3:552\n1563#5:555\n1634#5,3:556\n*S KotlinDebug\n*F\n+ 1 FirAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationChecker\n*L\n430#1:530\n430#1:531,15\n430#1:548\n430#1:546,2\n178#1:549,3\n186#1:552,3\n441#1:555\n441#1:556,3\n*E\n"})
public final class FirAnnotationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAnnotationChecker INSTANCE = new FirAnnotationChecker();
    @NotNull
    private static final FqName deprecatedClassId = new FqName("kotlin.Deprecated");
    @NotNull
    private static final FqName deprecatedSinceKotlinClassId = new FqName("kotlin.DeprecatedSinceKotlin");
    @NotNull
    private static final FqName JAVA_LANG_PACKAGE = new FqName("java.lang");
    @NotNull
    private static final Set<ClassId> STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION;

    private FirAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (declaration2 instanceof FirDanglingModifierList) {
                return;
            }
            this.checkAnnotationContainer(declaration2, context2, reporter);
            if (!(declaration2 instanceof FirCallableDeclaration)) break block2;
            FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)declaration2).getReceiverParameter();
            if (firReceiverParameter != null) {
                FirReceiverParameter it = firReceiverParameter;
                boolean bl2 = false;
                INSTANCE.checkAnnotationContainer(it, context2, reporter);
            }
        }
    }

    private final void checkAnnotationContainer(FirAnnotationContainer declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirReceiverParameter receiverParameter;
        FirAnnotation deprecated = null;
        FirAnnotation deprecatedSinceKotlin = null;
        for (FirAnnotation annotation : declaration2.getAnnotations()) {
            FqName fqName;
            if (CallableIdUtilsKt.fqName(annotation, context2.getSession()) == null) continue;
            if (Intrinsics.areEqual((Object)fqName, (Object)deprecatedClassId)) {
                deprecated = annotation;
            } else if (Intrinsics.areEqual((Object)fqName, (Object)deprecatedSinceKotlinClassId)) {
                deprecatedSinceKotlin = annotation;
            }
            this.checkAnnotationTarget(declaration2, annotation, context2, reporter);
        }
        if (declaration2 instanceof FirCallableDeclaration && (receiverParameter = ((FirCallableDeclaration)declaration2).getReceiverParameter()) != null) {
            for (FirAnnotation receiverAnnotation : receiverParameter.getAnnotations()) {
                this.reportIfMfvc(context2, reporter, receiverAnnotation, "receivers", FirTypeUtilsKt.getConeType(receiverParameter.getTypeRef()));
            }
        }
        if (deprecatedSinceKotlin != null) {
            this.checkDeprecatedCalls(deprecatedSinceKotlin, deprecated, context2, reporter);
        }
        this.checkDeclaredRepeatedAnnotations(declaration2, context2, reporter);
        if (declaration2 instanceof FirCallableDeclaration) {
            if (declaration2 instanceof FirProperty) {
                this.checkRepeatedAnnotationsInProperty((FirProperty)declaration2, context2, reporter);
            }
            if (declaration2 instanceof FirValueParameter) {
                this.checkPossibleMigrationToPropertyOrField((FirValueParameter)declaration2, context2, reporter);
            }
            KtSourceElement ktSourceElement = ((FirCallableDeclaration)declaration2).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind) {
                KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)declaration2).getReturnTypeRef().getSource();
                if ((ktSourceElement2 != null ? ktSourceElement2.getKind() : null) instanceof KtRealSourceElementKind) {
                    this.checkAllRepeatedAnnotations(((FirCallableDeclaration)declaration2).getReturnTypeRef(), context2, reporter);
                }
            }
        } else if (declaration2 instanceof FirTypeAlias) {
            this.checkAllRepeatedAnnotations(((FirTypeAlias)declaration2).getExpandedTypeRef(), context2, reporter);
        }
    }

    private final void reportIfMfvc(CheckerContext context2, DiagnosticReporter reporter, FirAnnotation annotation, String hint, ConeKotlinType type2) {
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(type2, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_ILLEGAL_MULTI_FIELD_VALUE_CLASS_TYPED_TARGET(), (Object)hint, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkMultiFieldValueClassAnnotationRestrictions(FirAnnotationContainer declaration2, FirAnnotation annotation, CheckerContext context2, DiagnosticReporter reporter) {
        Pair pair;
        AnnotationUseSiteTarget annotationUseSiteTarget = annotation.getUseSiteTarget();
        switch (annotationUseSiteTarget == null ? -1 : WhenMappings.$EnumSwitchMapping$0[annotationUseSiteTarget.ordinal()]) {
            case 1: {
                Object object = declaration2 instanceof FirBackingField ? (FirBackingField)declaration2 : null;
                if (object == null || (object = ((FirBackingField)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"fields", (Object)object);
                break;
            }
            case 2: {
                Object object = declaration2 instanceof FirBackingField ? (FirBackingField)declaration2 : null;
                if (object == null || (object = ((FirBackingField)object).getPropertySymbol()) == null || (object = ((FirPropertySymbol)object).getDelegate()) == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"delegate fields", (Object)object);
                break;
            }
            case 3: {
                Object object = declaration2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)declaration2 : null;
                if (object == null || (object = ((FirCallableDeclaration)object).getReceiverParameter()) == null || (object = ((FirReceiverParameter)object).getTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                    return;
                }
                pair = TuplesKt.to((Object)"receivers", (Object)object);
                break;
            }
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (declaration2 instanceof FirProperty && !((FirProperty)declaration2).isLocal()) {
                    Set<KotlinTarget> allowedAnnotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context2.getSession());
                    if (Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)declaration2), (Object)true) && allowedAnnotationTargets.contains((Object)KotlinTarget.VALUE_PARAMETER)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.PROPERTY)) {
                        return;
                    }
                    if (allowedAnnotationTargets.contains((Object)KotlinTarget.FIELD)) {
                        pair = TuplesKt.to((Object)"fields", (Object)FirTypeUtilsKt.getConeType(((FirProperty)declaration2).getReturnTypeRef()));
                        break;
                    }
                    return;
                }
                if (declaration2 instanceof FirField) {
                    pair = TuplesKt.to((Object)"fields", (Object)FirTypeUtilsKt.getConeType(((FirField)declaration2).getReturnTypeRef()));
                    break;
                }
                if (declaration2 instanceof FirValueParameter) {
                    pair = TuplesKt.to((Object)"parameters", (Object)FirTypeUtilsKt.getConeType(((FirValueParameter)declaration2).getReturnTypeRef()));
                    break;
                }
                if (declaration2 instanceof FirVariable) {
                    pair = TuplesKt.to((Object)"variables", (Object)FirTypeUtilsKt.getConeType(((FirVariable)declaration2).getReturnTypeRef()));
                    break;
                }
                if (declaration2 instanceof FirPropertyAccessor && ((FirPropertyAccessor)declaration2).isGetter() && FirAnnotationChecker.checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers((FirPropertyAccessor)declaration2)) {
                    pair = TuplesKt.to((Object)"getters", (Object)FirTypeUtilsKt.getConeType(((FirPropertyAccessor)declaration2).getReturnTypeRef()));
                    break;
                }
                return;
            }
            case 10: {
                throw new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        String hint = (String)pair2.component1();
        ConeKotlinType type2 = (ConeKotlinType)pair2.component2();
        this.reportIfMfvc(context2, reporter, annotation, hint, type2);
    }

    private final void checkAnnotationTarget(FirAnnotationContainer declaration2, FirAnnotation annotation, CheckerContext context2, DiagnosticReporter reporter) {
        Object targetDescription;
        AnnotationTargetList actualTargets = FirHelpersKt.getActualTargetList(declaration2);
        Set<KotlinTarget> applicableTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context2.getSession());
        AnnotationUseSiteTarget useSiteTarget2 = annotation.getUseSiteTarget();
        if (useSiteTarget2 != null) {
            this.checkAnnotationUseSiteTarget(declaration2, annotation, useSiteTarget2, applicableTargets, context2, reporter);
        }
        if (FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget2, actualTargets.getDefaultTargets()) || FirAnnotationChecker.checkAnnotationTarget$check(applicableTargets, useSiteTarget2, actualTargets.getCanBeSubstituted()) || FirAnnotationChecker.checkAnnotationTarget$checkWithUseSiteTargets(useSiteTarget2, actualTargets, applicableTargets)) {
            if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClasses)) {
                this.checkMultiFieldValueClassAnnotationRestrictions(declaration2, annotation, context2, reporter);
            }
            return;
        }
        Object object = (KotlinTarget)((Object)kotlin.collections.CollectionsKt.firstOrNull(actualTargets.getDefaultTargets()));
        if (object == null || (object = object.getDescription()) == null) {
            object = targetDescription = "unidentified target";
        }
        if (declaration2 instanceof FirBackingField && actualTargets == AnnotationTargetLists.INSTANCE.getT_MEMBER_PROPERTY_IN_ANNOTATION() && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidFieldAnnotationsOnAnnotationParameters)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WARNING(), targetDescription, applicableTargets, (DiagnosticContext)context2, null, 32, null);
        } else if (useSiteTarget2 != null) {
            if (useSiteTarget2 != AnnotationUseSiteTarget.ALL) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), targetDescription, (Object)useSiteTarget2.getRenderName(), applicableTargets, (DiagnosticContext)context2, null, 64, null);
            }
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), targetDescription, applicableTargets, (DiagnosticContext)context2, null, 32, null);
        }
    }

    private final void checkAnnotationUseSiteTarget(FirAnnotationContainer annotated, FirAnnotation annotation, AnnotationUseSiteTarget target, Set<? extends KotlinTarget> applicableTargets, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement ktSourceElement = annotation.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.FromUseSiteTarget.INSTANCE)) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 5: 
            case 6: {
                KtDiagnosticFactory1<String> ktDiagnosticFactory1;
                boolean bl2 = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitUseSiteGetTargetAnnotations);
                if (bl2) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY();
                } else if (!bl2) {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY_WARNING();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.checkPropertyGetter(annotated, annotation, target, context2, reporter, ktDiagnosticFactory1);
                break;
            }
            case 1: {
                FirPropertySymbol propertySymbol;
                if (!(annotated instanceof FirBackingField) || (propertySymbol = ((FirBackingField)annotated).getPropertySymbol()).getDelegateFieldSymbol() == null || DeclarationAttributesKt.getHasBackingField(propertySymbol)) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 2: {
                if (!(annotated instanceof FirBackingField) || ((FirBackingField)annotated).getPropertySymbol().getDelegateFieldSymbol() != null) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 7: 
            case 9: {
                if (this.checkPropertyGetter(annotated, annotation, target, context2, reporter, FirErrors.INSTANCE.getINAPPLICABLE_TARGET_ON_PROPERTY()) || ((FirProperty)annotated).isVar()) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_TARGET_PROPERTY_IMMUTABLE(), (Object)target.getRenderName(), (DiagnosticContext)context2, null, 16, null);
                break;
            }
            case 8: {
                if (annotated instanceof FirValueParameter) {
                    FirDeclaration container = (FirDeclaration)kotlin.collections.CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                    if (container instanceof FirConstructor && ((FirConstructor)container).isPrimary()) {
                        KtSourceElement ktSourceElement2 = ((FirValueParameter)annotated).getSource();
                        if (ktSourceElement2 != null ? LightTreePositioningStrategiesKt.hasValOrVar(ktSourceElement2) : false) break;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION_TARGET(), (Object)target.getRenderName(), (DiagnosticContext)context2, null, 16, null);
                        break;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context2, null, 8, null);
                    break;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_PARAM_TARGET(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 4: {
                if (annotated instanceof FirFile) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_FILE_TARGET(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
            case 3: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"declaration", (Object)target.getRenderName(), applicableTargets, (DiagnosticContext)context2, null, 64, null);
                break;
            }
            case 10: {
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AnnotationAllUseSiteTarget)) {
                    FirAnnotationContainer firAnnotationContainer = annotated;
                    if (firAnnotationContainer instanceof FirValueParameter) {
                        if (ClassMembersKt.getCorrespondingProperty((FirValueParameter)annotated) != null) break;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_ALL_TARGET(), (DiagnosticContext)context2, null, 8, null);
                        break;
                    }
                    if (firAnnotationContainer instanceof FirProperty) {
                        if (((FirProperty)annotated).isLocal()) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_ALL_TARGET(), (DiagnosticContext)context2, null, 8, null);
                            break;
                        }
                        if (applicableTargets.contains((Object)KotlinTarget.PROPERTY)) break;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"property", (Object)target.getRenderName(), applicableTargets, (DiagnosticContext)context2, null, 64, null);
                        break;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_ALL_TARGET(), (DiagnosticContext)context2, null, 8, null);
                    break;
                }
                if (annotated instanceof FirValueParameter && ClassMembersKt.getCorrespondingProperty((FirValueParameter)annotated) != null) break;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.AnnotationAllUseSiteTarget), (Object)context2.getLanguageVersionSettings()), (DiagnosticContext)context2, null, 16, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean checkPropertyGetter(FirAnnotationContainer annotated, FirAnnotation annotation, AnnotationUseSiteTarget target, CheckerContext context2, DiagnosticReporter reporter, KtDiagnosticFactory1<String> diagnostic) {
        boolean isReport;
        boolean bl2 = isReport = !(annotated instanceof FirProperty) || ((FirProperty)annotated).isLocal();
        if (isReport) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), diagnostic, (Object)target.getRenderName(), (DiagnosticContext)context2, null, 16, null);
        }
        return isReport;
    }

    private final void checkDeprecatedCalls(FirAnnotation deprecatedSinceKotlin, FirAnnotation deprecated, CheckerContext context2, DiagnosticReporter reporter) {
        FirFile closestFirFile = context2.getContainingFile();
        if (closestFirFile != null && !UtilsKt.getPackageFqName(closestFirFile).startsWith(StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE().shortName())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE(), (DiagnosticContext)context2, null, 8, null);
        }
        if (deprecated == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED(), (DiagnosticContext)context2, null, 8, null);
        } else {
            Map<Name, FirExpression> argumentMapping2 = deprecated.getArgumentMapping().getMapping();
            for (Name name2 : argumentMapping2.keySet()) {
                if (!Intrinsics.areEqual((Object)name2.getIdentifier(), (Object)"level")) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)deprecatedSinceKotlin.getSource(), FirErrors.INSTANCE.getDEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL(), (DiagnosticContext)context2, null, 8, null);
                break;
            }
        }
    }

    private final void checkDeclaredRepeatedAnnotations(FirAnnotationContainer annotationContainer, CheckerContext context2, DiagnosticReporter reporter) {
        Map annotationSources = CollectionsKt.keysToMap((Iterable)annotationContainer.getAnnotations(), FirAnnotationChecker::checkDeclaredRepeatedAnnotations$lambda$3);
        FirAnnotationHelpersKt.checkRepeatedAnnotation(annotationContainer, annotationContainer.getAnnotations(), context2, reporter, annotationSources, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAllRepeatedAnnotations(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$forEachExpandedType$iv;
        Map annotationSources = CollectionsKt.keysToMap((Iterable)typeRef.getAnnotations(), FirAnnotationChecker::checkAllRepeatedAnnotations$lambda$4);
        KtSourceElement useSiteSource = typeRef.getSource();
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType(typeRef);
        FirSession session$iv = context2.getSession();
        boolean $i$f$forEachExpandedType = false;
        void $this$forEachType$iv$iv = $this$forEachExpandedType$iv;
        boolean $i$f$forEachType = false;
        Object[] objectArray = new ConeKotlinType[]{$this$forEachType$iv$iv};
        List stack$iv$iv = kotlin.collections.CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)stack$iv$iv).isEmpty()) {
            ConeKotlinType next$iv$iv;
            ConeKotlinType it$iv = (ConeKotlinType)AddToStdlibKt.popLast(stack$iv$iv);
            boolean bl2 = false;
            ConeKotlinType type2 = next$iv$iv = TypeExpansionUtilsKt.fullyExpandedType$default(it$iv, session$iv, null, 2, null);
            boolean bl3 = false;
            FirAnnotationHelpersKt.checkRepeatedAnnotation(null, CustomAnnotationTypeAttributeKt.getTypeAnnotations(type2), context2, reporter, annotationSources, useSiteSource);
            ConeKotlinType coneKotlinType2 = next$iv$iv;
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                stack$iv$iv.add(((ConeFlexibleType)next$iv$iv).getLowerBound());
                stack$iv$iv.add(((ConeFlexibleType)next$iv$iv).getUpperBound());
                continue;
            }
            if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                stack$iv$iv.add(((ConeDefinitelyNotNullType)next$iv$iv).getOriginal());
                continue;
            }
            if (coneKotlinType2 instanceof ConeIntersectionType) {
                stack$iv$iv.addAll(((ConeIntersectionType)next$iv$iv).getIntersectedTypes());
                continue;
            }
            ConeTypeProjection[] $this$forEach$iv$iv$iv = next$iv$iv.getTypeArguments();
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv$iv$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ConeTypeProjection element$iv$iv$iv;
                ConeTypeProjection it$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i2];
                boolean bl4 = false;
                if (!(it$iv$iv instanceof ConeKotlinTypeProjection)) continue;
                stack$iv$iv.add(((ConeKotlinTypeProjection)it$iv$iv).getType());
            }
        }
    }

    private final void checkRepeatedAnnotationsInProperty(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        Pair[] pairArray = new Pair[3];
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        pairArray[0] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_GETTER), firPropertyAccessor != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor) : null);
        FirPropertyAccessor firPropertyAccessor2 = property2.getSetter();
        pairArray[1] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.PROPERTY_SETTER), firPropertyAccessor2 != null ? FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(firPropertyAccessor2) : null);
        Object object = property2.getSetter();
        pairArray[2] = TuplesKt.to((Object)((Object)AnnotationUseSiteTarget.SETTER_PARAMETER), FirAnnotationChecker.checkRepeatedAnnotationsInProperty$getAnnotationTypes(object != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null ? (FirValueParameter)kotlin.collections.CollectionsKt.single((List)object) : null));
        Map propertyAnnotations = MapsKt.mapOf((Pair[])pairArray);
        boolean isError = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitRepeatedUseSiteTargetAnnotations);
        for (FirAnnotation annotation : property2.getAnnotations()) {
            List existingAnnotations;
            AnnotationUseSiteTarget useSiteTarget2;
            AnnotationUseSiteTarget annotationUseSiteTarget = annotation.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                annotationUseSiteTarget = FirAnnotationHelpersKt.getDefaultUseSiteTarget(property2, annotation, context2);
            }
            if ((List)propertyAnnotations.get((Object)(useSiteTarget2 = annotationUseSiteTarget)) == null || !existingAnnotations.contains(FirTypeUtilsKt.getConeType(annotation.getAnnotationTypeRef())) || FirAnnotationHelpersKt.isRepeatable(annotation, context2.getSession())) continue;
            KtDiagnosticFactory0 factory2 = isError ? FirErrors.INSTANCE.getREPEATED_ANNOTATION() : FirErrors.INSTANCE.getREPEATED_ANNOTATION_WARNING();
            KtSourceElement ktSourceElement = annotation.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), factory2, (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkPossibleMigrationToPropertyOrField(FirValueParameter parameter2, CheckerContext context2, DiagnosticReporter reporter) {
        FirSession session = context2.getSession();
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.AnnotationDefaultTargetMigrationWarning) || FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.PropertyParamAnnotationDefaultTargetMode)) {
            return;
        }
        FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(parameter2);
        if (firProperty == null) {
            return;
        }
        FirProperty correspondingProperty = firProperty;
        for (FirAnnotation annotation : parameter2.getAnnotations()) {
            FirClass containingClass;
            if (annotation.getUseSiteTarget() != null || !this.requiresMigrationToPropertyOrFieldWarning(annotation, session)) continue;
            Set<AnnotationUseSiteTarget> allowedTargets = AnnotationTargetUtilsKt.useSiteTargetsFromMetaAnnotation(annotation, session);
            boolean propertyAllowed = allowedTargets.contains((Object)AnnotationUseSiteTarget.PROPERTY);
            boolean fieldAllowed = allowedTargets.contains((Object)AnnotationUseSiteTarget.FIELD);
            if (!propertyAllowed && !fieldAllowed) continue;
            if (propertyAllowed) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_WILL_BE_APPLIED_ALSO_TO_PROPERTY_OR_FIELD(), (Object)AnnotationUseSiteTarget.PROPERTY.getRenderName(), (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            if (correspondingProperty.getBackingField() == null) continue;
            Object object = kotlin.collections.CollectionsKt.getOrNull(context2.getContainingDeclarations(), (int)(context2.getContainingDeclarations().size() - 2));
            FirClass firClass = containingClass = object instanceof FirClass ? (FirClass)object : null;
            if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_WILL_BE_APPLIED_ALSO_TO_PROPERTY_OR_FIELD(), (Object)AnnotationUseSiteTarget.FIELD.getRenderName(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean requiresMigrationToPropertyOrFieldWarning(FirAnnotation $this$requiresMigrationToPropertyOrFieldWarning, FirSession session) {
        ClassId classId;
        FirClassLikeSymbol<?> symbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = symbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol($this$requiresMigrationToPropertyOrFieldWarning, session);
        ClassId classId2 = classId = firClassLikeSymbol != null ? firClassLikeSymbol.getClassId() : null;
        if (kotlin.collections.CollectionsKt.contains((Iterable)STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION, (Object)classId)) {
            return false;
        }
        FirOptInUsageBaseChecker $this$requiresMigrationToPropertyOrFieldWarning_u24lambda_u247 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl2 = false;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = symbol;
        return !(firClassLikeSymbol2 != null ? $this$requiresMigrationToPropertyOrFieldWarning_u24lambda_u247.isExperimentalMarker(firClassLikeSymbol2, session) : false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkMultiFieldValueClassAnnotationRestrictions$hasNoReceivers(FirPropertyAccessor $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers) {
        if (!$this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getContextParameters().isEmpty()) return false;
        FirReceiverParameter firReceiverParameter = $this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getReceiverParameter();
        if ((firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null) != null) return false;
        if ($this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol().getResolvedReceiverTypeRef() != null) return false;
        if (!$this$checkMultiFieldValueClassAnnotationRestrictions_u24hasNoReceivers.getPropertySymbol().getResolvedContextParameters().isEmpty()) return false;
        return true;
    }

    private static final boolean checkAnnotationTarget$check(Set<? extends KotlinTarget> applicableTargets, AnnotationUseSiteTarget useSiteTarget2, List<? extends KotlinTarget> targets) {
        boolean bl2;
        block3: {
            Iterable $this$any$iv = targets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl3 = false;
                    if (!(applicableTargets.contains((Object)it) && (useSiteTarget2 == null || KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget2) == it))) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private static final boolean checkAnnotationTarget$checkWithUseSiteTargets(AnnotationUseSiteTarget useSiteTarget2, AnnotationTargetList actualTargets, Set<? extends KotlinTarget> applicableTargets) {
        boolean bl2;
        block4: {
            if (useSiteTarget2 == null) {
                return false;
            }
            KotlinTarget useSiteMapping = KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget2);
            Iterable $this$any$iv = actualTargets.getOnlyWithUseSiteTarget();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinTarget it = (KotlinTarget)((Object)element$iv);
                    boolean bl3 = false;
                    if (!(applicableTargets.contains((Object)it) && it == useSiteMapping)) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private static final KtSourceElement checkDeclaredRepeatedAnnotations$lambda$3(FirAnnotation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSource();
    }

    private static final KtSourceElement checkAllRepeatedAnnotations$lambda$4(FirAnnotation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSource();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConeKotlinType> checkRepeatedAnnotationsInProperty$getAnnotationTypes(FirAnnotationContainer $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes) {
        List list;
        Object object = $this$checkRepeatedAnnotationsInProperty_u24getAnnotationTypes;
        if (object != null && (object = object.getAnnotations()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirAnnotation firAnnotation = (FirAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    static {
        Object[] objectArray = new ClassId[6];
        objectArray[0] = OptInNames.INSTANCE.getOPT_IN_CLASS_ID();
        objectArray[1] = StandardClassIds.Annotations.INSTANCE.getDeprecated();
        objectArray[2] = StandardClassIds.Annotations.INSTANCE.getDeprecatedSinceKotlin();
        objectArray[3] = StandardClassIds.Annotations.INSTANCE.getSuppress();
        Name name2 = Name.identifier("Deprecated");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        objectArray[4] = new ClassId(JAVA_LANG_PACKAGE, name2);
        Name name3 = Name.identifier("SuppressWarnings");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        objectArray[5] = new ClassId(JAVA_LANG_PACKAGE, name3);
        STANDARD_ANNOTATION_IDS_WITHOUT_NECESSARY_MIGRATION = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            try {
                nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.ALL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

