/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.KaConstantValueForAnnotation;
import org.jetbrains.kotlin.analysis.api.KaInitializerValue;
import org.jetbrains.kotlin.analysis.api.KaNonConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a0\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\u0015H\u0000\u00a8\u0006\u0017"}, d2={"unwrap", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "computeImportableName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "asKaInitializerValue", "Lorg/jetbrains/kotlin/analysis/api/KaInitializerValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "builder", "Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;", "forAnnotationDefaultValue", "", "processEqualsFunctions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nfirUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/FirUtilsKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,117:1\n49#2:118\n24#2:119\n24#2:120\n43#3:121\n*S KotlinDebug\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/FirUtilsKt\n*L\n68#1:118\n71#1:119\n72#1:120\n102#1:121\n*E\n"})
public final class FirUtilsKt {
    @NotNull
    public static final PsiElement unwrap(@NotNull PsiElement $this$unwrap) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        return $this$unwrap instanceof KtExpression ? (PsiElement)FirUtilsKt.unwrap((KtExpression)$this$unwrap) : $this$unwrap;
    }

    @NotNull
    public static final KtExpression unwrap(@NotNull KtExpression $this$unwrap) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        KtExpression ktExpression3 = $this$unwrap;
        if (ktExpression3 instanceof KtLabeledExpression) {
            KtExpression ktExpression4 = ((KtLabeledExpression)$this$unwrap).getBaseExpression();
            ktExpression2 = ktExpression4 != null ? FirUtilsKt.unwrap(ktExpression4) : null;
        } else if (ktExpression3 instanceof KtAnnotatedExpression) {
            KtExpression ktExpression5 = ((KtAnnotatedExpression)$this$unwrap).getBaseExpression();
            ktExpression2 = ktExpression5 != null ? FirUtilsKt.unwrap(ktExpression5) : null;
        } else if (ktExpression3 instanceof KtFunctionLiteral) {
            PsiElement psiElement = ((KtFunctionLiteral)$this$unwrap).getParent();
            KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
            ktExpression2 = ktLambdaExpression != null ? FirUtilsKt.unwrap(ktLambdaExpression) : null;
        } else {
            ktExpression2 = ktExpression = $this$unwrap;
        }
        if (ktExpression2 == null) {
            ktExpression = $this$unwrap;
        }
        return ktExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final FqName computeImportableName(@NotNull FirCallableSymbol<?> $this$computeImportableName) {
        block9: {
            FirClassLikeSymbol<?> containingClass;
            block10: {
                boolean $i$f$isStatic;
                FirCallableSymbol<?> $this$isStatic$iv;
                block8: {
                    Intrinsics.checkNotNullParameter($this$computeImportableName, (String)"<this>");
                    if ($this$computeImportableName.getCallableId().isLocal()) {
                        return null;
                    }
                    if ($this$computeImportableName.getOrigin() instanceof FirDeclarationOrigin.SamConstructor) {
                        return $this$computeImportableName.getCallableId().asSingleFqName();
                    }
                    ClassId classId = $this$computeImportableName.getCallableId().getClassId();
                    if (classId == null) {
                        return $this$computeImportableName.getCallableId().asSingleFqName();
                    }
                    ClassId containingClassId = classId;
                    FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$computeImportableName);
                    if (firClassLikeSymbol == null) {
                        return null;
                    }
                    containingClass = firClassLikeSymbol;
                    if ($this$computeImportableName instanceof FirConstructorSymbol) {
                        FirClassLikeSymbol<?> $this$isInner$iv = containingClass;
                        boolean $i$f$isInner = false;
                        if ($this$isInner$iv.getRawStatus().isInner()) return null;
                        FqName fqName = containingClassId.asSingleFqName();
                        return fqName;
                    }
                    if (!(containingClass.getOrigin() instanceof FirDeclarationOrigin.Java)) break block8;
                    $this$isStatic$iv = $this$computeImportableName;
                    $i$f$isStatic = false;
                    if ($this$isStatic$iv.getRawStatus().isStatic()) break block9;
                }
                if (FirHelpersKt.getClassKind(containingClass) != ClassKind.ENUM_CLASS) break block10;
                $this$isStatic$iv = $this$computeImportableName;
                $i$f$isStatic = false;
                if ($this$isStatic$iv.getRawStatus().isStatic()) break block9;
            }
            if (FirHelpersKt.getClassKind(containingClass) != ClassKind.OBJECT) return null;
        }
        boolean bl2 = true;
        boolean canBeImported = bl2;
        if (!canBeImported) return null;
        FqName fqName = $this$computeImportableName.getCallableId().asSingleFqName();
        return fqName;
    }

    @NotNull
    public static final KaInitializerValue asKaInitializerValue(@NotNull FirExpression $this$asKaInitializerValue, @NotNull KaSymbolByFirBuilder builder2, boolean forAnnotationDefaultValue) {
        KaAnnotationValue annotationConstantValue;
        Intrinsics.checkNotNullParameter((Object)$this$asKaInitializerValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        PsiElement psiElement = UtilsKt.getPsi($this$asKaInitializerValue);
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        KaConstantValue evaluated = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue($this$asKaInitializerValue);
        KaInitializerValue kaInitializerValue = evaluated == null ? (forAnnotationDefaultValue ? ((annotationConstantValue = FirAnnotationValueConverter.INSTANCE.toConstantValue($this$asKaInitializerValue, builder2)) != null ? (KaInitializerValue)new KaConstantValueForAnnotation(annotationConstantValue, ktExpression) : (KaInitializerValue)new KaNonConstantInitializerValue(ktExpression)) : (KaInitializerValue)new KaNonConstantInitializerValue(ktExpression)) : (KaInitializerValue)new KaConstantInitializerValue(evaluated, ktExpression);
        return kaInitializerValue;
    }

    public static final void processEqualsFunctions(@NotNull FirEqualityOperatorCall $this$processEqualsFunctions, @NotNull FirSession session, @NotNull KaFirSession analysisSession, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter((Object)$this$processEqualsFunctions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        FirCall $this$arguments$iv = $this$processEqualsFunctions;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return;
        }
        FirExpression lhs = firExpression;
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(FirTypeUtilsKt.getResolvedType(lhs), session, analysisSession.getScopeSessionFor(analysisSession.getFirSession$analysis_api_fir()), CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
        if (firTypeScope == null) {
            return;
        }
        FirTypeScope scope = firTypeScope;
        scope.processFunctionsByName(OperatorNameConventions.EQUALS, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirUtilsKt.processEqualsFunctions$lambda$0(processor, arg_0)));
    }

    private static final Unit processEqualsFunctions$lambda$0(Function1 $processor, FirNamedFunctionSymbol functionSymbol) {
        Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
        FirValueParameterSymbol parameterSymbol = (FirValueParameterSymbol)CollectionsKt.singleOrNull(functionSymbol.getValueParameterSymbols());
        if (parameterSymbol != null && ConeBuiltinTypeUtilsKt.isNullableAny(parameterSymbol.getResolvedReturnType())) {
            $processor.invoke((Object)functionSymbol);
        }
        return Unit.INSTANCE;
    }
}

