/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeInfoImpl
implements ChangeInfo {
    @Nullable
    private final ASTNode myOldChild;
    @Nullable
    private final ASTNode myNewChild;
    private final int myOffset;
    private final int myOldLength;
    private final int myNewLength;

    ChangeInfoImpl(@Nullable ASTNode oldChild, @Nullable ASTNode newChild, int offset, int oldLength) {
        this.myOldChild = oldChild;
        this.myNewChild = newChild;
        this.myOffset = offset;
        this.myOldLength = oldLength;
        this.myNewLength = newChild != null ? newChild.getTextLength() : 0;
    }

    public ASTNode getOldChildNode() {
        return this.myOldChild;
    }

    public int getOffsetInParent() {
        return this.myOffset;
    }

    public int getOldLength() {
        return this.myOldLength;
    }

    public int getNewLength() {
        return this.myNewLength;
    }

    @Nullable
    public ASTNode getNewChild() {
        return this.myNewChild;
    }

    @Override
    public int getChangeType() {
        if (this.myOldChild == this.myNewChild) {
            return 3;
        }
        if (this.myOldChild != null) {
            return this.myNewChild == null ? 1 : 2;
        }
        return 0;
    }

    public String toString() {
        return this.myOldChild + "(" + this.myOldLength + ")->" + this.myNewChild + "(" + this.myNewLength + ") at " + this.myOffset;
    }

    int getLengthDelta() {
        return this.myNewLength - this.myOldLength;
    }

    ASTNode getAffectedChild() {
        return this.myNewChild != null ? this.myNewChild : this.myOldChild;
    }

    void fireEvent(int parentStart, PsiFile file2, ASTNode parent2) {
        PsiTreeChangeEventImpl e2 = ChangeInfoImpl.createEvent(file2, this.myOffset + parentStart);
        if (this.myOldChild == this.myNewChild && this.myNewChild != null) {
            ChangeInfoImpl.childrenChanged(e2, this.myNewChild, this.myOldLength);
        } else if (this.myOldChild != null && this.myNewChild != null) {
            this.childReplaced(e2, this.myOldChild, this.myNewChild, parent2);
        } else if (this.myOldChild != null) {
            this.childRemoved(e2, this.myOldChild, parent2);
        } else if (this.myNewChild != null) {
            ChangeInfoImpl.childAdded(e2, this.myNewChild, parent2);
        }
    }

    @NotNull
    static PsiTreeChangeEventImpl createEvent(PsiFile file2, int offset) {
        PsiTreeChangeEventImpl e2 = new PsiTreeChangeEventImpl(file2.getManager());
        e2.setFile(file2);
        e2.setOffset(offset);
        PsiTreeChangeEventImpl psiTreeChangeEventImpl = e2;
        if (psiTreeChangeEventImpl == null) {
            ChangeInfoImpl.$$$reportNull$$$0(0);
        }
        return psiTreeChangeEventImpl;
    }

    boolean hasNoPsi() {
        return this.myOldChild != null && this.myOldChild.getPsi() == null || this.myNewChild != null && this.myNewChild.getPsi() == null;
    }

    private static void childAdded(PsiTreeChangeEventImpl e2, ASTNode child, ASTNode parent2) {
        e2.setParent(parent2.getPsi());
        e2.setChild(child.getPsi());
        ChangeInfoImpl.getPsiManagerImpl(e2).childAdded(e2);
    }

    private void childRemoved(PsiTreeChangeEventImpl e2, ASTNode child, ASTNode parent2) {
        e2.setParent(parent2.getPsi());
        e2.setChild(child.getPsi());
        e2.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerImpl(e2).childRemoved(e2);
    }

    private void childReplaced(PsiTreeChangeEventImpl e2, ASTNode oldChild, ASTNode newChild, ASTNode parent2) {
        e2.setParent(parent2.getPsi());
        e2.setOldChild(oldChild.getPsi());
        e2.setChild(newChild.getPsi());
        e2.setNewChild(newChild.getPsi());
        e2.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerImpl(e2).childReplaced(e2);
    }

    static void childrenChanged(PsiTreeChangeEventImpl e2, ASTNode parent2, int oldLength) {
        e2.setParent(parent2.getPsi());
        e2.setOldLength(oldLength);
        ChangeInfoImpl.getPsiManagerImpl(e2).childrenChanged(e2);
    }

    private static PsiManagerImpl getPsiManagerImpl(PsiTreeChangeEventImpl e2) {
        return (PsiManagerImpl)e2.getSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/tree/events/impl/ChangeInfoImpl", "createEvent"));
    }
}

