/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;

public final class FoldingGroup {
    private static final AtomicLong ourCounter = new AtomicLong();
    @NonNls
    private final String myDebugName;
    private final long myId;

    private FoldingGroup(@NonNls String debugName) {
        this.myDebugName = debugName;
        this.myId = ourCounter.incrementAndGet();
    }

    public static FoldingGroup newGroup(@NonNls String debugName) {
        return new FoldingGroup(debugName);
    }

    @ApiStatus.Internal
    public long getId() {
        return this.myId;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FoldingGroup group = (FoldingGroup)o2;
        return this.myId == group.myId;
    }

    public int hashCode() {
        return Long.hashCode(this.myId);
    }

    public String toString() {
        return this.myDebugName;
    }
}

