/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirDesignatedCompilerRequiredAnnotationsResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalStateExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0015J\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0015J\u0016\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\f\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "", "<init>", "()V", "filesWithResolvedImports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "importsAreResolved", "", "file", "useCacheForImportScope", "getUseCacheForImportScope", "()Z", "recordThatImportsAreResolved", "", "annotationResolved", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "declarationsWithAnnotationResolutionInProgress", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "declarationsWithResolvedAnnotations", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotationResolutionWasAlreadyStarted", "klass", "annotationsAreResolved", "declaration", "treatNonSourceDeclarationsAsResolved", "getTreatNonSourceDeclarationsAsResolved", "recordThatAnnotationResolutionStarted", "recordThatAnnotationsAreResolved", "resolveAnnotationsOnAnnotationIfNeeded", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "resolveAnnotationSymbol", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirCompilerRequiredAnnotationsResolveTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompilerRequiredAnnotationsResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,325:1\n101#2,12:326\n57#2:338\n113#2,3:339\n*S KotlinDebug\n*F\n+ 1 FirCompilerRequiredAnnotationsResolveTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession\n*L\n213#1:326,12\n213#1:338\n213#1:339,3\n*E\n"})
public class CompilerRequiredAnnotationsComputationSession {
    @NotNull
    private final Set<FirFile> filesWithResolvedImports = new LinkedHashSet();
    @NotNull
    private final Set<FirClassLikeDeclaration> declarationsWithAnnotationResolutionInProgress = new LinkedHashSet();
    @NotNull
    private final Set<FirAnnotationContainer> declarationsWithResolvedAnnotations = new LinkedHashSet();

    public final boolean importsAreResolved(@NotNull FirFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.filesWithResolvedImports.contains(file);
    }

    public boolean getUseCacheForImportScope() {
        return false;
    }

    public final void recordThatImportsAreResolved(@NotNull FirFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.filesWithResolvedImports.add(file)) {
            throw new IllegalStateException("Imports are resolved twice".toString());
        }
    }

    public void annotationResolved(@NotNull FirAnnotationCall annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
    }

    public final boolean annotationResolutionWasAlreadyStarted(@NotNull FirClassLikeDeclaration klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.declarationsWithAnnotationResolutionInProgress.contains(klass);
    }

    public final boolean annotationsAreResolved(@NotNull FirAnnotationContainer declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof FirFile) {
            return false;
        }
        if (this.getTreatNonSourceDeclarationsAsResolved() && declaration2 instanceof FirDeclaration && !Intrinsics.areEqual((Object)((FirDeclaration)declaration2).getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return true;
        }
        return this.declarationsWithResolvedAnnotations.contains(declaration2);
    }

    public boolean getTreatNonSourceDeclarationsAsResolved() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void recordThatAnnotationResolutionStarted(@NotNull FirClassLikeDeclaration klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        boolean wasNotStartedBefore = this.declarationsWithAnnotationResolutionInProgress.add(klass);
        String attachmentName$iv = "info.txt";
        boolean $i$f$checkWithAttachment = false;
        if (!wasNotStartedBefore) {
            void $this$checkWithAttachment_u24lambda_u241$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            boolean bl2 = false;
            String string = "Annotation resolution was already started";
            KotlinIllegalStateExceptionWithAttachments exception$iv = new KotlinIllegalStateExceptionWithAttachments(string);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv = exception$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv;
            boolean bl3 = false;
            void $this$recordThatAnnotationResolutionStarted_u24lambda_u241 = $this$checkWithAttachment_u24lambda_u241$iv;
            boolean bl4 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$recordThatAnnotationResolutionStarted_u24lambda_u241, "class", klass);
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw exception$iv;
        }
    }

    public final void recordThatAnnotationsAreResolved(@NotNull FirAnnotationContainer declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        TypeIntrinsics.asMutableCollection((Object)this.declarationsWithAnnotationResolutionInProgress).remove(declaration2);
        this.declarationsWithResolvedAnnotations.add(declaration2);
    }

    public final void resolveAnnotationsOnAnnotationIfNeeded(@NotNull FirRegularClassSymbol symbol, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        FirRegularClass regularClass = (FirRegularClass)symbol.getFir();
        if (this.annotationsAreResolved(regularClass)) {
            return;
        }
        if (regularClass.getAnnotations().isEmpty()) {
            return;
        }
        this.resolveAnnotationSymbol(symbol, scopeSession);
    }

    public void resolveAnnotationSymbol(@NotNull FirRegularClassSymbol symbol, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        DesignationState designationState = DesignationState.Companion.create(symbol, MapsKt.emptyMap(), true);
        if (designationState == null) {
            return;
        }
        DesignationState designation = designationState;
        FirDesignatedCompilerRequiredAnnotationsResolveTransformer transformer2 = new FirDesignatedCompilerRequiredAnnotationsResolveTransformer(designation.getFirstDeclaration().getModuleData().getSession(), scopeSession, this, designation);
        FirTransformerUtilKt.transformSingle((FirElement)designation.getFirstDeclaration(), transformer2, null);
    }
}

