/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"checkReservedYield", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "MESSAGE_FOR_YIELD_BEFORE_LAMBDA", "", "getMESSAGE_FOR_YIELD_BEFORE_LAMBDA", "()Ljava/lang/String;", "checkReservedYieldBeforeLambda", "element", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class ReservedCheckingKt {
    @NotNull
    private static final String MESSAGE_FOR_YIELD_BEFORE_LAMBDA = "Reserved yield block/lambda. Use 'yield() { ... }' or 'yield(fun...)'";

    public static final void checkReservedYield(@Nullable KtSimpleNameExpression expression2, @NotNull DiagnosticSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        KtSimpleNameExpression ktSimpleNameExpression = expression2;
        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null), (Object)"yield")) {
            return;
        }
        PsiElement psiElement = expression2.getIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        if (Intrinsics.areEqual((Object)identifier.getNode().getElementType(), (Object)KtTokens.IDENTIFIER) && Intrinsics.areEqual((Object)"yield", (Object)identifier.getText())) {
            sink.report(Errors.YIELD_IS_RESERVED.on(identifier, "Identifier 'yield' is reserved. Use backticks to call it: `yield`"));
        }
    }

    @NotNull
    public static final String getMESSAGE_FOR_YIELD_BEFORE_LAMBDA() {
        return MESSAGE_FOR_YIELD_BEFORE_LAMBDA;
    }

    public static final void checkReservedYieldBeforeLambda(@NotNull PsiElement element2, @NotNull DiagnosticSink sink) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            PsiElement psiElement = KtPsiUtil.getPreviousWord(element2, "yield");
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl2 = false;
            sink.report(Errors.YIELD_IS_RESERVED.on(it, MESSAGE_FOR_YIELD_BEFORE_LAMBDA));
        }
    }
}

