/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final boolean treatWarningsAsErrors;
    private final boolean reportAllWarnings;
    private final Multimap<CompilerMessageSourceLocation, Message> groupedMessages;

    public GroupingMessageCollector(@NotNull MessageCollector delegate, boolean treatWarningsAsErrors, boolean reportAllWarnings) {
        if (delegate == null) {
            GroupingMessageCollector.$$$reportNull$$$0(0);
        }
        this.groupedMessages = LinkedHashMultimap.create();
        this.delegate = delegate;
        this.treatWarningsAsErrors = treatWarningsAsErrors;
        this.reportAllWarnings = reportAllWarnings;
    }

    @Override
    public void clear() {
        this.groupedMessages.clear();
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location2) {
        if (severity == null) {
            GroupingMessageCollector.$$$reportNull$$$0(1);
        }
        if (message == null) {
            GroupingMessageCollector.$$$reportNull$$$0(2);
        }
        if (severity == CompilerMessageSeverity.OUTPUT || CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message, location2);
        } else {
            this.groupedMessages.put(location2, new Message(severity, message, location2));
        }
    }

    @Override
    public boolean hasErrors() {
        return this.delegate.hasErrors() || this.hasExplicitErrors() || this.treatWarningsAsErrors && this.hasRegularWarnings();
    }

    private boolean hasExplicitErrors() {
        return this.groupedMessages.entries().stream().anyMatch(entry -> ((Message)entry.getValue()).severity.isError());
    }

    private boolean hasRegularWarnings() {
        return this.groupedMessages.entries().stream().anyMatch(entry -> ((Message)entry.getValue()).severity.isRegularWarning());
    }

    public void flush() {
        boolean hasExplicitErrors = this.hasExplicitErrors();
        if (this.treatWarningsAsErrors && !hasExplicitErrors && this.hasRegularWarnings()) {
            this.report(CompilerMessageSeverity.ERROR, "warnings found and -Werror specified", null);
        }
        List sortedKeys = CollectionsKt.sortedWith(this.groupedMessages.keySet(), Comparator.nullsFirst(CompilerMessageLocationComparator.INSTANCE));
        for (CompilerMessageSourceLocation location2 : sortedKeys) {
            for (Message message : this.groupedMessages.get(location2)) {
                if (hasExplicitErrors && !this.reportAllWarnings && !message.severity.isError() && message.severity != CompilerMessageSeverity.STRONG_WARNING) continue;
                this.delegate.report(message.severity, message.message, message.location);
            }
        }
        this.groupedMessages.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageSourceLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location2) {
            if (severity == null) {
                Message.$$$reportNull$$$0(0);
            }
            if (message == null) {
                Message.$$$reportNull$$$0(1);
            }
            this.severity = severity;
            this.message = message;
            this.location = location2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Message other = (Message)o2;
            if (!Objects.equals(this.location, other.location)) {
                return false;
            }
            if (!this.message.equals(other.message)) {
                return false;
            }
            return this.severity == other.severity;
        }

        public int hashCode() {
            int result2 = this.severity.hashCode();
            result2 = 31 * result2 + this.message.hashCode();
            result2 = 31 * result2 + (this.location != null ? this.location.hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "[" + (Object)((Object)this.severity) + "] " + this.message + (this.location != null ? " (at " + this.location + ")" : " (no location)");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "severity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CompilerMessageLocationComparator
    implements Comparator<CompilerMessageSourceLocation> {
        public static final CompilerMessageLocationComparator INSTANCE = new CompilerMessageLocationComparator();

        private CompilerMessageLocationComparator() {
        }

        @Override
        public int compare(CompilerMessageSourceLocation o1, CompilerMessageSourceLocation o2) {
            if (o1.getColumn() == -1 && o2.getColumn() != -1) {
                return -1;
            }
            if (o1.getColumn() != -1 && o2.getColumn() == -1) {
                return 1;
            }
            if (o1.getLine() == -1 && o2.getLine() != -1) {
                return -1;
            }
            if (o1.getLine() != -1 && o2.getLine() == -1) {
                return 1;
            }
            return o1.getPath().compareTo(o2.getPath());
        }
    }
}

