/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.ClassDiscriminatorMode;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.ComposerForUnquotedLiterals;
import kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import kotlinx.serialization.json.internal.ComposersKt;
import kotlinx.serialization.json.internal.InternalJsonWriter;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n\u00a2\u0006\u0002\u0010\u000bB/\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016JR\u0010 \u001a\u0002H!\"\n\b\u0000\u0010!\u0018\u0001*\u00020\r26\u0010\"\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H!0#H\u0082\b\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0012H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010*\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010*\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020)2\u0006\u00105\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00106\u001a\u00020)2\u0006\u0010*\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010:\u001a\u00020)2\u0006\u0010*\u001a\u000203H\u0016J\u0010\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020)2\u0006\u0010*\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020)H\u0016J?\u0010A\u001a\u00020)\"\b\b\u0000\u0010!*\u00020B2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\f\u0010C\u001a\b\u0012\u0004\u0012\u0002H!0D2\b\u0010*\u001a\u0004\u0018\u0001H!H\u0016\u00a2\u0006\u0002\u0010EJ)\u0010F\u001a\u00020)\"\u0004\b\u0000\u0010!2\f\u0010C\u001a\b\u0012\u0004\u0012\u0002H!0D2\u0006\u0010*\u001a\u0002H!H\u0016\u00a2\u0006\u0002\u0010GJ\u0010\u0010H\u001a\u00020)2\u0006\u0010*\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0010\u0010K\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010L\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010M\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006N"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder;", "Lkotlinx/serialization/json/JsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "output", "Lkotlinx/serialization/json/internal/InternalJsonWriter;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "modeReuseCache", "", "(Lkotlinx/serialization/json/internal/InternalJsonWriter;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "composer", "Lkotlinx/serialization/json/internal/Composer;", "(Lkotlinx/serialization/json/internal/Composer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "forceQuoting", "", "getJson", "()Lkotlinx/serialization/json/Json;", "[Lkotlinx/serialization/json/JsonEncoder;", "polymorphicDiscriminator", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "composerAs", "T", "composerCreator", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "writer", "(Lkotlin/jvm/functions/Function2;)Lkotlinx/serialization/json/internal/Composer;", "encodeBoolean", "", "value", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescriptor", "encodeFloat", "", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "encodeInt", "encodeJsonElement", "element", "Lkotlinx/serialization/json/JsonElement;", "encodeLong", "", "encodeNull", "encodeNullableSerializableElement", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeSerializableValue", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeShort", "", "encodeString", "encodeTypeInfo", "endStructure", "shouldEncodeElementDefault", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nStreamingJsonEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingJsonEncoder.kt\nkotlinx/serialization/json/internal/StreamingJsonEncoder\n+ 2 Polymorphic.kt\nkotlinx/serialization/json/internal/PolymorphicKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n170#1,2:251\n170#1,2:253\n21#2,12:225\n35#2,13:238\n1#3:237\n*S KotlinDebug\n*F\n+ 1 StreamingJsonEncoder.kt\nkotlinx/serialization/json/internal/StreamingJsonEncoder\n*L\n161#1:251,2\n162#1:253,2\n64#1:225,12\n64#1:238,13\n64#1:237\n*E\n"})
public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    @NotNull
    private final Composer composer;
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @Nullable
    private final JsonEncoder[] modeReuseCache;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final JsonConfiguration configuration;
    private boolean forceQuoting;
    @Nullable
    private String polymorphicDiscriminator;

    public StreamingJsonEncoder(@NotNull Composer composer, @NotNull Json json, @NotNull WriteMode mode, @Nullable JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.composer = composer;
        this.json = json;
        this.mode = mode;
        this.modeReuseCache = modeReuseCache;
        this.serializersModule = this.getJson().getSerializersModule();
        this.configuration = this.getJson().getConfiguration();
        int i2 = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[i2] != null || this.modeReuseCache[i2] != this)) {
            this.modeReuseCache[i2] = this;
        }
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonEncoder(@NotNull InternalJsonWriter output, @NotNull Json json, @NotNull WriteMode mode, @NotNull JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)modeReuseCache, (String)"modeReuseCache");
        this(ComposersKt.Composer(output, json), json, mode, modeReuseCache);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public void encodeJsonElement(@NotNull JsonElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.encodeSerializableValue(JsonElementSerializer.INSTANCE, element2);
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.configuration.getEncodeDefaults();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value2) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        JsonEncoder $this$encodePolymorphically$iv = this;
        boolean $i$f$encodePolymorphically = false;
        if ($this$encodePolymorphically$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer2.serialize($this$encodePolymorphically$iv, value2);
        } else {
            SerializationStrategy<T> actualSerializer$iv;
            SerializationStrategy<T> serializationStrategy;
            String baseClassDiscriminator$iv;
            boolean bl2;
            boolean isPolymorphicSerializer$iv = serializer2 instanceof AbstractPolymorphicSerializer;
            if (isPolymorphicSerializer$iv) {
                bl2 = $this$encodePolymorphically$iv.getJson().getConfiguration().getClassDiscriminatorMode() != ClassDiscriminatorMode.NONE;
            } else {
                switch (PolymorphicKt.WhenMappings.$EnumSwitchMapping$0[$this$encodePolymorphically$iv.getJson().getConfiguration().getClassDiscriminatorMode().ordinal()]) {
                    case 1: 
                    case 2: {
                        bl2 = false;
                        break;
                    }
                    case 3: {
                        SerialKind it$iv = serializer2.getDescriptor().getKind();
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it$iv, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)it$iv, (Object)StructureKind.OBJECT.INSTANCE)) {
                            bl2 = true;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            boolean needDiscriminator$iv = bl2;
            String string2 = baseClassDiscriminator$iv = needDiscriminator$iv ? PolymorphicKt.classDiscriminator(serializer2.getDescriptor(), $this$encodePolymorphically$iv.getJson()) : null;
            if (isPolymorphicSerializer$iv) {
                AbstractPolymorphicSerializer casted$iv = (AbstractPolymorphicSerializer)serializer2;
                if (value2 == null) {
                    boolean $i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$1$iv22 = false;
                    String $i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$1$iv22 = "Value for serializer " + serializer2.getDescriptor() + " should always be non-null. Please report issue to the kotlinx.serialization tracker.";
                    throw new IllegalArgumentException($i$a$-requireNotNull-PolymorphicKt$encodePolymorphically$actualSerializer$1$iv22.toString());
                }
                SerializationStrategy<T> actual$iv = PolymorphicSerializerKt.findPolymorphicSerializer(casted$iv, $this$encodePolymorphically$iv, value2);
                if (baseClassDiscriminator$iv != null) {
                    PolymorphicKt.access$validateIfSealed(serializer2, actual$iv, baseClassDiscriminator$iv);
                }
                PolymorphicKt.checkKind(actual$iv.getDescriptor().getKind());
                Intrinsics.checkNotNull(actual$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.SerializationStrategy<T of kotlinx.serialization.json.internal.PolymorphicKt.encodePolymorphically>");
                serializationStrategy = actual$iv;
            } else {
                serializationStrategy = actualSerializer$iv = serializer2;
            }
            if (baseClassDiscriminator$iv != null) {
                String it = baseClassDiscriminator$iv;
                boolean bl4 = false;
                this.polymorphicDiscriminator = it;
            }
            actualSerializer$iv.serialize($this$encodePolymorphically$iv, value2);
        }
    }

    private final void encodeTypeInfo(SerialDescriptor descriptor2) {
        this.composer.nextItem();
        String string2 = this.polymorphicDiscriminator;
        Intrinsics.checkNotNull((Object)string2);
        this.encodeString(string2);
        this.composer.print(':');
        this.composer.space();
        this.encodeString(descriptor2.getSerialName());
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.getJson(), descriptor2);
        if (newMode.begin != '\u0000') {
            this.composer.print(newMode.begin);
            this.composer.indent();
        }
        if (this.polymorphicDiscriminator != null) {
            this.encodeTypeInfo(descriptor2);
            this.polymorphicDiscriminator = null;
        }
        if (this.mode == newMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        return this.modeReuseCache != null && (object = object[newMode.ordinal()]) != null ? (CompositeEncoder)object : (CompositeEncoder)new StreamingJsonEncoder(this.composer, this.getJson(), newMode, this.modeReuseCache);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItemIfNotFirst();
            this.composer.print(this.mode.end);
        }
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl2;
                    if (index2 % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl2 = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl2 = false;
                    }
                    this.forceQuoting = bl2;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (index2 == 0) {
                    this.forceQuoting = true;
                }
                if (index2 != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(JsonNamesMapKt.getJsonElementName(descriptor2, this.getJson(), index2));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    @Override
    public <T> void encodeNullableSerializableElement(@NotNull SerialDescriptor descriptor2, int index2, @NotNull SerializationStrategy<? super T> serializer2, @Nullable T value2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        if (value2 != null || this.configuration.getExplicitNulls()) {
            super.encodeNullableSerializableElement(descriptor2, index2, serializer2, value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor2) {
        Encoder encoder2;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (StreamingJsonEncoderKt.isUnsignedNumber(descriptor2)) {
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            boolean $i$f$composerAs = false;
            if (this_$iv.composer instanceof ComposerForUnsignedNumbers) {
                composer = this_$iv.composer;
            } else {
                void p1;
                boolean bl2 = this_$iv.forceQuoting;
                InternalJsonWriter p0 = this_$iv.composer.writer;
                boolean bl3 = false;
                composer = new ComposerForUnsignedNumbers(p0, (boolean)p1);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer2 = composer;
            encoder2 = new StreamingJsonEncoder(composer2, json, writeMode, jsonEncoderArray);
        } else if (StreamingJsonEncoderKt.isUnquotedLiteral(descriptor2)) {
            Composer composer;
            StreamingJsonEncoder this_$iv = this;
            boolean $i$f$composerAs = false;
            if (this_$iv.composer instanceof ComposerForUnquotedLiterals) {
                composer = this_$iv.composer;
            } else {
                boolean p1 = this_$iv.forceQuoting;
                InternalJsonWriter p0 = this_$iv.composer.writer;
                boolean bl4 = false;
                composer = new ComposerForUnquotedLiterals(p0, p1);
            }
            JsonEncoder[] jsonEncoderArray = null;
            WriteMode writeMode = this.mode;
            Json json = this.getJson();
            Composer composer3 = composer;
            encoder2 = new StreamingJsonEncoder(composer3, json, writeMode, jsonEncoderArray);
        } else {
            encoder2 = super.encodeInline(descriptor2);
        }
        return encoder2;
    }

    private final /* synthetic */ <T extends Composer> T composerAs(Function2<? super InternalJsonWriter, ? super Boolean, ? extends T> composerCreator) {
        boolean $i$f$composerAs = false;
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        return (T)(this.composer instanceof Composer ? this.composer : (Composer)composerCreator.invoke((Object)this.composer.writer, (Object)this.forceQuoting));
    }

    @Override
    public void encodeNull() {
        this.composer.print("null");
    }

    @Override
    public void encodeBoolean(boolean value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeByte(byte value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeShort(short value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeInt(int value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeLong(long value2) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
    }

    @Override
    public void encodeFloat(float value2) {
        float f2;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Float.isInfinite(f2 = value2) && !Float.isNaN(f2))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf(value2), this.composer.writer.toString());
        }
    }

    @Override
    public void encodeDouble(double value2) {
        double d2;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value2));
        } else {
            this.composer.print(value2);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Double.isInfinite(d2 = value2) && !Double.isNaN(d2))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(value2, this.composer.writer.toString());
        }
    }

    @Override
    public void encodeChar(char value2) {
        this.encodeString(String.valueOf(value2));
    }

    @Override
    public void encodeString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.composer.printQuoted(value2);
    }

    @Override
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index2) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encodeString(enumDescriptor.getElementName(index2));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

